/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.StringMapDataDecoder;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.spring.data.connection.RedisClusterNodeDecoder;
import org.redisson.spring.data.connection.RedissonConnection;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.DefaultedRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;

public class RedissonClusterConnection
extends RedissonConnection
implements RedisClusterConnection,
DefaultedRedisClusterConnection {
    private static final RedisStrictCommand<List<RedisClusterNode>> CLUSTER_NODES = new RedisStrictCommand<Object>("CLUSTER", "NODES", new ObjectDecoder<List<RedisClusterNode>>(new RedisClusterNodeDecoder()));
    private static final RedisStrictCommand<List<String>> CLUSTER_GETKEYSINSLOT = new RedisStrictCommand("CLUSTER", "GETKEYSINSLOT", new ObjectListReplayDecoder());
    private final RedisStrictCommand<List<byte[]>> KEYS = new RedisStrictCommand("KEYS");
    private static final StringToRedisClientInfoConverter CONVERTER = new StringToRedisClientInfoConverter();

    public RedissonClusterConnection(RedissonClient redisson) {
        super(redisson);
    }

    @Override
    public Iterable<RedisClusterNode> clusterGetNodes() {
        return (Iterable)this.read(null, StringCodec.INSTANCE, CLUSTER_NODES, new Object[0]);
    }

    public Collection<RedisClusterNode> clusterGetReplicas(RedisClusterNode master) {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        RedisClusterNode masterNode = null;
        for (RedisClusterNode redisClusterNode : res) {
            if (!master.getHost().equals(redisClusterNode.getHost()) || !master.getPort().equals(redisClusterNode.getPort())) continue;
            masterNode = redisClusterNode;
            break;
        }
        if (masterNode == null) {
            throw new IllegalStateException("Unable to find master node: " + master);
        }
        Iterator<RedisClusterNode> iterator = res.iterator();
        while (iterator.hasNext()) {
            RedisClusterNode redisClusterNode;
            redisClusterNode = iterator.next();
            if (redisClusterNode.getMasterId() != null && redisClusterNode.getMasterId().equals(masterNode.getId())) continue;
            iterator.remove();
        }
        return (Collection)res;
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterReplicaMap() {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        HashSet<RedisClusterNode> masters = new HashSet<RedisClusterNode>();
        for (RedisClusterNode redisClusterNode : res) {
            if (!redisClusterNode.isMaster()) continue;
            masters.add(redisClusterNode);
        }
        HashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new HashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (RedisClusterNode redisClusterNode : res) {
            for (RedisClusterNode masterNode : masters) {
                if (redisClusterNode.getMasterId() == null || !redisClusterNode.getMasterId().equals(masterNode.getId())) continue;
                ArrayList<RedisClusterNode> list = (ArrayList<RedisClusterNode>)result.get(masterNode);
                if (list == null) {
                    list = new ArrayList<RedisClusterNode>();
                    result.put(masterNode, list);
                }
                list.add(redisClusterNode);
            }
        }
        return result;
    }

    @Override
    public Integer clusterGetSlotForKey(byte[] key) {
        RFuture f = this.executorService.readAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.KEYSLOT, new Object[]{key});
        return (Integer)this.syncFuture(f);
    }

    @Override
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        for (RedisClusterNode redisClusterNode : res) {
            if (!redisClusterNode.isMaster() || !redisClusterNode.getSlotRange().contains(slot)) continue;
            return redisClusterNode;
        }
        return null;
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        int slot = this.executorService.getConnectionManager().calcSlot(key);
        return this.clusterGetNodeForSlot(slot);
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        RFuture f = this.executorService.readAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_INFO, new Object[0]);
        Map entries = (Map)this.syncFuture(f);
        Properties props = new Properties();
        for (Map.Entry entry : entries.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return new ClusterInfo(props);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        MasterSlaveEntry entry = this.getEntry(node);
        List<Integer> params = this.convert(slots);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_ADDSLOTS, params.toArray());
        this.syncFuture(f);
    }

    protected List<Integer> convert(int ... slots) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        for (int slot : slots) {
            params.add(slot);
        }
        return params;
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(new InetSocketAddress(node.getHost(), (int)node.getPort()));
        RFuture f = this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_COUNTKEYSINSLOT, slot);
        return (Long)this.syncFuture(f);
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        MasterSlaveEntry entry = this.getEntry(node);
        List<Integer> params = this.convert(slots);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_DELSLOTS, params.toArray());
        this.syncFuture(f);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(RedisClusterNode node) {
        RFuture f = this.executorService.writeAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_FORGET, node.getId());
        this.syncFuture(f);
    }

    @Override
    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, "Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText(node.getHost(), "Node to meet cluster must have a host!");
        Assert.isTrue(node.getPort() > 0, "Node to meet cluster must have a port greater 0!");
        RFuture f = this.executorService.writeAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_MEET, node.getHost(), node.getPort());
        this.syncFuture(f);
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_SETSLOT, new Object[]{slot, mode});
        this.syncFuture(f);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        RFuture f = this.executorService.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, CLUSTER_GETKEYSINSLOT, slot, count);
        return (List)this.syncFuture(f);
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        MasterSlaveEntry entry = this.getEntry(master);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_REPLICATE, slave.getId());
        this.syncFuture(f);
    }

    @Override
    public void bgReWriteAof(RedisClusterNode node) {
        this.execute(node, RedisCommands.BGREWRITEAOF);
    }

    @Override
    public void bgSave(RedisClusterNode node) {
        this.execute(node, RedisCommands.BGSAVE);
    }

    @Override
    public Long lastSave(RedisClusterNode node) {
        return this.execute(node, RedisCommands.LASTSAVE);
    }

    @Override
    public void save(RedisClusterNode node) {
        this.execute(node, RedisCommands.SAVE);
    }

    @Override
    public Long dbSize(RedisClusterNode node) {
        return this.execute(node, RedisCommands.DBSIZE);
    }

    private <T> T execute(RedisClusterNode node, RedisCommand<T> command) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, command, new Object[0]);
        return (T)this.syncFuture(f);
    }

    protected MasterSlaveEntry getEntry(RedisClusterNode node) {
        MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(new InetSocketAddress(node.getHost(), (int)node.getPort()));
        return entry;
    }

    @Override
    public void flushDb(RedisClusterNode node) {
        this.execute(node, RedisCommands.FLUSHDB);
    }

    @Override
    public void flushAll(RedisClusterNode node) {
        this.execute(node, RedisCommands.FLUSHALL);
    }

    @Override
    public Properties info(RedisClusterNode node) {
        Map<String, String> info = this.execute(node, RedisCommands.INFO_ALL);
        Properties result = new Properties();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Properties info(RedisClusterNode node, String section) {
        RedisStrictCommand<Map<String, String>> command = new RedisStrictCommand<Map<String, String>>("INFO", section, new StringMapDataDecoder());
        Map<String, String> info = this.execute(node, command);
        Properties result = new Properties();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)ByteArrayCodec.INSTANCE, this.KEYS, new Object[]{pattern});
        Collection keys = (Collection)this.syncFuture(f);
        return new HashSet<byte[]>(keys);
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readRandomAsync(entry, ByteArrayCodec.INSTANCE, RedisCommands.RANDOM_KEY, new Object[0]);
        return (byte[])this.syncFuture(f);
    }

    @Override
    public void shutdown(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SHUTDOWN, new Object[0]);
        this.syncFuture(f);
    }

    @Override
    public Properties getConfig(RedisClusterNode node, String pattern) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CONFIG_GET, pattern);
        List r = (List)this.syncFuture(f);
        if (r != null) {
            return Converters.toProperties(r);
        }
        return null;
    }

    @Override
    public void setConfig(RedisClusterNode node, String param, String value) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CONFIG_SET, param, value);
        this.syncFuture(f);
    }

    @Override
    public void resetConfigStats(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CONFIG_RESETSTAT, new Object[0]);
        this.syncFuture(f);
    }

    @Override
    public Long time(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)LongCodec.INSTANCE, RedisCommands.TIME_LONG, new Object[0]);
        return (Long)this.syncFuture(f);
    }

    @Override
    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.CLIENT_LIST, new Object[0]);
        List list = (List)this.syncFuture(f);
        return CONVERTER.convert(list.toArray(new String[list.size()]));
    }

    @Override
    public Cursor<byte[]> scan(final RedisClusterNode node, ScanOptions options) {
        return new ScanCursor<byte[]>(0L, options){
            private RedisClient client;
            private MasterSlaveEntry entry;
            {
                super(arg0, arg1);
                this.entry = RedissonClusterConnection.this.getEntry(node);
            }

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (RedissonClusterConnection.this.isQueueing() || RedissonClusterConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                if (this.entry == null) {
                    return null;
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(Long.toUnsignedString(cursorId));
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonClusterConnection.this.executorService.readAsync(this.client, this.entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonClusterConnection.this.syncFuture(f);
                String pos = res.getPos();
                this.client = res.getRedisClient();
                if ("0".equals(pos)) {
                    this.entry = null;
                }
                return new ScanIteration<byte[]>(Long.parseUnsignedLong(pos), res.getValues());
            }
        }.open();
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        if (this.isPipelined()) {
            throw new InvalidDataAccessResourceUsageException("Clustered rename is not supported in a pipeline");
        }
        if (this.redisson.getConnectionManager().calcSlot(oldName) == this.redisson.getConnectionManager().calcSlot(newName)) {
            super.rename(oldName, newName);
            return;
        }
        byte[] value = this.dump(oldName);
        if (null != value) {
            Long sourceTtlInSeconds = this.ttl(oldName);
            long ttlInMilliseconds = null != sourceTtlInSeconds && sourceTtlInSeconds > 0L ? sourceTtlInSeconds * 1000L : 0L;
            this.restore(newName, ttlInMilliseconds, value);
            this.del(new byte[][]{oldName});
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        if (this.isPipelined()) {
            throw new InvalidDataAccessResourceUsageException("Clustered rename is not supported in a pipeline");
        }
        if (this.redisson.getConnectionManager().calcSlot(oldName) == this.redisson.getConnectionManager().calcSlot(newName)) {
            return super.renameNX(oldName, newName);
        }
        byte[] value = this.dump(oldName);
        if (null != value && !this.exists(newName).booleanValue()) {
            Long sourceTtlInSeconds = this.ttl(oldName);
            long ttlInMilliseconds = null != sourceTtlInSeconds && sourceTtlInSeconds > 0L ? sourceTtlInSeconds * 1000L : 0L;
            this.restore(newName, ttlInMilliseconds, value);
            this.del(new byte[][]{oldName});
            return true;
        }
        return false;
    }

    @Override
    public Long del(byte[] ... keys) {
        if (this.isQueueing() || this.isPipelined()) {
            for (byte[] key : keys) {
                this.write(key, LongCodec.INSTANCE, RedisCommands.DEL, new Object[]{key});
            }
            return null;
        }
        CommandBatchService es = new CommandBatchService(this.executorService);
        for (byte[] key : keys) {
            es.writeAsync(key, (Codec)StringCodec.INSTANCE, RedisCommands.DEL, new Object[]{key});
        }
        BatchResult<?> b = es.execute();
        return b.getResponses().stream().collect(Collectors.summarizingLong(v -> v)).getSum();
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        if (this.isQueueing() || this.isPipelined()) {
            for (byte[] key : keys) {
                this.read(key, ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
            }
            return null;
        }
        CommandBatchService es = new CommandBatchService(this.executorService);
        for (byte[] key : keys) {
            es.readAsync(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
        }
        BatchResult<?> r = es.execute();
        return r.getResponses();
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuple) {
        if (this.isQueueing() || this.isPipelined()) {
            for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
                this.write(entry.getKey(), StringCodec.INSTANCE, RedisCommands.SET, entry.getKey(), entry.getValue());
            }
            return true;
        }
        CommandBatchService es = new CommandBatchService(this.executorService);
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            es.writeAsync(entry.getKey(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, entry.getKey(), entry.getValue());
        }
        es.execute();
        return true;
    }

    public RedisClusterCommands clusterCommands() {
        return this;
    }

    @Override
    public RedisClusterServerCommands serverCommands() {
        return this;
    }

    @Override
    public String ping(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)LongCodec.INSTANCE, RedisCommands.PING, new Object[0]);
        return (String)this.syncFuture(f);
    }
}

