/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.Redisson;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanNullSafeReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.DoubleReplayConvertor;
import org.redisson.client.protocol.convertor.EmptyListConvertor;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.client.protocol.decoder.TimeLongObjectDecoder;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.spring.data.connection.BinaryConvertor;
import org.redisson.spring.data.connection.DataTypeConvertor;
import org.redisson.spring.data.connection.DistanceConvertor;
import org.redisson.spring.data.connection.GeoResultsDecoder;
import org.redisson.spring.data.connection.ListMergeDecoder;
import org.redisson.spring.data.connection.ObjectListReplayDecoder2;
import org.redisson.spring.data.connection.ObjectMapEntryReplayDecoder;
import org.redisson.spring.data.connection.PointDecoder;
import org.redisson.spring.data.connection.PropertiesDecoder;
import org.redisson.spring.data.connection.PropertiesListDecoder;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.data.connection.RedissonStreamCommands;
import org.redisson.spring.data.connection.RedissonSubscription;
import org.redisson.spring.data.connection.ScoredSortedListReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoderV2;
import org.redisson.spring.data.connection.ScoredSortedSingleBlockingReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSingleReplayDecoder;
import org.redisson.spring.data.connection.SecondsConvertor;
import org.redisson.spring.data.connection.SingleMapEntryDecoder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.domain.geo.BoxShape;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.data.redis.domain.geo.RadiusShape;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class RedissonConnection
extends AbstractRedisConnection {
    private boolean closed;
    protected final Redisson redisson;
    CommandAsyncService executorService;
    private RedissonSubscription subscription;
    private static final RedisStrictCommand<DataType> TYPE = new RedisStrictCommand<DataType>("TYPE", new DataTypeConvertor());
    private static final RedisStrictCommand<Set<byte[]>> KEYS = new RedisStrictCommand("KEYS", new ObjectSetReplayDecoder());
    private static final RedisStrictCommand<Boolean> EXPIRE = new RedisStrictCommand<Boolean>("EXPIRE", new BooleanReplayConvertor());
    private static final RedisStrictCommand<Boolean> EXPIREAT = new RedisStrictCommand<Boolean>("EXPIREAT", new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> TTL = new RedisStrictCommand("TTL");
    private static final RedisCommand<Long> SORT_TO = new RedisCommand("SORT");
    private static final RedisCommand<List<Object>> MGET = new RedisCommand("MGET", new ObjectListReplayDecoder());
    private static final RedisCommand<Boolean> SET = new RedisCommand<Boolean>("SET", new BooleanNullSafeReplayConvertor());
    private static final RedisCommand<Boolean> SETEX = new RedisCommand<Boolean>("SETEX", new BooleanReplayConvertor());
    private static final RedisCommand<Boolean> PSETEX = new RedisCommand<Boolean>("PSETEX", new BooleanReplayConvertor());
    private static final RedisCommand<Boolean> MSET = new RedisCommand<Boolean>("MSET", new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> DECRBY = new RedisStrictCommand("DECRBY");
    private static final RedisStrictCommand<Long> APPEND = new RedisStrictCommand("APPEND");
    private static final RedisCommand<Object> GETRANGE = new RedisCommand("GETRANGE");
    private static final RedisCommand<Void> SETRANGE = new RedisCommand<Void>("SETRANGE", new VoidReplayConvertor());
    private static final RedisStrictCommand<Long> BITOP = new RedisStrictCommand("BITOP");
    private static final RedisStrictCommand<Long> RPUSH = new RedisStrictCommand("RPUSH");
    private static final RedisStrictCommand<Long> LPUSH = new RedisStrictCommand("LPUSH");
    private static final RedisStrictCommand<Long> RPUSHX = new RedisStrictCommand("RPUSHX");
    private static final RedisStrictCommand<Long> LPUSHX = new RedisStrictCommand("LPUSHX");
    private static final RedisStrictCommand<Long> LLEN = new RedisStrictCommand("LLEN");
    private static final RedisStrictCommand<Long> LINSERT = new RedisStrictCommand("LINSERT");
    private final List<String> commandsToRemove = Arrays.asList("SET", "RESTORE", "LTRIM", "SETEX", "SETRANGE", "FLUSHDB", "LSET", "MSET", "HMSET", "RENAME");
    private final List<Integer> indexToRemove = new ArrayList<Integer>();
    private int index = -1;
    private static final RedisStrictCommand<Long> LREM = new RedisStrictCommand("LREM");
    private static final RedisCommand<List<Long>> LPOS = new RedisCommand("LPOS", new ObjectListReplayDecoder());
    private static final RedisCommand<Long> SADD = new RedisCommand("SADD");
    private static final RedisStrictCommand<Long> SREM = new RedisStrictCommand("SREM");
    private static final RedisCommand<List<Object>> SPOP = new RedisCommand("SPOP", new ObjectListReplayDecoder());
    private static final RedisStrictCommand<Long> SCARD = new RedisStrictCommand("SCARD");
    private static final RedisCommand<List<Object>> SRANDMEMBER = new RedisCommand("SRANDMEMBER", new ObjectListReplayDecoder());
    private static final RedisCommand<Set<Object>> ZRANGE = new RedisCommand("ZRANGE", new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZRANGE_ENTRY = new RedisCommand<Set<Tuple>>("ZRANGE", new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZRANGE_ENTRY_V2 = new RedisCommand<Object>("ZRANGE", new ListMultiDecoder2(new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()));
    private static final RedisCommand<Set<Tuple>> ZRANGEBYSCORE = new RedisCommand<Set<Tuple>>("ZRANGEBYSCORE", new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZRANGEBYSCORE_V2 = new RedisCommand<Object>("ZRANGEBYSCORE", new ListMultiDecoder2(new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()));
    private static final RedisCommand<Set<Object>> ZREVRANGE = new RedisCommand("ZREVRANGE", new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGE_ENTRY = new RedisCommand<Set<Tuple>>("ZREVRANGE", new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGE_ENTRY_V2 = new RedisCommand<Object>("ZREVRANGE", new ListMultiDecoder2(new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()));
    private static final RedisCommand<Set<byte[]>> ZREVRANGEBYSCORE = new RedisCommand("ZREVRANGEBYSCORE", new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGEBYSCOREWITHSCORES = new RedisCommand<Set<Tuple>>("ZREVRANGEBYSCORE", new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGEBYSCOREWITHSCORES_V2 = new RedisCommand<Object>("ZREVRANGEBYSCORE", new ListMultiDecoder2(new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()));
    private static final RedisStrictCommand<Long> ZCOUNT = new RedisStrictCommand("ZCOUNT");
    private static final RedisStrictCommand<Long> ZREMRANGEBYRANK = new RedisStrictCommand("ZREMRANGEBYRANK");
    private static final RedisStrictCommand<Long> ZREMRANGEBYSCORE = new RedisStrictCommand("ZREMRANGEBYSCORE");
    private static final RedisStrictCommand<Long> ZUNIONSTORE = new RedisStrictCommand("ZUNIONSTORE");
    private static final RedisStrictCommand<Long> ZINTERSTORE = new RedisStrictCommand("ZINTERSTORE");
    private static final RedisCommand<ListScanResult<Object>> ZSCAN = new RedisCommand<Object>("ZSCAN", new ListMultiDecoder2(new ListScanResultReplayDecoder(), new ScoredSortedListReplayDecoder()));
    private static final RedisCommand<Set<Object>> ZRANGEBYLEX = new RedisCommand("ZRANGEBYLEX", new ObjectSetReplayDecoder());
    private static final RedisCommand<List<Object>> HMGET = new RedisCommand("HMGET", new ObjectListReplayDecoder());
    private static final RedisCommand<Long> HINCRBY = new RedisCommand("HINCRBY");
    private static final RedisCommand<Double> HINCRBYFLOAT = new RedisCommand<Double>("HINCRBYFLOAT", new DoubleReplayConvertor());
    private static final RedisStrictCommand<Long> HLEN = new RedisStrictCommand("HLEN");
    private static final RedisCommand<Object> ECHO = new RedisCommand("ECHO");
    private static final RedisStrictCommand<Void> SAVE = new RedisStrictCommand<Void>("SAVE", new VoidReplayConvertor());
    private static final RedisStrictCommand<Properties> INFO_DEFAULT = new RedisStrictCommand<Object>("INFO", "DEFAULT", new ObjectDecoder<Properties>(new PropertiesDecoder()));
    private static final RedisStrictCommand<Properties> INFO = new RedisStrictCommand<Object>("INFO", new ObjectDecoder<Properties>(new PropertiesDecoder()));
    private static final RedisStrictCommand<Properties> CONFIG_GET = new RedisStrictCommand<Properties>("CONFIG", "GET", new PropertiesListDecoder());
    private static final RedisCommand<List<Object>> GEOHASH = new RedisCommand("GEOHASH", new ObjectListReplayDecoder());
    private final MultiDecoder<Map<Object, Object>> geoDecoder = new ListMultiDecoder2(new ObjectListReplayDecoder2(), new PointDecoder());
    private final MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> postitionDecoder = new ListMultiDecoder2(new GeoResultsDecoder(), new CodecDecoder(), new PointDecoder(), new ObjectListReplayDecoder());
    private static final RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> GEORADIUSBYMEMBER = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>("GEORADIUSBYMEMBER_RO", new GeoResultsDecoder());
    private static final RedisCommand<Long> PFADD = new RedisCommand("PFADD");
    private static final RedisCommand<Long> HSTRLEN = new RedisCommand("HSTRLEN");
    private static final RedisStrictCommand<List<Object>> BITFIELD = new RedisStrictCommand("BITFIELD", new ObjectListReplayDecoder());
    private static final RedisStrictCommand<ValueEncoding> OBJECT_ENCODING = new RedisStrictCommand<ValueEncoding>("OBJECT", "ENCODING", new Convertor<ValueEncoding>(){

        @Override
        public ValueEncoding convert(Object obj) {
            return ValueEncoding.of((String)obj);
        }
    });
    private static final RedisStrictCommand<Duration> OBJECT_IDLETIME = new RedisStrictCommand<Duration>("OBJECT", "IDLETIME", new Convertor<Duration>(){

        @Override
        public Duration convert(Object obj) {
            return Duration.ofSeconds((Long)obj);
        }
    });
    private static final RedisStrictCommand<Long> OBJECT_REFCOUNT = new RedisStrictCommand("OBJECT", "REFCOUNT");
    private static final RedisStrictCommand<Long> BITPOS = new RedisStrictCommand("BITPOS");
    private static final RedisCommand<List<Object>> ZRANDMEMBER_LIST = new RedisCommand("ZRANDMEMBER", new ObjectListReplayDecoder());
    private static final RedisCommand<Tuple> ZRANDMEMBER_SCORE = new RedisCommand<Tuple>("ZRANDMEMBER", new ScoredSortedSingleReplayDecoder());
    private static final RedisCommand<List<Tuple>> ZRANDMEMBER_SCORE_LIST = new RedisCommand<List<Tuple>>("ZRANDMEMBER", new ScoredSortedListReplayDecoder());
    private static final RedisCommand<Tuple> ZPOPMIN = new RedisCommand<Tuple>("ZPOPMIN", new ScoredSortedSingleReplayDecoder());
    private static final RedisCommand<Tuple> BZPOPMIN = new RedisCommand<Tuple>("BZPOPMIN", new ScoredSortedSingleBlockingReplayDecoder());
    private static final RedisCommand<Tuple> ZPOPMAX = new RedisCommand<Tuple>("ZPOPMAX", new ScoredSortedSingleReplayDecoder());
    private static final RedisCommand<Tuple> BZPOPMAX = new RedisCommand<Tuple>("BZPOPMAX", new ScoredSortedSingleBlockingReplayDecoder());
    private static final RedisCommand<List<Object>> ZMSCORE = new RedisCommand("ZMSCORE", new ObjectListReplayDecoder());
    private static final RedisCommand<Set<Object>> ZDIFF = new RedisCommand("ZDIFF", new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZDIFF_SCORE = new RedisCommand<Set<Tuple>>("ZDIFF", new ScoredSortedSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZDIFFSTORE = new RedisStrictCommand("ZDIFFSTORE");
    private static final RedisCommand<Set<Object>> ZINTER = new RedisCommand("ZINTER", new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZINTER_SCORE = new RedisCommand<Set<Tuple>>("ZINTER", new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZUNION = new RedisCommand("ZUNION", new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZUNION_SCORE = new RedisCommand<Set<Tuple>>("ZUNION", new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Object> HRANDFIELD = new RedisCommand("HRANDFIELD");
    private static final RedisCommand<Map.Entry<Object, Object>> HRANDFIELD_SINGLE_V2 = new RedisCommand<Object>("HRANDFIELD", new ListMultiDecoder2(new ListFirstObjectDecoder(), new SingleMapEntryDecoder()));
    private static final RedisCommand<Map.Entry<Object, Object>> HRANDFIELD_SINGLE = new RedisCommand<Map.Entry<Object, Object>>("HRANDFIELD", new SingleMapEntryDecoder());
    private static final RedisCommand<List<Object>> HRANDFIELD_LIST = new RedisCommand("HRANDFIELD", new ObjectListReplayDecoder());
    private static final RedisCommand<List<Map.Entry<Object, Object>>> HRANDFIELD_VALUES_V2 = new RedisCommand<Object>("HRANDFIELD", new ListMultiDecoder2(new ListMergeDecoder(), new ObjectMapEntryReplayDecoder()), new EmptyListConvertor());
    private static final RedisCommand<List<Map.Entry<Object, Object>>> HRANDFIELD_VALUES = new RedisCommand<Object>("HRANDFIELD", new ObjectMapEntryReplayDecoder(), new EmptyListConvertor());
    private static final RedisCommand<List<Boolean>> SMISMEMBER = new RedisCommand("SMISMEMBER", new ObjectListReplayDecoder());
    private static final RedisCommand<Object> GETEX = new RedisCommand("GETEX");
    private static final RedisCommand<Object> GETDEL = new RedisCommand("GETDEL");
    private static final RedisCommand<Set<byte[]>> ZREVRANGEBYLEX = new RedisCommand("ZREVRANGEBYLEX", new ObjectSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZREMRANGEBYLEX = new RedisStrictCommand("ZREMRANGEBYLEX");
    private static final RedisStrictCommand<Long> ZLEXCOUNT = new RedisStrictCommand("ZLEXCOUNT");
    public static final RedisCommand<Long> ZRANGESTORE = new RedisCommand("ZRANGESTORE");
    private static final RedisStrictCommand<Void> REPLICAOF = new RedisStrictCommand("REPLICAOF");

    public RedissonConnection(RedissonClient redisson) {
        this.redisson = (Redisson)redisson;
        this.executorService = (CommandAsyncService)this.redisson.getCommandExecutor();
    }

    @Override
    public void close() throws DataAccessException {
        CommandBatchService es;
        super.close();
        if (this.isQueueing() && !(es = (CommandBatchService)this.executorService).isExecuted()) {
            this.discard();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Object getNativeConnection() {
        return this.redisson;
    }

    @Override
    public boolean isQueueing() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC;
        }
        return false;
    }

    @Override
    public boolean isPipelined() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY || es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC;
        }
        return false;
    }

    public boolean isPipelinedAtomic() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC;
        }
        return false;
    }

    @Override
    public void openPipeline() {
        BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY);
        this.executorService = new CommandBatchService((CommandAsyncExecutor)this.executorService, options);
    }

    @Override
    public List<Object> closePipeline() throws RedisPipelineException {
        if (this.isPipelined()) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            try {
                BatchResult<?> result = es.execute();
                this.filterResults(result);
                if (this.isPipelinedAtomic()) {
                    List<Object> list = Arrays.asList(result.getResponses());
                    return list;
                }
                List<Object> list = result.getResponses();
                return list;
            }
            catch (Exception ex) {
                throw new RedisPipelineException(ex);
            }
            finally {
                this.resetConnection();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase(command) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != args.length) continue;
            try {
                Object t = this.execute(method, args);
                if (t instanceof String) {
                    return ((String)t).getBytes();
                }
                return t;
            }
            catch (IllegalArgumentException e) {
                if (this.isPipelined()) {
                    throw new RedisPipelineException(e);
                }
                throw new InvalidDataAccessApiUsageException(e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object execute(Method method, byte[] ... args) {
        if (method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == byte[][].class) {
            return ReflectionUtils.invokeMethod(method, this, (Object[])args);
        }
        if (args == null) {
            return ReflectionUtils.invokeMethod(method, this);
        }
        return ReflectionUtils.invokeMethod(method, this, Arrays.asList(args).toArray());
    }

    <V> V syncFuture(RFuture<V> future) {
        try {
            return this.executorService.get(future);
        }
        catch (Exception ex) {
            throw this.transform(ex);
        }
    }

    protected RuntimeException transform(Exception ex) {
        DataAccessException exception = RedissonConnectionFactory.EXCEPTION_TRANSLATION.translate(ex);
        if (exception != null) {
            return exception;
        }
        return new RedisSystemException(ex.getMessage(), ex);
    }

    @Override
    public Boolean exists(byte[] key) {
        return (Boolean)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.EXISTS, new Object[]{key});
    }

    @Override
    public Long del(byte[] ... keys) {
        return (Long)this.write(keys[0], LongCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.DEL, Arrays.asList(keys).toArray());
    }

    @Override
    public Long unlink(byte[] ... keys) {
        return (Long)this.write(keys[0], LongCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.UNLINK, Arrays.asList(keys).toArray());
    }

    @Override
    public DataType type(byte[] key) {
        return (DataType)((Object)this.read(key, StringCodec.INSTANCE, TYPE, new Object[]{key}));
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        if (this.isQueueing()) {
            return (Set)this.read(null, ByteArrayCodec.INSTANCE, KEYS, new Object[]{pattern});
        }
        List futures = this.executorService.readAllAsync(ByteArrayCodec.INSTANCE, KEYS, new Object[]{pattern});
        CompletableFuture<Void> ff = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletableFuture future = ((CompletableFuture)ff.thenApply(r -> futures.stream().flatMap(f -> ((Set)f.getNow(new HashSet())).stream()).collect(Collectors.toSet()))).toCompletableFuture();
        return (Set)this.sync(new CompletableFutureWrapper(future));
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return new ScanCursor<byte[]>(0L, options){
            private RedisClient client;
            private Iterator<MasterSlaveEntry> entries;
            private MasterSlaveEntry entry;
            {
                this.entries = RedissonConnection.this.redisson.getConnectionManager().getEntrySet().iterator();
                this.entry = this.entries.next();
            }

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                if (this.entry == null) {
                    return null;
                }
                ArrayList<Object> args = new ArrayList<Object>();
                if (cursorId == 101010101010101010L) {
                    cursorId = 0L;
                }
                args.add(Long.toUnsignedString(cursorId));
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, this.entry, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                String pos = res.getPos();
                this.client = res.getRedisClient();
                if ("0".equals(pos)) {
                    if (this.entries.hasNext()) {
                        pos = "101010101010101010";
                        this.entry = this.entries.next();
                        this.client = null;
                    } else {
                        this.entry = null;
                    }
                }
                return new ScanIteration<byte[]>(Long.parseUnsignedLong(pos), res.getValues());
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        if (this.isQueueing()) {
            return (byte[])this.read(null, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RANDOM_KEY, new Object[0]);
        }
        RFuture f = this.executorService.readRandomAsync(ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RANDOM_KEY, new Object[0]);
        return (byte[])this.sync(f);
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        this.write(oldName, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RENAME, oldName, newName);
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        return (Boolean)this.write(oldName, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RENAMENX, oldName, newName);
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, EXPIRE, key, seconds);
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PEXPIRE, key, millis);
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, EXPIREAT, key, unixTime);
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PEXPIREAT, key, unixTimeInMillis);
    }

    @Override
    public Boolean persist(byte[] key) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PERSIST, new Object[]{key});
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.MOVE, key, dbIndex);
    }

    @Override
    public Long ttl(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, TTL, new Object[]{key});
    }

    protected <T> T sync(RFuture<T> f) {
        if (this.isPipelined()) {
            return null;
        }
        if (this.isQueueing()) {
            ((BatchPromise)f.toCompletableFuture()).getSentPromise().join();
            return null;
        }
        return this.syncFuture(f);
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.read(key, StringCodec.INSTANCE, new RedisStrictCommand<Long>("TTL", new SecondsConvertor(timeUnit, TimeUnit.SECONDS)), new Object[]{key});
    }

    @Override
    public Long pTtl(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PTTL, new Object[]{key});
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.read(key, StringCodec.INSTANCE, new RedisStrictCommand<Long>("PTTL", new SecondsConvertor(timeUnit, TimeUnit.MILLISECONDS)), new Object[]{key});
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters sortParams) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (sortParams != null) {
            Boolean isAlpha;
            if (sortParams.getByPattern() != null) {
                params.add("BY");
                params.add(sortParams.getByPattern());
            }
            if (sortParams.getLimit() != null) {
                params.add("LIMIT");
                if (sortParams.getLimit().getStart() != -1L) {
                    params.add(sortParams.getLimit().getStart());
                }
                if (sortParams.getLimit().getCount() != -1L) {
                    params.add(sortParams.getLimit().getCount());
                }
            }
            if (sortParams.getGetPattern() != null) {
                for (byte[] pattern : sortParams.getGetPattern()) {
                    params.add("GET");
                    params.add(pattern);
                }
            }
            if (sortParams.getOrder() != null) {
                params.add((Object)sortParams.getOrder());
            }
            if ((isAlpha = sortParams.isAlphabetic()) != null && isAlpha.booleanValue()) {
                params.add("ALPHA");
            }
        }
        return (List)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SORT_LIST, params.toArray());
    }

    @Override
    public Long sort(byte[] key, SortParameters sortParams, byte[] storeKey) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (sortParams != null) {
            Boolean isAlpha;
            if (sortParams.getByPattern() != null) {
                params.add("BY");
                params.add(sortParams.getByPattern());
            }
            if (sortParams.getLimit() != null) {
                params.add("LIMIT");
                if (sortParams.getLimit().getStart() != -1L) {
                    params.add(sortParams.getLimit().getStart());
                }
                if (sortParams.getLimit().getCount() != -1L) {
                    params.add(sortParams.getLimit().getCount());
                }
            }
            if (sortParams.getGetPattern() != null) {
                for (byte[] pattern : sortParams.getGetPattern()) {
                    params.add("GET");
                    params.add(pattern);
                }
            }
            if (sortParams.getOrder() != null) {
                params.add((Object)sortParams.getOrder());
            }
            if ((isAlpha = sortParams.isAlphabetic()) != null && isAlpha.booleanValue()) {
                params.add("ALPHA");
            }
        }
        params.add("STORE");
        params.add(storeKey);
        return (Long)this.read(key, ByteArrayCodec.INSTANCE, SORT_TO, params.toArray());
    }

    @Override
    public byte[] dump(byte[] key) {
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.DUMP, new Object[]{key});
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RESTORE, key, ttlInMillis, serializedValue);
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GET, new Object[]{key});
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GETSET, key, value);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        return (List)this.read(keys[0], ByteArrayCodec.INSTANCE, MGET, Arrays.asList(keys).toArray());
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, SET, key, value);
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        if (expiration == null) {
            return this.set(key, value);
        }
        if (expiration.isPersistent()) {
            if (option == null || option == RedisStringCommands.SetOption.UPSERT) {
                return this.set(key, value);
            }
            if (option == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                return (Boolean)this.write(key, StringCodec.INSTANCE, SET, key, value, "NX");
            }
            if (option == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                return (Boolean)this.write(key, StringCodec.INSTANCE, SET, key, value, "XX");
            }
        } else {
            if (option == null || option == RedisStringCommands.SetOption.UPSERT) {
                return (Boolean)this.write(key, StringCodec.INSTANCE, SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds());
            }
            if (option == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                return (Boolean)this.write(key, StringCodec.INSTANCE, SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds(), "NX");
            }
            if (option == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                return (Boolean)this.write(key, StringCodec.INSTANCE, SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds(), "XX");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SETNX, key, value);
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, SETEX, key, seconds, value);
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, PSETEX, key, milliseconds, value);
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuple) {
        List<byte[]> params = this.convert(tuple);
        return (Boolean)this.write(tuple.keySet().iterator().next(), StringCodec.INSTANCE, MSET, params.toArray());
    }

    protected List<byte[]> convert(Map<byte[], byte[]> tuple) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(tuple.size() * 2);
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        return params;
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        List<byte[]> params = this.convert(tuple);
        return (Boolean)this.write(tuple.keySet().iterator().next(), StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.MSETNX, params.toArray());
    }

    @Override
    public Long incr(byte[] key) {
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.INCR, new Object[]{key});
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.INCRBY, key, value);
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        return (Double)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.INCRBYFLOAT, key, BigDecimal.valueOf(value).toPlainString());
    }

    @Override
    public Long decr(byte[] key) {
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.DECR, new Object[]{key});
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        return (Long)this.write(key, StringCodec.INSTANCE, DECRBY, key, value);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        return (Long)this.write(key, StringCodec.INSTANCE, APPEND, key, value);
    }

    @Override
    public byte[] getRange(byte[] key, long begin, long end) {
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, GETRANGE, key, begin, end);
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        this.write(key, ByteArrayCodec.INSTANCE, SETRANGE, key, offset, value);
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        return (Boolean)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GETBIT, key, offset);
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SETBIT, key, offset, value ? 1 : 0);
    }

    @Override
    public Long bitCount(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BITCOUNT, new Object[]{key});
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BITCOUNT, key, begin, end);
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("NOT operation doesn't support more than single source key");
        }
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 2);
        params.add((Object)op);
        params.add(destination);
        params.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], StringCodec.INSTANCE, BITOP, params.toArray());
    }

    @Override
    public Long strLen(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.STRLEN, new Object[]{key});
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, StringCodec.INSTANCE, RPUSH, args.toArray());
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, StringCodec.INSTANCE, LPUSH, args.toArray());
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        return (Long)this.write(key, StringCodec.INSTANCE, RPUSHX, key, value);
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        return (Long)this.write(key, StringCodec.INSTANCE, LPUSHX, key, value);
    }

    @Override
    public Long lLen(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, LLEN, new Object[]{key});
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        return (List)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LRANGE, key, start, end);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LTRIM, key, start, end);
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LINDEX, key, index);
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return (Long)this.write(key, StringCodec.INSTANCE, LINSERT, new Object[]{key, where, pivot, value});
    }

    <T> T write(byte[] key, Codec codec, RedisCommand<?> command, Object ... params) {
        RFuture f = this.executorService.writeAsync(key, codec, command, params);
        this.indexCommand(command);
        return (T)this.sync(f);
    }

    protected void indexCommand(RedisCommand<?> command) {
        if (this.isQueueing() || this.isPipelined()) {
            ++this.index;
            if (this.commandsToRemove.contains(command.getName())) {
                this.indexToRemove.add(this.index);
            }
        }
    }

    <T> T read(byte[] key, Codec codec, RedisCommand<?> command, Object ... params) {
        RFuture f = this.executorService.readAsync(key, codec, command, params);
        this.indexCommand(command);
        return (T)this.sync(f);
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LSET, key, index, value);
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        return (Long)this.write(key, StringCodec.INSTANCE, LREM, key, count, value);
    }

    @Override
    public byte[] lPop(byte[] key) {
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LPOP, new Object[]{key});
    }

    @Override
    public byte[] rPop(byte[] key) {
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RPOP, new Object[]{key});
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.addAll(Arrays.asList(keys));
        params.add(timeout);
        return (List)this.write(keys[0], ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BLPOP, params.toArray());
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.addAll(Arrays.asList(keys));
        params.add(timeout);
        return (List)this.write(keys[0], ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BRPOP, params.toArray());
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return (byte[])this.write(srcKey, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RPOPLPUSH, srcKey, dstKey);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return (byte[])this.write(srcKey, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BRPOPLPUSH, srcKey, dstKey, timeout);
    }

    @Override
    public List<Long> lPos(byte[] key, byte[] element, Integer rank, Integer count) {
        Object read;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(element);
        if (rank != null) {
            args.add("RANK");
            args.add(rank);
        }
        if (count != null) {
            args.add("COUNT");
            args.add(count);
        }
        if ((read = this.read(key, ByteArrayCodec.INSTANCE, LPOS, args.toArray())) == null) {
            return Collections.emptyList();
        }
        if (read instanceof Long) {
            return Collections.singletonList((Long)read);
        }
        return (List)read;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, StringCodec.INSTANCE, SADD, args.toArray());
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, StringCodec.INSTANCE, SREM, args.toArray());
    }

    @Override
    public byte[] sPop(byte[] key) {
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SPOP_SINGLE, new Object[]{key});
    }

    @Override
    public List<byte[]> sPop(byte[] key, long count) {
        return (List)this.write(key, ByteArrayCodec.INSTANCE, SPOP, key, count);
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return (Boolean)this.write(srcKey, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SMOVE, srcKey, destKey, value);
    }

    @Override
    public Long sCard(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, SCARD, new Object[]{key});
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        return (Boolean)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SISMEMBER, key, value);
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        return (Set)this.write(keys[0], ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SINTER, Arrays.asList(keys).toArray());
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SINTERSTORE, args.toArray());
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        return (Set)this.write(keys[0], ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SUNION, Arrays.asList(keys).toArray());
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SUNIONSTORE, args.toArray());
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        return (Set)this.write(keys[0], ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SDIFF, Arrays.asList(keys).toArray());
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SDIFFSTORE, args.toArray());
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SMEMBERS, new Object[]{key});
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SRANDMEMBER_SINGLE, new Object[]{key});
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        return (List)this.read(key, ByteArrayCodec.INSTANCE, SRANDMEMBER, key, count);
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, 0L, options){
            private RedisClient client;

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(Long.toUnsignedString(cursorId));
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SSCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration<byte[]>(Long.parseUnsignedLong(res.getPos()), res.getValues());
            }
        }.open();
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value, RedisZSetCommands.ZAddArgs args) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.XX)) {
            params.add("XX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.NX)) {
            params.add("NX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.GT)) {
            params.add("GT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.LT)) {
            params.add("LT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.CH)) {
            params.add("CH");
        }
        params.add(BigDecimal.valueOf(score).toPlainString());
        params.add(value);
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZADD_BOOL, params.toArray());
    }

    public Long zAdd(byte[] key, Set<Tuple> tuples, RedisZSetCommands.ZAddArgs args) {
        ArrayList<Object> params = new ArrayList<Object>(tuples.size() * 2 + 1);
        params.add(key);
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.XX)) {
            params.add("XX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.NX)) {
            params.add("NX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.GT)) {
            params.add("GT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.LT)) {
            params.add("LT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.CH)) {
            params.add("CH");
        }
        for (Tuple entry : tuples) {
            params.add(BigDecimal.valueOf(entry.getScore()).toPlainString());
            params.add(entry.getValue());
        }
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZADD, params.toArray());
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        ArrayList<Object> params = new ArrayList<Object>(values.length + 1);
        params.add(key);
        params.addAll(Arrays.asList(values));
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZREM_LONG, params.toArray());
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return (Double)this.write(key, DoubleCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZINCRBY, key, new BigDecimal(increment).toPlainString(), value);
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANK, key, value);
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZREVRANK, key, value);
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZRANGE, key, start, end);
    }

    public Set<Tuple> zRangeWithScores(byte[] key, long start, long end) {
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZRANGE_ENTRY_V2, key, start, end, "WITHSCORES");
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZRANGE_ENTRY, key, start, end, "WITHSCORES");
    }

    private String value(Range.Bound<?> boundary, String defaultValue) {
        if (boundary == null) {
            return defaultValue;
        }
        Object score = boundary.getValue().orElse(null);
        if (score == null) {
            return defaultValue;
        }
        StringBuilder element = new StringBuilder();
        if (!boundary.isInclusive()) {
            element.append("(");
        } else if (!(score instanceof Double)) {
            element.append("[");
        }
        if (score instanceof Double) {
            if (Double.isInfinite((Double)score)) {
                element.append((Double)score > 0.0 ? "+inf" : "-inf");
            } else {
                element.append(BigDecimal.valueOf((Double)score).toPlainString());
            }
        } else if (score instanceof byte[]) {
            element.append(new String((byte[])score, StandardCharsets.UTF_8));
        } else {
            element.append((Object)score);
        }
        return element.toString();
    }

    public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        args.add("WITHSCORES");
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZRANGEBYSCORE_V2, args.toArray());
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZRANGEBYSCORE, args.toArray());
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGE, key, start, end);
    }

    public Set<Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY_V2, key, start, end, "WITHSCORES");
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY, key, start, end, "WITHSCORES");
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, Range.closed(min, max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGEBYSCORE, args.toArray());
    }

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        args.add("WITHSCORES");
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGEBYSCOREWITHSCORES_V2, args.toArray());
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGEBYSCOREWITHSCORES, args.toArray());
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, Range.closed(min, max));
    }

    public Long zCount(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        return (Long)this.read(key, StringCodec.INSTANCE, ZCOUNT, key, min, max);
    }

    @Override
    public Long zCard(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZCARD, new Object[]{key});
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        return (Double)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZSCORE, key, value);
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        return (Long)this.write(key, StringCodec.INSTANCE, ZREMRANGEBYRANK, key, start, end);
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, Range.closed(min, max));
    }

    public Long zRemRangeByScore(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        return (Long)this.write(key, StringCodec.INSTANCE, ZREMRANGEBYSCORE, key, min, max);
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return this.zUnionStore(destKey, null, (Weights)null, sets);
    }

    public Long zUnionStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 5);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        return (Long)this.write(destKey, LongCodec.INSTANCE, ZUNIONSTORE, args.toArray());
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return this.zInterStore(destKey, null, (Weights)null, sets);
    }

    public Long zInterStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 5);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        return (Long)this.write(destKey, StringCodec.INSTANCE, ZINTERSTORE, args.toArray());
    }

    public Cursor<Tuple> zScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<Tuple>(key, 0L, options){
            private RedisClient client;

            @Override
            protected ScanIteration<Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(Long.toUnsignedString(cursorId));
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration<Tuple>(Long.parseUnsignedLong(res.getPos()), res.getValues());
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANGEBYSCORE, key, min, max);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANGEBYSCORE, key, min, max, "LIMIT", offset, count);
    }

    public Set<byte[]> zRangeByScore(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANGEBYSCORE, args.toArray());
    }

    public Set<byte[]> zRangeByLex(byte[] key, Range<byte[]> range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZRANGEBYLEX, args.toArray());
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HSET, key, field, value);
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HSETNX, key, field, value);
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HGET, key, field);
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(fields));
        return (List)this.read(key, ByteArrayCodec.INSTANCE, HMGET, args.toArray());
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(hashes.size() * 2 + 1);
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hashes.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HMSET, params.toArray());
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return (Long)this.write(key, StringCodec.INSTANCE, HINCRBY, key, field, delta);
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return (Double)this.write(key, StringCodec.INSTANCE, HINCRBYFLOAT, key, field, BigDecimal.valueOf(delta).toPlainString());
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        return (Boolean)this.read(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HEXISTS, key, field);
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(fields));
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HDEL, args.toArray());
    }

    @Override
    public Long hLen(byte[] key) {
        return (Long)this.read(key, StringCodec.INSTANCE, HLEN, new Object[]{key});
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HKEYS, new Object[]{key});
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        return (List)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HVALS, new Object[]{key});
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return (Map)this.read(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HGETALL, new Object[]{key});
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, 0L, options){
            private RedisClient client;

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(Long.toUnsignedString(cursorId));
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HSCAN, args.toArray());
                MapScanResult res = (MapScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.parseUnsignedLong(res.getPos()), res.getValues());
            }
        }.open();
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        if (this.isPipelined()) {
            BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC);
            this.executorService = new CommandBatchService((CommandAsyncExecutor)this.executorService, options);
            return;
        }
        BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
        this.executorService = new CommandBatchService((CommandAsyncExecutor)this.executorService, options);
    }

    @Override
    public List<Object> exec() {
        if (this.isPipelinedAtomic()) {
            return null;
        }
        if (this.isQueueing()) {
            try {
                BatchResult<?> result = ((CommandBatchService)this.executorService).execute();
                this.filterResults(result);
                List<Object> list = result.getResponses();
                return list;
            }
            catch (Exception ex) {
                throw this.transform(ex);
            }
            finally {
                this.resetConnection();
            }
        }
        throw new InvalidDataAccessApiUsageException("Not in transaction mode. Please invoke multi method");
    }

    protected void filterResults(BatchResult<?> result) {
        if (result.getResponses().isEmpty()) {
            return;
        }
        int t = 0;
        for (Integer index : this.indexToRemove) {
            index = index - t;
            result.getResponses().remove(index);
            ++t;
        }
        ListIterator<?> iterator = result.getResponses().listIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.set(((String)object).getBytes());
        }
    }

    protected void resetConnection() {
        this.executorService = (CommandAsyncService)this.redisson.getCommandExecutor();
        this.index = -1;
        this.indexToRemove.clear();
    }

    @Override
    public void discard() {
        if (!this.isQueueing()) {
            throw new InvalidDataAccessApiUsageException("Not in transaction mode. Please invoke multi method");
        }
        this.syncFuture(this.executorService.writeAsync(null, org.redisson.client.protocol.RedisCommands.DISCARD, new Object[0]));
        this.resetConnection();
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        this.syncFuture(this.executorService.writeAsync(null, org.redisson.client.protocol.RedisCommands.WATCH, (Object[])keys));
    }

    @Override
    public void unwatch() {
        this.syncFuture(this.executorService.writeAsync(null, org.redisson.client.protocol.RedisCommands.UNWATCH, new Object[0]));
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        return (Long)this.write(channel, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PUBLISH, channel, message);
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        this.subscription = new RedissonSubscription(this.executorService, this.redisson.getConnectionManager().getSubscribeService(), listener);
        this.subscription.subscribe(channels);
    }

    private void checkSubscription() {
        if (this.subscription != null) {
            throw new RedisSubscribedConnectionException("Connection already subscribed");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException("Not supported in queueing mode");
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException("Not supported in pipelined mode");
        }
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        this.subscription = new RedissonSubscription(this.executorService, this.redisson.getConnectionManager().getSubscribeService(), listener);
        this.subscription.pSubscribe(patterns);
    }

    @Override
    public void select(int dbIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] echo(byte[] message) {
        return (byte[])this.read(null, ByteArrayCodec.INSTANCE, ECHO, new Object[]{message});
    }

    @Override
    public String ping() {
        return (String)this.read(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PING, new Object[0]);
    }

    @Override
    public void bgReWriteAof() {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BGREWRITEAOF, new Object[0]);
    }

    @Override
    public void bgSave() {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BGSAVE, new Object[0]);
    }

    @Override
    public Long lastSave() {
        return (Long)this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LASTSAVE, new Object[0]);
    }

    @Override
    public void save() {
        this.write(null, StringCodec.INSTANCE, SAVE, new Object[0]);
    }

    @Override
    public Long dbSize() {
        if (this.isQueueing()) {
            return (Long)this.read(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.DBSIZE, new Object[0]);
        }
        List futures = this.executorService.readAllAsync(org.redisson.client.protocol.RedisCommands.DBSIZE, new Object[0]);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> futures.stream().mapToLong(v -> v.getNow(0L)).sum());
        CompletableFutureWrapper ff = new CompletableFutureWrapper(s);
        return (Long)this.sync(ff);
    }

    @Override
    public void flushDb() {
        if (this.isQueueing() || this.isPipelined()) {
            this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.FLUSHDB, new Object[0]);
            return;
        }
        RFuture<Void> f = this.executorService.writeAllVoidAsync(org.redisson.client.protocol.RedisCommands.FLUSHDB, new Object[0]);
        this.sync(f);
    }

    @Override
    public void flushAll() {
        RFuture<Void> f = this.executorService.writeAllVoidAsync(org.redisson.client.protocol.RedisCommands.FLUSHALL, new Object[0]);
        this.sync(f);
    }

    @Override
    public Properties info() {
        return (Properties)this.read(null, StringCodec.INSTANCE, INFO_DEFAULT, new Object[0]);
    }

    @Override
    public Properties info(String section) {
        return (Properties)this.read(null, StringCodec.INSTANCE, INFO, section);
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getConfig(String pattern) {
        return (Properties)this.read(null, StringCodec.INSTANCE, CONFIG_GET, pattern);
    }

    @Override
    public void setConfig(String param, String value) {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.CONFIG_SET, param, value);
    }

    @Override
    public void resetConfigStats() {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.CONFIG_RESETSTAT, new Object[0]);
    }

    @Override
    public void killClient(String host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientName(byte[] name) {
        throw new UnsupportedOperationException("Should be defined through Redisson Config object");
    }

    @Override
    public String getClientName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.MIGRATE, target.getHost(), target.getPort(), key, dbIndex, timeout);
    }

    @Override
    public void scriptFlush() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RFuture<Void> f = this.executorService.writeAllVoidAsync(org.redisson.client.protocol.RedisCommands.SCRIPT_FLUSH, new Object[0]);
        this.sync(f);
    }

    @Override
    public void scriptKill() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String scriptLoad(byte[] script) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        List futures = this.executorService.executeAllAsync(org.redisson.client.protocol.RedisCommands.SCRIPT_LOAD, new Object[]{script});
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> ((CompletableFuture)futures.get(0)).getNow(null));
        return (String)this.sync(new CompletableFutureWrapper(s));
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptShas) {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        List futures = this.executorService.writeAllAsync(org.redisson.client.protocol.RedisCommands.SCRIPT_EXISTS, scriptShas);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> {
            List result = ((CompletableFuture)futures.get(0)).getNow(new ArrayList());
            for (CompletableFuture future : futures.subList(1, futures.size())) {
                List l = future.getNow(new ArrayList());
                for (int i = 0; i < l.size(); ++i) {
                    result.set(i, (Boolean)result.get(i) | (Boolean)l.get(i));
                }
            }
            return result;
        });
        return (List)this.sync(new CompletableFutureWrapper(s));
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RedisCommand<?> c = this.toCommand(returnType, "EVAL");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(script);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        byte[] key = RedissonConnection.getKey(numKeys, keysAndArgs);
        return this.write(key, ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    protected RedisCommand<?> toCommand(ReturnType returnType, String name) {
        RedisCommand<?> c = null;
        if (returnType == ReturnType.BOOLEAN) {
            c = RScript.ReturnType.BOOLEAN.getCommand();
        } else if (returnType == ReturnType.INTEGER) {
            c = RScript.ReturnType.INTEGER.getCommand();
        } else {
            if (returnType == ReturnType.MULTI) {
                c = RScript.ReturnType.MULTI.getCommand();
                return new RedisCommand<Object>(c, name, new BinaryConvertor());
            }
            if (returnType == ReturnType.STATUS) {
                c = RScript.ReturnType.STATUS.getCommand();
            } else if (returnType == ReturnType.VALUE) {
                c = RScript.ReturnType.VALUE.getCommand();
                return new RedisCommand<Object>(c, name, new BinaryConvertor());
            }
        }
        return new RedisCommand(c, name);
    }

    @Override
    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        byte[] key = RedissonConnection.getKey(numKeys, keysAndArgs);
        return this.write(key, ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    @Override
    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        byte[] key = RedissonConnection.getKey(numKeys, keysAndArgs);
        return this.write(key, ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    private static byte[] getKey(int numKeys, byte[][] keysAndArgs) {
        if (numKeys > 0 && keysAndArgs.length > 0) {
            return keysAndArgs[0];
        }
        return null;
    }

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GEOADD, key, point.getX(), point.getY(), member);
    }

    @Override
    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GEOADD, key, location.getPoint().getX(), location.getPoint().getY(), location.getName());
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        ArrayList<Object> params = new ArrayList<Object>(memberCoordinateMap.size() * 3 + 1);
        params.add(key);
        for (Map.Entry<byte[], Point> entry : memberCoordinateMap.entrySet()) {
            params.add(entry.getValue().getX());
            params.add(entry.getValue().getY());
            params.add(entry.getKey());
        }
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GEOADD, params.toArray());
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            params.add(location.getPoint().getX());
            params.add(location.getPoint().getY());
            params.add(location.getName());
        }
        return (Long)this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GEOADD, params.toArray());
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.geoDist(key, member1, member2, RedisGeoCommands.DistanceUnit.METERS);
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return (Distance)this.read(key, DoubleCodec.INSTANCE, new RedisCommand<Distance>("GEODIST", new DistanceConvertor(metric)), key, member1, member2, this.getAbbreviation(metric));
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(members.length + 1);
        params.add(key);
        for (byte[] member : members) {
            params.add(member);
        }
        return (List)this.read(key, StringCodec.INSTANCE, GEOHASH, params.toArray());
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        ArrayList<Object> params = new ArrayList<Object>(members.length + 1);
        params.add(key);
        params.addAll(Arrays.asList(members));
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("GEOPOS", this.geoDecoder);
        return (List)this.read(key, StringCodec.INSTANCE, command, params.toArray());
    }

    private String convert(double longitude) {
        return BigDecimal.valueOf(longitude).toPlainString();
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> command = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>("GEORADIUS_RO", new GeoResultsDecoder());
        return (GeoResults)this.read(key, ByteArrayCodec.INSTANCE, command, key, this.convert(within.getCenter().getX()), this.convert(within.getCenter().getY()), within.getRadius().getValue(), this.getAbbreviation(within.getRadius().getMetric()));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        RedisCommand<Object> command;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(this.convert(within.getCenter().getX()));
        params.add(this.convert(within.getCenter().getY()));
        params.add(within.getRadius().getValue());
        params.add(this.getAbbreviation(within.getRadius().getMetric()));
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            command = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>("GEORADIUS_RO", this.postitionDecoder);
            params.add("WITHCOORD");
        } else {
            ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new GeoResultsDecoder(within.getRadius().getMetric()), new GeoDistanceDecoder());
            command = new RedisCommand<Object>("GEORADIUS_RO", distanceDecoder);
            params.add("WITHDIST");
        }
        if (args.getLimit() != null) {
            params.add("COUNT");
            params.add(args.getLimit());
        }
        if (args.getSortDirection() != null) {
            params.add(args.getSortDirection().name());
        }
        return (GeoResults)this.read(key, ByteArrayCodec.INSTANCE, command, params.toArray());
    }

    private String getAbbreviation(Metric metric) {
        if (ObjectUtils.nullSafeEquals(Metrics.NEUTRAL, metric)) {
            return RedisGeoCommands.DistanceUnit.METERS.getAbbreviation();
        }
        return metric.getAbbreviation();
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return (GeoResults)this.read(key, ByteArrayCodec.INSTANCE, GEORADIUSBYMEMBER, key, member, radius.getValue(), this.getAbbreviation(radius.getMetric()));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        RedisCommand<Object> command;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(member);
        params.add(radius.getValue());
        params.add(this.getAbbreviation(radius.getMetric()));
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            command = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>("GEORADIUSBYMEMBER_RO", this.postitionDecoder);
            params.add("WITHCOORD");
        } else {
            ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new GeoResultsDecoder(radius.getMetric()), new GeoDistanceDecoder());
            command = new RedisCommand<Object>("GEORADIUSBYMEMBER_RO", distanceDecoder);
            params.add("WITHDIST");
        }
        if (args.getLimit() != null) {
            params.add("COUNT");
            params.add(args.getLimit());
        }
        if (args.getSortDirection() != null) {
            params.add(args.getSortDirection().name());
        }
        return (GeoResults)this.read(key, ByteArrayCodec.INSTANCE, command, params.toArray());
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.zRem(key, members);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoSearch(byte[] key, GeoReference<byte[]> reference, GeoShape predicate, RedisGeoCommands.GeoSearchCommandArgs args) {
        RedisCommand<Object> cmd;
        GeoShape shape;
        GeoReference ref;
        Assert.notNull((Object)args, "Args must not be null!");
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)predicate, "Shape must not be null!");
        Assert.notNull(reference, "Reference must not be null!");
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(key);
        if (reference instanceof GeoReference.GeoCoordinateReference) {
            ref = (GeoReference.GeoCoordinateReference)reference;
            commandParams.add("FROMLONLAT");
            commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLongitude()));
            commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLatitude()));
        } else if (reference instanceof GeoReference.GeoMemberReference) {
            ref = (GeoReference.GeoMemberReference)reference;
            commandParams.add("FROMMEMBER");
            commandParams.add(this.encode(((GeoReference.GeoMemberReference)ref).getMember()));
        }
        if (predicate instanceof RadiusShape) {
            commandParams.add("BYRADIUS");
            shape = (RadiusShape)predicate;
            commandParams.add(((RadiusShape)shape).getRadius().getValue());
            commandParams.add(this.convert(((RadiusShape)shape).getMetric()).getAbbreviation());
        } else if (predicate instanceof BoxShape) {
            shape = (BoxShape)predicate;
            commandParams.add("BYBOX");
            commandParams.add(((BoxShape)shape).getBoundingBox().getWidth().getValue());
            commandParams.add(((BoxShape)shape).getBoundingBox().getHeight().getValue());
            commandParams.add(this.convert(((BoxShape)shape).getMetric()).getAbbreviation());
        }
        if (args.hasSortDirection()) {
            commandParams.add((Object)args.getSortDirection());
        }
        if (args.getLimit() != null) {
            commandParams.add("COUNT");
            commandParams.add(args.getLimit());
            if (args.hasAnyLimit()) {
                commandParams.add("ANY");
            }
        }
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            cmd = new RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>("GEOSEARCH", this.postitionDecoder);
            commandParams.add("WITHCOORD");
        } else {
            ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new GeoResultsDecoder(predicate.getMetric()), new GeoDistanceDecoder());
            cmd = new RedisCommand<Object>("GEOSEARCH", distanceDecoder);
            commandParams.add("WITHDIST");
        }
        return (GeoResults)this.read(key, ByteArrayCodec.INSTANCE, cmd, commandParams.toArray());
    }

    @Override
    public Long geoSearchStore(byte[] destKey, byte[] key, GeoReference<byte[]> reference, GeoShape predicate, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        GeoShape shape;
        GeoReference ref;
        Assert.notNull((Object)args, "Args must not be null!");
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)destKey, "DestKey must not be null!");
        Assert.notNull((Object)predicate, "Shape must not be null!");
        Assert.notNull(reference, "Reference must not be null!");
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(destKey);
        commandParams.add(key);
        if (reference instanceof GeoReference.GeoCoordinateReference) {
            ref = (GeoReference.GeoCoordinateReference)reference;
            commandParams.add("FROMLONLAT");
            commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLongitude()));
            commandParams.add(this.convert(((GeoReference.GeoCoordinateReference)ref).getLatitude()));
        } else if (reference instanceof GeoReference.GeoMemberReference) {
            ref = (GeoReference.GeoMemberReference)reference;
            commandParams.add("FROMMEMBER");
            commandParams.add(this.encode(((GeoReference.GeoMemberReference)ref).getMember()));
        }
        if (predicate instanceof RadiusShape) {
            shape = (RadiusShape)predicate;
            commandParams.add("BYRADIUS");
            commandParams.add(((RadiusShape)shape).getRadius().getValue());
            commandParams.add(this.convert(((RadiusShape)shape).getMetric()).getAbbreviation());
        } else if (predicate instanceof BoxShape) {
            shape = (BoxShape)predicate;
            commandParams.add("BYBOX");
            commandParams.add(((BoxShape)shape).getBoundingBox().getWidth().getValue());
            commandParams.add(((BoxShape)shape).getBoundingBox().getHeight().getValue());
            commandParams.add(this.convert(((BoxShape)shape).getMetric()).getAbbreviation());
        }
        if (args.hasSortDirection()) {
            commandParams.add((Object)args.getSortDirection());
        }
        if (args.getLimit() != null) {
            commandParams.add("COUNT");
            commandParams.add(args.getLimit());
            if (args.hasAnyLimit()) {
                commandParams.add("ANY");
            }
        }
        if (args.isStoreDistance()) {
            commandParams.add("STOREDIST");
        }
        return (Long)this.write(key, LongCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GEOSEARCHSTORE_STORE, commandParams.toArray());
    }

    private Metric convert(Metric metric) {
        if (metric == Metrics.NEUTRAL) {
            return RedisGeoCommands.DistanceUnit.METERS;
        }
        return metric;
    }

    private ByteBuf encode(Object value) {
        return this.executorService.encode(ByteArrayCodec.INSTANCE, value);
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(values.length + 1);
        params.add(key);
        for (byte[] member : values) {
            params.add(member);
        }
        return (Long)this.write(key, StringCodec.INSTANCE, PFADD, params.toArray());
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, "PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, "Keys for PFOUNT must not contain 'null'.");
        return (Long)this.write(keys[0], StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PFCOUNT, Arrays.asList(keys).toArray());
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        ArrayList<Object> args = new ArrayList<Object>(sourceKeys.length + 1);
        args.add(destinationKey);
        args.addAll(Arrays.asList(sourceKeys));
        this.write(destinationKey, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PFMERGE, args.toArray());
    }

    @Override
    public Long hStrLen(byte[] key, byte[] field) {
        return (Long)this.read(key, StringCodec.INSTANCE, HSTRLEN, key, field);
    }

    @Override
    public RedisStreamCommands streamCommands() {
        return new RedissonStreamCommands(this, this.executorService);
    }

    @Override
    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        boolean writeOp = false;
        for (BitFieldSubCommands.BitFieldSubCommand subCommand : subCommands) {
            String size = "u";
            if (subCommand.getType().isSigned()) {
                size = "i";
            }
            size = size + subCommand.getType().getBits();
            String offset = "#";
            if (subCommand.getOffset().isZeroBased()) {
                offset = "";
            }
            offset = offset + subCommand.getOffset().getValue();
            if (subCommand instanceof BitFieldSubCommands.BitFieldGet) {
                params.add("GET");
                params.add(size);
                params.add(offset);
                continue;
            }
            if (subCommand instanceof BitFieldSubCommands.BitFieldSet) {
                writeOp = true;
                params.add("SET");
                params.add(size);
                params.add(offset);
                params.add(((BitFieldSubCommands.BitFieldSet)subCommand).getValue());
                continue;
            }
            if (!(subCommand instanceof BitFieldSubCommands.BitFieldIncrBy)) continue;
            writeOp = true;
            params.add("INCRBY");
            params.add(size);
            params.add(offset);
            params.add(((BitFieldSubCommands.BitFieldIncrBy)subCommand).getValue());
            BitFieldSubCommands.BitFieldIncrBy.Overflow overflow = ((BitFieldSubCommands.BitFieldIncrBy)subCommand).getOverflow();
            if (overflow == null) continue;
            params.add("OVERFLOW");
            params.add((Object)overflow);
        }
        if (writeOp) {
            return (List)this.write(key, StringCodec.INSTANCE, BITFIELD, params.toArray());
        }
        return (List)this.read(key, StringCodec.INSTANCE, BITFIELD, params.toArray());
    }

    @Override
    public Long exists(byte[] ... keys) {
        return (Long)this.read(keys[0], StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.EXISTS_LONG, Arrays.asList(keys).toArray());
    }

    @Override
    public Long touch(byte[] ... keys) {
        return (Long)this.read(keys[0], StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.TOUCH_LONG, Arrays.asList(keys).toArray());
    }

    @Override
    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (ValueEncoding)this.read(key, StringCodec.INSTANCE, OBJECT_ENCODING, new Object[]{key});
    }

    @Override
    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Duration)this.read(key, StringCodec.INSTANCE, OBJECT_IDLETIME, new Object[]{key});
    }

    @Override
    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Long)this.read(key, StringCodec.INSTANCE, OBJECT_REFCOUNT, new Object[]{key});
    }

    @Override
    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null! Use Range.unbounded() instead.");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (bit) {
            params.add(1);
        } else {
            params.add(0);
        }
        if (range.getLowerBound().isBounded()) {
            params.add(range.getLowerBound().getValue().get());
            if (range.getUpperBound().isBounded()) {
                params.add(range.getUpperBound().getValue().get());
            }
        }
        return (Long)this.read(key, StringCodec.INSTANCE, BITPOS, params.toArray());
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        if (replace) {
            this.write(key, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RESTORE, key, ttlInMillis, serializedValue, "REPLACE");
            return;
        }
        this.restore(key, ttlInMillis, serializedValue);
    }

    @Override
    public byte[] zRandMember(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANDMEMBER_SINGLE, new Object[]{key});
    }

    @Override
    public List<byte[]> zRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (List)this.write(key, ByteArrayCodec.INSTANCE, ZRANDMEMBER_LIST, key, count);
    }

    public Tuple zRandMemberWithScore(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Tuple)this.write(key, ByteArrayCodec.INSTANCE, ZRANDMEMBER_SCORE, key, "WITHSCORES");
    }

    public List<Tuple> zRandMemberWithScore(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (List)this.write(key, ByteArrayCodec.INSTANCE, ZRANDMEMBER_SCORE_LIST, key, count, "WITHSCORES");
    }

    public Tuple zPopMin(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Tuple)this.write(key, ByteArrayCodec.INSTANCE, ZPOPMIN, new Object[]{key});
    }

    public Set<Tuple> zPopMin(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Set)this.write(key, ByteArrayCodec.INSTANCE, ZPOPMIN, key, count);
    }

    public Tuple bZPopMin(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, "Key must not be null!");
        long seconds = unit.toSeconds(timeout);
        return (Tuple)this.write(key, ByteArrayCodec.INSTANCE, BZPOPMIN, key, seconds);
    }

    public Tuple zPopMax(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Tuple)this.write(key, ByteArrayCodec.INSTANCE, ZPOPMAX, new Object[]{key});
    }

    public Set<Tuple> zPopMax(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Set)this.write(key, ByteArrayCodec.INSTANCE, ZPOPMAX, key, count);
    }

    public Tuple bZPopMax(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, "Key must not be null!");
        long seconds = unit.toSeconds(timeout);
        return (Tuple)this.write(key, ByteArrayCodec.INSTANCE, BZPOPMAX, key, seconds);
    }

    @Override
    public List<Double> zMScore(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null!");
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (List)this.write(key, DoubleCodec.INSTANCE, ZMSCORE, args.toArray());
    }

    @Override
    public Set<byte[]> zDiff(byte[] ... sets) {
        ArrayList<Integer> args = new ArrayList<Integer>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Set)this.write(sets[0], ByteArrayCodec.INSTANCE, ZDIFF, args.toArray());
    }

    public Set<Tuple> zDiffWithScores(byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        args.add("WITHSCORES");
        return (Set)this.write(sets[0], ByteArrayCodec.INSTANCE, ZDIFF_SCORE, args.toArray());
    }

    @Override
    public Long zDiffStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Key must not be null!");
        ArrayList<Object> args = new ArrayList<Object>(sets.length + 2);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Long)this.write(destKey, LongCodec.INSTANCE, ZDIFFSTORE, args.toArray());
    }

    @Override
    public Set<byte[]> zInter(byte[] ... sets) {
        ArrayList<Integer> args = new ArrayList<Integer>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Set)this.write(sets[0], ByteArrayCodec.INSTANCE, ZINTER, args.toArray());
    }

    public Set<Tuple> zInterWithScores(Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 6);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        args.add("WITHSCORES");
        return (Set)this.write(sets[0], ByteArrayCodec.INSTANCE, ZINTER_SCORE, args.toArray());
    }

    public Set<Tuple> zInterWithScores(byte[] ... sets) {
        return this.zInterWithScores(null, (Weights)null, sets);
    }

    @Override
    public Set<byte[]> zUnion(byte[] ... sets) {
        ArrayList<Integer> args = new ArrayList<Integer>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Set)this.write(sets[0], ByteArrayCodec.INSTANCE, ZUNION, args.toArray());
    }

    public Set<Tuple> zUnionWithScores(Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 6);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        args.add("WITHSCORES");
        return (Set)this.write(sets[0], ByteArrayCodec.INSTANCE, ZUNION_SCORE, args.toArray());
    }

    public Set<Tuple> zUnionWithScores(byte[] ... sets) {
        return this.zUnionWithScores(null, (Weights)null, sets);
    }

    @Override
    public byte[] hRandField(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (byte[])this.read(key, ByteArrayCodec.INSTANCE, HRANDFIELD, new Object[]{key});
    }

    @Override
    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        if (this.executorService.getServiceManager().isResp3()) {
            return (Map.Entry)this.read(key, ByteArrayCodec.INSTANCE, HRANDFIELD_SINGLE_V2, key, 1, "WITHVALUES");
        }
        return (Map.Entry)this.read(key, ByteArrayCodec.INSTANCE, HRANDFIELD_SINGLE, key, 1, "WITHVALUES");
    }

    @Override
    public List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (List)this.read(key, ByteArrayCodec.INSTANCE, HRANDFIELD_LIST, key, count);
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        if (this.executorService.getServiceManager().isResp3()) {
            return (List)this.read(key, ByteArrayCodec.INSTANCE, HRANDFIELD_VALUES_V2, key, count, "WITHVALUES");
        }
        return (List)this.read(key, ByteArrayCodec.INSTANCE, HRANDFIELD_VALUES, key, count, "WITHVALUES");
    }

    @Override
    public Boolean copy(byte[] sourceKey, byte[] targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, "Key must not be null!");
        Assert.notNull((Object)targetKey, "Target must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sourceKey);
        params.add(targetKey);
        if (replace) {
            params.add("REPLACE");
        }
        return (Boolean)this.write(sourceKey, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.COPY, params.toArray());
    }

    @Override
    public byte[] lMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to) {
        Assert.notNull((Object)sourceKey, "Key must not be null!");
        Assert.notNull((Object)destinationKey, "Destination key must not be null!");
        Assert.notNull((Object)from, "From must not be null!");
        Assert.notNull((Object)from, "To must not be null!");
        return (byte[])this.write(sourceKey, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LMOVE, new Object[]{sourceKey, destinationKey, from, to});
    }

    @Override
    public byte[] bLMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to, double timeout) {
        Assert.notNull((Object)sourceKey, "Key must not be null!");
        Assert.notNull((Object)destinationKey, "Destination key must not be null!");
        Assert.notNull((Object)from, "From must not be null!");
        Assert.notNull((Object)to, "To must not be null!");
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        return (byte[])this.write(sourceKey, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BLMOVE, new Object[]{sourceKey, destinationKey, from, to, destinationKey});
    }

    @Override
    public List<byte[]> lPop(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (List)this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LPOP_LIST, key, count);
    }

    @Override
    public List<byte[]> rPop(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (List)this.write(key, ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RPOP_LIST, key, count);
    }

    @Override
    public List<Boolean> sMIsMember(byte[] key, byte[] ... value) {
        Assert.notNull((Object)key, "Key must not be null!");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.addAll(Arrays.asList(value));
        return (List)this.read(key, StringCodec.INSTANCE, SMISMEMBER, args.toArray());
    }

    @Override
    public byte[] getEx(byte[] key, Expiration expiration) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, GETEX, key, "PX", expiration.getExpirationTimeInMilliseconds());
    }

    @Override
    public byte[] getDel(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (byte[])this.write(key, ByteArrayCodec.INSTANCE, GETDEL, new Object[]{key});
    }

    public Set<byte[]> zRevRangeByLex(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, ByteArrayCodec.INSTANCE, ZREVRANGEBYLEX, args.toArray());
    }

    @Override
    public Long time(TimeUnit timeUnit) {
        return (Long)this.read(null, LongCodec.INSTANCE, new RedisStrictCommand<Long>("TIME", new TimeLongObjectDecoder(timeUnit)), new Object[0]);
    }

    public Long zRemRangeByLex(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        return (Long)this.write(key, StringCodec.INSTANCE, ZREMRANGEBYLEX, key, min, max);
    }

    public Long zLexCount(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        return (Long)this.read(key, StringCodec.INSTANCE, ZLEXCOUNT, key, min, max);
    }

    @Override
    public void rewriteConfig() {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.CONFIG_REWRITE, new Object[0]);
    }

    public Long zRangeStoreByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit) {
        String max = this.value(range.getUpperBound(), "+");
        String min = this.value(range.getLowerBound(), "-");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYLEX");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public Long zRangeStoreRevByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit) {
        String max = this.value(range.getUpperBound(), "+");
        String min = this.value(range.getLowerBound(), "-");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYLEX");
        args.add("REV");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public Long zRangeStoreByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYSCORE");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public Long zRangeStoreRevByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYSCORE");
        args.add("REV");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    @Override
    public void flushDb(RedisServerCommands.FlushOption option) {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.FLUSHDB, option.toString());
    }

    @Override
    public void flushAll(RedisServerCommands.FlushOption option) {
        this.write(null, StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.FLUSHALL, option.toString());
    }

    public void replicaOf(String host, int port) {
        this.write(null, StringCodec.INSTANCE, REPLICAOF, host, port);
    }

    public void replicaOfNoOne() {
        this.write(null, StringCodec.INSTANCE, REPLICAOF, "NO", "ONE");
    }

    public RedisCommands commands() {
        return this;
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return this;
    }

    @Override
    public RedisHashCommands hashCommands() {
        return this;
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this;
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return this;
    }

    @Override
    public RedisListCommands listCommands() {
        return this;
    }

    @Override
    public RedisSetCommands setCommands() {
        return this;
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return this;
    }

    @Override
    public RedisServerCommands serverCommands() {
        return this;
    }

    @Override
    public RedisStringCommands stringCommands() {
        return this;
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return this;
    }
}

