/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.math.BigDecimal;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveNumberCommands
extends RedissonBaseReactive
implements ReactiveNumberCommands {
    public RedissonReactiveNumberCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> incr(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveNumberCommands.toByteArray(key.getKey());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.INCR, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)key, (Long)v));
        });
    }

    @Override
    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.IncrByCommand<T>, T>> incrBy(Publisher<ReactiveNumberCommands.IncrByCommand<T>> commands) {
        return this.execute(commands, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            Assert.notNull(key.getValue(), "Value must not be null!");
            byte[] keyBuf = RedissonReactiveNumberCommands.toByteArray(key.getKey());
            Mono<Number> m = this.write(keyBuf, StringCodec.INSTANCE, new RedisCommand<Object>("INCRBYFLOAT", new NumberConvertor(key.getValue().getClass())), keyBuf, new BigDecimal(key.getValue().toString()).toPlainString());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.IncrByCommand, Number>((ReactiveNumberCommands.IncrByCommand)key, (Number)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> decr(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveNumberCommands.toByteArray(key.getKey());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.DECR, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)key, (Long)v));
        });
    }

    @Override
    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.DecrByCommand<T>, T>> decrBy(Publisher<ReactiveNumberCommands.DecrByCommand<T>> commands) {
        return this.execute(commands, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            Assert.notNull(key.getValue(), "Value must not be null!");
            byte[] keyBuf = RedissonReactiveNumberCommands.toByteArray(key.getKey());
            Mono<Number> m = this.write(keyBuf, StringCodec.INSTANCE, new RedisCommand<Object>("INCRBYFLOAT", new NumberConvertor(key.getValue().getClass())), keyBuf, "-" + new BigDecimal(key.getValue().toString()).toPlainString());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.DecrByCommand, Number>((ReactiveNumberCommands.DecrByCommand)key, (Number)v));
        });
    }

    @Override
    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.HIncrByCommand<T>, T>> hIncrBy(Publisher<ReactiveNumberCommands.HIncrByCommand<T>> commands) {
        return this.execute(commands, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            Assert.notNull(key.getValue(), "Value must not be null!");
            byte[] keyBuf = RedissonReactiveNumberCommands.toByteArray(key.getKey());
            byte[] fieldBuf = RedissonReactiveNumberCommands.toByteArray(key.getField());
            Mono<Number> m = this.write(keyBuf, StringCodec.INSTANCE, new RedisCommand<Object>("HINCRBYFLOAT", new NumberConvertor(key.getValue().getClass())), keyBuf, fieldBuf, new BigDecimal(key.getValue().toString()).toPlainString());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveNumberCommands.HIncrByCommand, Number>((ReactiveNumberCommands.HIncrByCommand)key, (Number)v));
        });
    }
}

