/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveStringCommands
extends RedissonBaseReactive
implements ReactiveStringCommands {
    private static final RedisCommand<Boolean> SET = new RedisCommand<Boolean>("SET", new BooleanReplayConvertor());
    private static final RedisCommand<Boolean> SETEX = new RedisCommand<Boolean>("SETEX", new BooleanReplayConvertor());
    private static final RedisCommand<String> PSETEX = new RedisCommand("PSETEX");
    private static final RedisCommand<Boolean> MSET = new RedisCommand<Boolean>("MSET", new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> APPEND = new RedisStrictCommand("APPEND");
    private static final RedisCommand<Object> GETRANGE = new RedisCommand("GETRANGE");
    private static final RedisCommand<Long> SETRANGE = new RedisCommand("SETRANGE");
    private static final RedisStrictCommand<Long> BITOP = new RedisStrictCommand("BITOP");
    private static final RedisStrictCommand<Long> BITPOS = new RedisStrictCommand("BITPOS");
    private static final RedisCommand<Object> GETDEL = new RedisCommand("GETDEL");
    private static final RedisCommand<Object> GETEX = new RedisCommand("GETEX");

    RedissonReactiveStringCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> set(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            byte[] key = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] value = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<Boolean> m = Mono.empty();
            if (!command.getExpiration().isPresent()) {
                m = this.write(key, StringCodec.INSTANCE, SET, key, value);
            } else if (command.getExpiration().get().isPersistent()) {
                if (!command.getOption().isPresent() || command.getOption().get() == RedisStringCommands.SetOption.UPSERT) {
                    m = this.write(key, StringCodec.INSTANCE, SET, key, value);
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                    m = this.write(key, StringCodec.INSTANCE, SET, key, value, "NX");
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                    m = this.write(key, StringCodec.INSTANCE, SET, key, value, "XX");
                }
            } else {
                if (!command.getOption().isPresent() || command.getOption().get() == RedisStringCommands.SetOption.UPSERT) {
                    m = this.write(key, StringCodec.INSTANCE, SET, key, value, "PX", command.getExpiration().get().getExpirationTimeInMilliseconds());
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                    m = this.write(key, StringCodec.INSTANCE, SET, key, value, "PX", command.getExpiration().get().getExpirationTimeInMilliseconds(), "NX");
                }
                if (command.getOption().get() == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                    m = this.write(key, StringCodec.INSTANCE, SET, key, value, "PX", command.getExpiration().get().getExpirationTimeInMilliseconds(), "XX");
                    return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)v));
                }
            }
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)v)).switchIfEmpty(Mono.just(new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, Boolean.FALSE)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> get(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<byte[]> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, ByteBuffer.wrap(v))).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>> getSet(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                throw new IllegalArgumentException("Command must not define expiration nor option for GETSET.");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.GETSET, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<List<ByteBuffer>, ByteBuffer>> mGet(Publisher<List<ByteBuffer>> keysets) {
        return this.execute(keysets, coll -> {
            Assert.notNull(coll, "List must not be null!");
            Object[] params = coll.stream().map(buf -> RedissonReactiveStringCommands.toByteArray(buf)).toArray(Object[]::new);
            Mono<List> m = this.read(null, ByteArrayCodec.INSTANCE, RedisCommands.MGET, params);
            return m.map(v -> {
                List values = v.stream().map(array -> {
                    if (array == null) {
                        return ByteBuffer.allocate(0);
                    }
                    return ByteBuffer.wrap(array);
                }).collect(Collectors.toList());
                return new ReactiveRedisConnection.MultiValueResponse((List)coll, values);
            });
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setNX(Publisher<ReactiveStringCommands.SetCommand> values) {
        return this.execute(values, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                throw new IllegalArgumentException("Command must not define expiration nor option for GETSET.");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.SETNX, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            if (!command.getExpiration().isPresent()) {
                throw new IllegalArgumentException("Expiration must not be null!");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, SETEX, keyBuf, command.getExpiration().get().getExpirationTimeInSeconds(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> pSetEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            if (!command.getExpiration().isPresent()) {
                throw new IllegalArgumentException("Expiration must not be null!");
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<String> m = this.write(keyBuf, StringCodec.INSTANCE, PSETEX, keyBuf, command.getExpiration().get().getExpirationTimeInMilliseconds(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, true));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSet(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull(command.getKeyValuePairs(), "KeyValuePairs must not be null!");
            List<byte[]> params = this.convert((ReactiveStringCommands.MSetCommand)command);
            Mono<Boolean> m = this.write(params.get(0), StringCodec.INSTANCE, MSET, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>((ReactiveStringCommands.MSetCommand)command, (Boolean)v));
        });
    }

    protected List<byte[]> convert(ReactiveStringCommands.MSetCommand command) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(command.getKeyValuePairs().size());
        command.getKeyValuePairs().entrySet().forEach(e -> {
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray((ByteBuffer)e.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray((ByteBuffer)e.getValue());
            params.add(keyBuf);
            params.add(valueBuf);
        });
        return params;
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSetNX(Publisher<ReactiveStringCommands.MSetCommand> source) {
        return this.execute(source, command -> {
            Assert.notNull(command.getKeyValuePairs(), "KeyValuePairs must not be null!");
            List<byte[]> params = this.convert((ReactiveStringCommands.MSetCommand)command);
            Mono<Boolean> m = this.write(params.get(0), StringCodec.INSTANCE, RedisCommands.MSETNX, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>((ReactiveStringCommands.MSetCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>> append(Publisher<ReactiveStringCommands.AppendCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, APPEND, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>((ReactiveStringCommands.AppendCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>> getRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<byte[]> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, GETRANGE, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().orElse(-1L));
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>((ReactiveRedisConnection.RangeCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>> setRange(Publisher<ReactiveStringCommands.SetRangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            Assert.notNull((Object)command.getOffset(), "Offset must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveStringCommands.toByteArray(command.getValue());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, SETRANGE, keyBuf, command.getOffset(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>((ReactiveStringCommands.SetRangeCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>> getBit(Publisher<ReactiveStringCommands.GetBitCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getOffset(), "Offset must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.read(keyBuf, StringCodec.INSTANCE, RedisCommands.GETBIT, keyBuf, command.getOffset());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>((ReactiveStringCommands.GetBitCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>> setBit(Publisher<ReactiveStringCommands.SetBitCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getOffset(), "Offset must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.SETBIT, keyBuf, command.getOffset(), command.getValue() ? 1 : 0);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>((ReactiveStringCommands.SetBitCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>> bitCount(Publisher<ReactiveStringCommands.BitCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Range<Long> range = command.getRange();
            if (range == null) {
                range = Range.unbounded();
            }
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<Long> m = range == Range.unbounded() ? this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.BITCOUNT, new Object[]{keyBuf}) : this.write(keyBuf, StringCodec.INSTANCE, RedisCommands.BITCOUNT, keyBuf, range.getLowerBound().getValue().orElse(0L), range.getUpperBound().getValue().get());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>((ReactiveStringCommands.BitCountCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveStringCommands.BitFieldCommand, Long>> bitField(Publisher<ReactiveStringCommands.BitFieldCommand> commands) {
        return null;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>> bitOp(Publisher<ReactiveStringCommands.BitOpCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getDestinationKey(), "DestinationKey must not be null!");
            Assert.notEmpty(command.getKeys(), "Keys must not be null or empty");
            if (command.getBitOp() == RedisStringCommands.BitOperation.NOT && command.getKeys().size() > 1) {
                throw new UnsupportedOperationException("NOT operation doesn't support more than single source key");
            }
            ArrayList<Object> params = new ArrayList<Object>(command.getKeys().size() + 2);
            params.add((Object)command.getBitOp());
            params.add(RedissonReactiveStringCommands.toByteArray(command.getDestinationKey()));
            params.addAll(command.getKeys().stream().map(v -> RedissonReactiveStringCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono<Long> m = this.write(RedissonReactiveStringCommands.toByteArray(command.getDestinationKey()), StringCodec.INSTANCE, BITOP, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>((ReactiveStringCommands.BitOpCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitPosCommand, Long>> bitPos(Publisher<ReactiveStringCommands.BitPosCommand> commands) {
        return this.execute(commands, command -> {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(RedissonReactiveStringCommands.toByteArray(command.getKey()));
            params.add(command.getBit() ? 1 : 0);
            if (command.getRange() != null) {
                if (command.getRange().getLowerBound().getValue().isPresent()) {
                    params.add(command.getRange().getLowerBound().getValue().get());
                }
                if (command.getRange().getUpperBound().getValue().isPresent()) {
                    if (!command.getRange().getLowerBound().getValue().isPresent()) {
                        throw new IllegalArgumentException("LowerBound must not be null");
                    }
                    params.add(command.getRange().getUpperBound().getValue().get());
                }
            }
            Mono<Long> m = this.read((byte[])params.get(0), StringCodec.INSTANCE, BITPOS, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitPosCommand, Long>((ReactiveStringCommands.BitPosCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> strLen(Publisher<ReactiveRedisConnection.KeyCommand> keys) {
        return this.execute(keys, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, RedisCommands.STRLEN, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> getDel(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, GETDEL, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, ByteBuffer.wrap(v))).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.GetExCommand>> getEx(Publisher<ReactiveStringCommands.GetExCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveStringCommands.toByteArray(command.getKey());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, GETEX, keyBuf, "PX", command.getExpiration().getExpirationTimeInMilliseconds());
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.GetExCommand>((ReactiveStringCommands.GetExCommand)command, ByteBuffer.wrap(v))).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveStringCommands.GetExCommand>((ReactiveStringCommands.GetExCommand)command));
        });
    }
}

