/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.security.reactive.ApplicationContextServerWebExchangeMatcher;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class EndpointRequest {
    private static final ServerWebExchangeMatcher EMPTY_MATCHER = request -> ServerWebExchangeMatcher.MatchResult.notMatch();

    private EndpointRequest() {
    }

    public static EndpointServerWebExchangeMatcher toAnyEndpoint() {
        return new EndpointServerWebExchangeMatcher(true);
    }

    public static EndpointServerWebExchangeMatcher to(Class<?> ... endpoints) {
        return new EndpointServerWebExchangeMatcher(endpoints, false);
    }

    public static EndpointServerWebExchangeMatcher to(String ... endpoints) {
        return new EndpointServerWebExchangeMatcher(endpoints, false);
    }

    public static LinksServerWebExchangeMatcher toLinks() {
        return new LinksServerWebExchangeMatcher();
    }

    public static final class LinksServerWebExchangeMatcher
    extends AbstractWebExchangeMatcher<WebEndpointProperties> {
        private volatile ServerWebExchangeMatcher delegate;

        private LinksServerWebExchangeMatcher() {
            super(WebEndpointProperties.class);
        }

        @Override
        protected void initialized(Supplier<WebEndpointProperties> properties) {
            this.delegate = this.createDelegate(properties.get());
        }

        private ServerWebExchangeMatcher createDelegate(WebEndpointProperties properties) {
            if (StringUtils.hasText(properties.getBasePath())) {
                return new PathPatternParserServerWebExchangeMatcher(properties.getBasePath());
            }
            return EMPTY_MATCHER;
        }

        @Override
        protected Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange, Supplier<WebEndpointProperties> context) {
            return this.delegate.matches(exchange);
        }
    }

    public static final class EndpointServerWebExchangeMatcher
    extends AbstractWebExchangeMatcher<PathMappedEndpoints> {
        private final List<Object> includes;
        private final List<Object> excludes;
        private final boolean includeLinks;
        private volatile ServerWebExchangeMatcher delegate;

        private EndpointServerWebExchangeMatcher(boolean includeLinks) {
            this(Collections.emptyList(), Collections.emptyList(), includeLinks);
        }

        private EndpointServerWebExchangeMatcher(Class<?>[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointServerWebExchangeMatcher(String[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks);
        }

        private EndpointServerWebExchangeMatcher(List<Object> includes, List<Object> excludes, boolean includeLinks) {
            super(PathMappedEndpoints.class);
            this.includes = includes;
            this.excludes = excludes;
            this.includeLinks = includeLinks;
        }

        public EndpointServerWebExchangeMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointServerWebExchangeMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointServerWebExchangeMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointServerWebExchangeMatcher(this.includes, excludes, this.includeLinks);
        }

        public EndpointServerWebExchangeMatcher excludingLinks() {
            return new EndpointServerWebExchangeMatcher(this.includes, this.excludes, false);
        }

        @Override
        protected void initialized(Supplier<PathMappedEndpoints> pathMappedEndpoints) {
            this.delegate = this.createDelegate(pathMappedEndpoints);
        }

        private ServerWebExchangeMatcher createDelegate(Supplier<PathMappedEndpoints> pathMappedEndpoints) {
            try {
                return this.createDelegate(pathMappedEndpoints.get());
            }
            catch (NoSuchBeanDefinitionException ex) {
                return EMPTY_MATCHER;
            }
        }

        private ServerWebExchangeMatcher createDelegate(PathMappedEndpoints pathMappedEndpoints) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(pathMappedEndpoints.getAllPaths());
            }
            this.streamPaths(this.includes, pathMappedEndpoints).forEach(paths::add);
            this.streamPaths(this.excludes, pathMappedEndpoints).forEach(paths::remove);
            List<ServerWebExchangeMatcher> delegateMatchers = this.getDelegateMatchers(paths);
            if (this.includeLinks && StringUtils.hasText(pathMappedEndpoints.getBasePath())) {
                delegateMatchers.add((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(pathMappedEndpoints.getBasePath()));
            }
            return new OrServerWebExchangeMatcher(delegateMatchers);
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints pathMappedEndpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(pathMappedEndpoints::getPath);
        }

        @Override
        protected Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange, Supplier<PathMappedEndpoints> context) {
            return this.delegate.matches(exchange);
        }

        private List<ServerWebExchangeMatcher> getDelegateMatchers(Set<String> paths) {
            return paths.stream().map(path -> new PathPatternParserServerWebExchangeMatcher(path + "/**")).collect(Collectors.toList());
        }

        public String toString() {
            return String.format("EndpointRequestMatcher includes=%s, excludes=%s, includeLinks=%s", this.toString(this.includes, "[*]"), this.toString(this.excludes, "[]"), this.includeLinks);
        }

        private String toString(List<Object> endpoints, String emptyValue) {
            return !endpoints.isEmpty() ? endpoints.stream().map(this::getEndpointId).map(Object::toString).collect(Collectors.joining(", ", "[", "]")) : emptyValue;
        }

        private EndpointId getEndpointId(Object source) {
            if (source instanceof EndpointId) {
                return (EndpointId)source;
            }
            if (source instanceof String) {
                return EndpointId.of((String)source);
            }
            if (source instanceof Class) {
                return this.getEndpointId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + source);
        }

        private EndpointId getEndpointId(Class<?> source) {
            MergedAnnotation<Endpoint> annotation = MergedAnnotations.from(source).get(Endpoint.class);
            Assert.state(annotation.isPresent(), () -> "Class " + source + " is not annotated with @Endpoint");
            return EndpointId.of(annotation.getString("id"));
        }
    }

    private static abstract class AbstractWebExchangeMatcher<T>
    extends ApplicationContextServerWebExchangeMatcher<T> {
        private ManagementPortType managementPortType;

        AbstractWebExchangeMatcher(Class<? extends T> contextClass) {
            super(contextClass);
        }

        @Override
        protected boolean ignoreApplicationContext(ApplicationContext applicationContext) {
            if (this.managementPortType == null) {
                this.managementPortType = ManagementPortType.get(applicationContext.getEnvironment());
            }
            if (this.managementPortType == ManagementPortType.DIFFERENT) {
                if (applicationContext.getParent() == null) {
                    return true;
                }
                String managementContextId = applicationContext.getParent().getId() + ":management";
                if (!managementContextId.equals(applicationContext.getId())) {
                    return true;
                }
            }
            return false;
        }
    }
}

