/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveListCommands {
    default public Mono<Long> rPush(ByteBuffer key, List<ByteBuffer> values) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(values, "Values must not be null!");
        return this.push(Mono.just(PushCommand.right().values(values).to(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> rPushX(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.push(Mono.just(PushCommand.right().value(value).to(key).ifExists())).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> lPush(ByteBuffer key, List<ByteBuffer> values) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(values, "Values must not be null!");
        return this.push(Mono.just(PushCommand.left().values(values).to(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> lPushX(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.push(Mono.just(PushCommand.left().value(value).to(key).ifExists())).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<PushCommand, Long>> push(Publisher<PushCommand> var1);

    default public Mono<Long> lLen(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.lLen(Mono.just(new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> lLen(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<ByteBuffer> lRange(ByteBuffer key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.lRange(Mono.just(ReactiveRedisConnection.RangeCommand.key(key).fromIndex(start).toIndex(end))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.RangeCommand, Flux<ByteBuffer>>> lRange(Publisher<ReactiveRedisConnection.RangeCommand> var1);

    default public Mono<Boolean> lTrim(ByteBuffer key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.lTrim(Mono.just(ReactiveRedisConnection.RangeCommand.key(key).fromIndex(start).toIndex(end))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.RangeCommand>> lTrim(Publisher<ReactiveRedisConnection.RangeCommand> var1);

    default public Mono<Long> lPos(ByteBuffer key, ByteBuffer element) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.lPos(LPosCommand.lPosOf(element).from(key)).next();
    }

    default public Flux<Long> lPos(LPosCommand command) {
        return this.lPos(Mono.just(command)).map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<LPosCommand, Long>> lPos(Publisher<LPosCommand> var1);

    default public Mono<ByteBuffer> lIndex(ByteBuffer key, long index) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.lIndex(Mono.just(LIndexCommand.elementAt(index).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<LIndexCommand>> lIndex(Publisher<LIndexCommand> var1);

    default public Mono<Long> lInsert(ByteBuffer key, RedisListCommands.Position position, ByteBuffer pivot, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)position, "Position must not be null!");
        Assert.notNull((Object)pivot, "Pivot must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        LInsertCommand command = LInsertCommand.value(value);
        command = RedisListCommands.Position.BEFORE.equals((Object)position) ? command.before(pivot) : command.after(pivot);
        command = command.forKey(key);
        return this.lInsert(Mono.just(command)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<LInsertCommand, Long>> lInsert(Publisher<LInsertCommand> var1);

    default public Mono<ByteBuffer> lMove(ByteBuffer sourceKey, ByteBuffer destinationKey, Direction from, Direction to) {
        Assert.notNull((Object)sourceKey, "Source key must not be null!");
        Assert.notNull((Object)destinationKey, "Destination key must not be null!");
        Assert.notNull((Object)from, "From direction must not be null!");
        Assert.notNull((Object)to, "To direction must not be null!");
        return this.lMove(Mono.just(LMoveCommand.from(sourceKey, from).to(destinationKey, to))).map(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<LMoveCommand>> lMove(Publisher<? extends LMoveCommand> var1);

    default public Mono<ByteBuffer> bLMove(ByteBuffer sourceKey, ByteBuffer destinationKey, Direction from, Direction to, Duration timeout) {
        Assert.notNull((Object)sourceKey, "Source key must not be null!");
        Assert.notNull((Object)destinationKey, "Destination key must not be null!");
        Assert.notNull((Object)from, "From direction must not be null!");
        Assert.notNull((Object)to, "To direction must not be null!");
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        Assert.isTrue(!timeout.isNegative(), "Timeout must not be negative!");
        return this.bLMove(Mono.just(BLMoveCommand.from(sourceKey, from).to(destinationKey, to).timeout(timeout))).map(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<BLMoveCommand>> bLMove(Publisher<BLMoveCommand> var1);

    default public Mono<Boolean> lSet(ByteBuffer key, long index, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.lSet(Mono.just(LSetCommand.elementAt(index).to(value).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<LSetCommand>> lSet(Publisher<LSetCommand> var1);

    default public Mono<Long> lRem(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.lRem(Mono.just(LRemCommand.all().occurrencesOf(value).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> lRem(ByteBuffer key, Long count, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)count, "Count must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.lRem(Mono.just(LRemCommand.first(count).occurrencesOf(value).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<LRemCommand, Long>> lRem(Publisher<LRemCommand> var1);

    default public Mono<ByteBuffer> lPop(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.pop(Mono.just(PopCommand.left().from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> lPop(ByteBuffer key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.popList(Mono.just(PopCommand.left().from(key).count(count))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<ByteBuffer> rPop(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.pop(Mono.just(PopCommand.right().from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> rPop(ByteBuffer key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.popList(Mono.just(PopCommand.right().from(key).count(count))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<PopCommand>> pop(Publisher<PopCommand> var1);

    public Flux<ReactiveRedisConnection.CommandResponse<PopCommand, Flux<ByteBuffer>>> popList(Publisher<PopCommand> var1);

    default public Mono<PopResult> blPop(List<ByteBuffer> keys, Duration timeout) {
        Assert.notNull(keys, "Keys must not be null.");
        Assert.notNull((Object)timeout, "Timeout must not be null.");
        return this.bPop(Mono.just(BPopCommand.left().from(keys).blockingFor(timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<PopResult> brPop(List<ByteBuffer> keys, Duration timeout) {
        Assert.notNull(keys, "Keys must not be null.");
        Assert.notNull((Object)timeout, "Timeout must not be null.");
        return this.bPop(Mono.just(BPopCommand.right().from(keys).blockingFor(timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<PopResponse> bPop(Publisher<BPopCommand> var1);

    default public Mono<ByteBuffer> rPopLPush(ByteBuffer source, ByteBuffer destination) {
        Assert.notNull((Object)source, "Source must not be null!");
        Assert.notNull((Object)destination, "Destination must not be null!");
        return this.rPopLPush(Mono.just(RPopLPushCommand.from(source).to(destination))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<RPopLPushCommand>> rPopLPush(Publisher<RPopLPushCommand> var1);

    default public Mono<ByteBuffer> bRPopLPush(ByteBuffer source, ByteBuffer destination, Duration timeout) {
        Assert.notNull((Object)source, "Source must not be null!");
        Assert.notNull((Object)destination, "Destination must not be null!");
        return this.bRPopLPush(Mono.just(BRPopLPushCommand.from(source).to(destination).blockingFor(timeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<BRPopLPushCommand>> bRPopLPush(Publisher<BRPopLPushCommand> var1);

    public static class BRPopLPushCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final ByteBuffer destination;
        private final Duration timeout;

        private BRPopLPushCommand(ByteBuffer key, @Nullable ByteBuffer destination, Duration timeout) {
            super(key);
            this.destination = destination;
            this.timeout = timeout;
        }

        public static BRPopLPushCommand from(ByteBuffer sourceKey) {
            Assert.notNull((Object)sourceKey, "Source key must not be null!");
            return new BRPopLPushCommand(sourceKey, null, Duration.ZERO);
        }

        public BRPopLPushCommand to(ByteBuffer destinationKey) {
            Assert.notNull((Object)destinationKey, "Destination key must not be null!");
            return new BRPopLPushCommand(this.getKey(), destinationKey, this.timeout);
        }

        public BRPopLPushCommand blockingFor(Duration timeout) {
            Assert.notNull((Object)timeout, "Timeout must not be null!");
            return new BRPopLPushCommand(this.getKey(), this.destination, timeout);
        }

        @Nullable
        public ByteBuffer getDestination() {
            return this.destination;
        }

        public Duration getTimeout() {
            return this.timeout;
        }
    }

    public static class RPopLPushCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final ByteBuffer destination;

        private RPopLPushCommand(ByteBuffer key, @Nullable ByteBuffer destination) {
            super(key);
            this.destination = destination;
        }

        public static RPopLPushCommand from(ByteBuffer sourceKey) {
            Assert.notNull((Object)sourceKey, "Source key must not be null!");
            return new RPopLPushCommand(sourceKey, null);
        }

        public RPopLPushCommand to(ByteBuffer destinationKey) {
            Assert.notNull((Object)destinationKey, "Destination key must not be null!");
            return new RPopLPushCommand(this.getKey(), destinationKey);
        }

        @Nullable
        public ByteBuffer getDestination() {
            return this.destination;
        }
    }

    public static class PopResponse
    extends ReactiveRedisConnection.CommandResponse<BPopCommand, PopResult> {
        public PopResponse(BPopCommand input, PopResult output) {
            super(input, output);
        }
    }

    public static class PopResult {
        private final List<ByteBuffer> result;

        public PopResult(List<ByteBuffer> result) {
            this.result = result;
        }

        public ByteBuffer getKey() {
            return ObjectUtils.isEmpty(this.result) ? null : this.result.get(0);
        }

        public ByteBuffer getValue() {
            return ObjectUtils.isEmpty(this.result) ? null : this.result.get(1);
        }

        public List<ByteBuffer> getRaw() {
            return Collections.unmodifiableList(this.result);
        }
    }

    public static class BPopCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> keys;
        private final Duration timeout;
        private final Direction direction;

        private BPopCommand(List<ByteBuffer> keys, Duration timeout, Direction direction) {
            this.keys = keys;
            this.timeout = timeout;
            this.direction = direction;
        }

        public static BPopCommand right() {
            return new BPopCommand(Collections.emptyList(), Duration.ZERO, Direction.RIGHT);
        }

        public static BPopCommand left() {
            return new BPopCommand(Collections.emptyList(), Duration.ZERO, Direction.LEFT);
        }

        public BPopCommand from(List<ByteBuffer> keys) {
            Assert.notNull(keys, "Keys must not be null!");
            return new BPopCommand(new ArrayList<ByteBuffer>(keys), Duration.ZERO, this.direction);
        }

        public BPopCommand blockingFor(Duration timeout) {
            Assert.notNull((Object)timeout, "Timeout must not be null!");
            return new BPopCommand(this.keys, timeout, this.direction);
        }

        @Override
        public ByteBuffer getKey() {
            return null;
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }

    public static class PopCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final long count;
        private final Direction direction;

        private PopCommand(@Nullable ByteBuffer key, long count, Direction direction) {
            super(key);
            this.count = count;
            this.direction = direction;
        }

        public static PopCommand right() {
            return new PopCommand(null, 0L, Direction.RIGHT);
        }

        public static PopCommand left() {
            return new PopCommand(null, 0L, Direction.LEFT);
        }

        public PopCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new PopCommand(key, this.count, this.direction);
        }

        public PopCommand count(long count) {
            return new PopCommand(this.getKey(), count, this.direction);
        }

        public Direction getDirection() {
            return this.direction;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class LRemCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Long count;
        @Nullable
        private final ByteBuffer value;

        private LRemCommand(@Nullable ByteBuffer key, Long count, @Nullable ByteBuffer value) {
            super(key);
            this.count = count;
            this.value = value;
        }

        public static LRemCommand all() {
            return new LRemCommand(null, 0L, null);
        }

        public static LRemCommand first(long count) {
            return new LRemCommand(null, count, null);
        }

        public static LRemCommand last(long count) {
            Long value = count < 0L ? count : Math.negateExact(count);
            return new LRemCommand(null, value, null);
        }

        public LRemCommand occurrencesOf(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new LRemCommand(this.getKey(), this.count, value);
        }

        public LRemCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new LRemCommand(key, this.count, this.value);
        }

        public Long getCount() {
            return this.count;
        }

        @Nullable
        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static class LSetCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Long index;
        @Nullable
        private final ByteBuffer value;

        private LSetCommand(@Nullable ByteBuffer key, Long index, @Nullable ByteBuffer value) {
            super(key);
            this.index = index;
            this.value = value;
        }

        public static LSetCommand elementAt(long index) {
            return new LSetCommand(null, index, null);
        }

        public LSetCommand to(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new LSetCommand(this.getKey(), this.index, value);
        }

        public LSetCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new LSetCommand(key, this.index, this.value);
        }

        @Nullable
        public ByteBuffer getValue() {
            return this.value;
        }

        public Long getIndex() {
            return this.index;
        }
    }

    public static class BLMoveCommand
    extends LMoveCommand {
        @Nullable
        private final Duration timeout;

        private BLMoveCommand(@Nullable ByteBuffer sourceKey, @Nullable ByteBuffer destinationKey, @Nullable Direction from, @Nullable Direction to, @Nullable Duration timeout) {
            super(sourceKey, destinationKey, from, to);
            this.timeout = timeout;
        }

        @Nullable
        public Duration getTimeout() {
            return this.timeout;
        }
    }

    public static class LMoveCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final ByteBuffer destinationKey;
        @Nullable
        private final Direction from;
        @Nullable
        private final Direction to;

        public LMoveCommand(@Nullable ByteBuffer sourceKey, @Nullable ByteBuffer destinationKey, @Nullable Direction from, @Nullable Direction to) {
            super(sourceKey);
            this.destinationKey = destinationKey;
            this.from = from;
            this.to = to;
        }

        public static LMoveCommand from(ByteBuffer sourceKey, Direction sourceDirection) {
            Assert.notNull((Object)sourceKey, "Source key must not be null!");
            Assert.notNull((Object)sourceDirection, "Direction must not be null!");
            return new LMoveCommand(sourceKey, null, sourceDirection, null);
        }

        public LMoveCommand to(ByteBuffer destinationKey, Direction direction) {
            Assert.notNull((Object)destinationKey, "Destination key must not be null!");
            Assert.notNull((Object)direction, "Direction must not be null!");
            return new LMoveCommand(this.getKey(), destinationKey, this.from, direction);
        }

        public BLMoveCommand timeout(Duration timeout) {
            Assert.notNull((Object)timeout, "Timeout must not be null!");
            return new BLMoveCommand(this.getKey(), this.destinationKey, this.from, this.to, timeout);
        }

        @Nullable
        public ByteBuffer getDestinationKey() {
            return this.destinationKey;
        }

        @Nullable
        public Direction getFrom() {
            return this.from;
        }

        @Nullable
        public Direction getTo() {
            return this.to;
        }
    }

    public static class LInsertCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private final RedisListCommands.Position position;
        @Nullable
        private final ByteBuffer pivot;
        private final ByteBuffer value;

        private LInsertCommand(@Nullable ByteBuffer key, @Nullable RedisListCommands.Position position, @Nullable ByteBuffer pivot, ByteBuffer value) {
            super(key);
            this.position = position;
            this.pivot = pivot;
            this.value = value;
        }

        public static LInsertCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new LInsertCommand(null, null, null, value);
        }

        public LInsertCommand before(ByteBuffer pivot) {
            Assert.notNull((Object)pivot, "Before pivot must not be null!");
            return new LInsertCommand(this.getKey(), RedisListCommands.Position.BEFORE, pivot, this.value);
        }

        public LInsertCommand after(ByteBuffer pivot) {
            Assert.notNull((Object)pivot, "After pivot must not be null!");
            return new LInsertCommand(this.getKey(), RedisListCommands.Position.AFTER, pivot, this.value);
        }

        public LInsertCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new LInsertCommand(key, this.position, this.pivot, this.value);
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        @Nullable
        public RedisListCommands.Position getPosition() {
            return this.position;
        }

        @Nullable
        public ByteBuffer getPivot() {
            return this.pivot;
        }
    }

    public static class LIndexCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Long index;

        private LIndexCommand(@Nullable ByteBuffer key, Long index) {
            super(key);
            this.index = index;
        }

        public static LIndexCommand elementAt(long index) {
            return new LIndexCommand(null, index);
        }

        public LIndexCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new LIndexCommand(key, this.index);
        }

        public Long getIndex() {
            return this.index;
        }
    }

    public static class LPosCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer element;
        @Nullable
        private final Integer count;
        @Nullable
        private final Integer rank;

        private LPosCommand(@Nullable ByteBuffer key, ByteBuffer element, @Nullable Integer count, @Nullable Integer rank) {
            super(key);
            this.element = element;
            this.count = count;
            this.rank = rank;
        }

        public static LPosCommand lPosOf(ByteBuffer element) {
            return new LPosCommand(null, element, null, null);
        }

        public LPosCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new LPosCommand(key, this.element, this.count, this.rank);
        }

        public LPosCommand count(Integer count) {
            return new LPosCommand(this.getKey(), this.element, count, this.rank);
        }

        public LPosCommand rank(Integer rank) {
            return new LPosCommand(this.getKey(), this.element, this.count, rank);
        }

        @Nullable
        public Integer getCount() {
            return this.count;
        }

        @Nullable
        public Integer getRank() {
            return this.rank;
        }

        @Nullable
        public ByteBuffer getElement() {
            return this.element;
        }
    }

    public static class PushCommand
    extends ReactiveRedisConnection.KeyCommand {
        private List<ByteBuffer> values;
        private boolean upsert;
        private Direction direction;

        private PushCommand(@Nullable ByteBuffer key, List<ByteBuffer> values, Direction direction, boolean upsert) {
            super(key);
            this.values = values;
            this.upsert = upsert;
            this.direction = direction;
        }

        public static PushCommand right() {
            return new PushCommand(null, Collections.emptyList(), Direction.RIGHT, true);
        }

        public static PushCommand left() {
            return new PushCommand(null, Collections.emptyList(), Direction.LEFT, true);
        }

        public PushCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new PushCommand(null, Collections.singletonList(value), this.direction, this.upsert);
        }

        public PushCommand values(List<ByteBuffer> values) {
            Assert.notNull(values, "Values must not be null!");
            return new PushCommand(null, new ArrayList<ByteBuffer>(values), this.direction, this.upsert);
        }

        public PushCommand to(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new PushCommand(key, this.values, this.direction, this.upsert);
        }

        public PushCommand ifExists() {
            return new PushCommand(this.getKey(), this.values, this.direction, false);
        }

        public List<ByteBuffer> getValues() {
            return this.values;
        }

        public boolean getUpsert() {
            return this.upsert;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }

    public static enum Direction {
        LEFT,
        RIGHT;


        public static Direction first() {
            return LEFT;
        }

        public static Direction last() {
            return RIGHT;
        }
    }
}

