/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveStringCommands {
    default public Mono<Boolean> set(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.set(Mono.just(SetCommand.set(key).value(value))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> set(ByteBuffer key, ByteBuffer value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.set(Mono.just(SetCommand.set(key).value(value).withSetOption(option).expiring(expiration))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SetCommand>> set(Publisher<SetCommand> var1);

    default public Mono<ByteBuffer> get(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.get(Mono.just(new ReactiveRedisConnection.KeyCommand(key))).next().filter(ReactiveRedisConnection.CommandResponse::isPresent).map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> get(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<ByteBuffer> getDel(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.getDel(Mono.just(new ReactiveRedisConnection.KeyCommand(key))).next().filter(ReactiveRedisConnection.CommandResponse::isPresent).map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> getDel(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<ByteBuffer> getEx(ByteBuffer key, Expiration expiration) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.getEx(Mono.just(GetExCommand.key(key).withExpiration(expiration))).next().filter(ReactiveRedisConnection.CommandResponse::isPresent).map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<GetExCommand>> getEx(Publisher<GetExCommand> var1);

    default public Mono<ByteBuffer> getSet(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.getSet(Mono.just(SetCommand.set(key).value(value))).next().filter(ReactiveRedisConnection.CommandResponse::isPresent).map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<SetCommand>> getSet(Publisher<SetCommand> var1);

    default public Mono<List<ByteBuffer>> mGet(List<ByteBuffer> keys) {
        Assert.notNull(keys, "Keys must not be null!");
        return this.mGet(Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<List<ByteBuffer>, ByteBuffer>> mGet(Publisher<List<ByteBuffer>> var1);

    default public Mono<Boolean> setNX(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.setNX(Mono.just(SetCommand.set(key).value(value))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SetCommand>> setNX(Publisher<SetCommand> var1);

    default public Mono<Boolean> setEX(ByteBuffer key, ByteBuffer value, Expiration expireTimeout) {
        Assert.notNull((Object)key, "Keys must not be null!");
        Assert.notNull((Object)value, "Keys must not be null!");
        Assert.notNull((Object)expireTimeout, "ExpireTimeout must not be null!");
        return this.setEX(Mono.just(SetCommand.set(key).value(value).expiring(expireTimeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SetCommand>> setEX(Publisher<SetCommand> var1);

    default public Mono<Boolean> pSetEX(ByteBuffer key, ByteBuffer value, Expiration expireTimeout) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        Assert.notNull((Object)expireTimeout, "ExpireTimeout must not be null!");
        return this.pSetEX(Mono.just(SetCommand.set(key).value(value).expiring(expireTimeout))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SetCommand>> pSetEX(Publisher<SetCommand> var1);

    default public Mono<Boolean> mSet(Map<ByteBuffer, ByteBuffer> keyValuePairs) {
        Assert.notNull(keyValuePairs, "Key-value pairs must not be null!");
        return this.mSet(Mono.just(MSetCommand.mset(keyValuePairs))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<MSetCommand>> mSet(Publisher<MSetCommand> var1);

    default public Mono<Boolean> mSetNX(Map<ByteBuffer, ByteBuffer> keyValuePairs) {
        Assert.notNull(keyValuePairs, "Key-value pairs must not be null!");
        return this.mSetNX(Mono.just(MSetCommand.mset(keyValuePairs))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<MSetCommand>> mSetNX(Publisher<MSetCommand> var1);

    default public Mono<Long> append(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.append(Mono.just(AppendCommand.key(key).append(value))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<AppendCommand, Long>> append(Publisher<AppendCommand> var1);

    default public Mono<ByteBuffer> getRange(ByteBuffer key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.getRange(Mono.just(ReactiveRedisConnection.RangeCommand.key(key).fromIndex(start).toIndex(end))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>> getRange(Publisher<ReactiveRedisConnection.RangeCommand> var1);

    default public Mono<Long> setRange(ByteBuffer key, ByteBuffer value, long offset) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        return this.setRange(Mono.just(SetRangeCommand.overwrite(key).withValue(value).atPosition(offset))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<SetRangeCommand, Long>> setRange(Publisher<SetRangeCommand> var1);

    default public Mono<Boolean> getBit(ByteBuffer key, long offset) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.getBit(Mono.just(GetBitCommand.bit(key).atOffset(offset))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<GetBitCommand>> getBit(Publisher<GetBitCommand> var1);

    default public Mono<Boolean> setBit(ByteBuffer key, long offset, boolean value) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.setBit(Mono.just(SetBitCommand.bit(key).atOffset(offset).to(value))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SetBitCommand>> setBit(Publisher<SetBitCommand> var1);

    default public Mono<Long> bitCount(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.bitCount(Mono.just(BitCountCommand.bitCount(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> bitCount(ByteBuffer key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.bitCount(Mono.just(BitCountCommand.bitCount(key).within(Range.open(start, end)))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<BitCountCommand, Long>> bitCount(Publisher<BitCountCommand> var1);

    default public Mono<List<Long>> bitField(ByteBuffer key, BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)subCommands, "BitFieldSubCommands must not be null!");
        return this.bitField(Mono.just(BitFieldCommand.bitField(key).commands(subCommands))).map(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<BitFieldCommand, Long>> bitField(Publisher<BitFieldCommand> var1);

    default public Mono<Long> bitOp(Collection<ByteBuffer> keys, RedisStringCommands.BitOperation bitOp, ByteBuffer destination) {
        Assert.notNull(keys, "Keys must not be null!");
        Assert.notNull((Object)bitOp, "BitOperation must not be null!");
        Assert.notNull((Object)destination, "Destination must not be null!");
        return this.bitOp(Mono.just(BitOpCommand.perform(bitOp).onKeys(keys).andSaveAs(destination))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<BitOpCommand, Long>> bitOp(Publisher<BitOpCommand> var1);

    default public Mono<Long> bitPos(ByteBuffer key, boolean bit) {
        return this.bitPos(key, bit, Range.unbounded());
    }

    default public Mono<Long> bitPos(ByteBuffer key, boolean bit, Range<Long> range) {
        return this.bitPos(Mono.just(BitPosCommand.positionOf(bit).in(key).within(range))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<BitPosCommand, Long>> bitPos(Publisher<BitPosCommand> var1);

    default public Mono<Long> strLen(ByteBuffer key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return this.strLen(Mono.just(new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> strLen(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    public static class BitPosCommand
    extends ReactiveRedisConnection.KeyCommand {
        private boolean bit;
        private Range<Long> range;

        private BitPosCommand(@Nullable ByteBuffer key, boolean bit, Range<Long> range) {
            super(key);
            this.bit = bit;
            this.range = range;
        }

        static BitPosCommand positionOf(boolean bit) {
            return new BitPosCommand(null, bit, Range.unbounded());
        }

        public BitPosCommand in(ByteBuffer key) {
            return new BitPosCommand(key, this.bit, this.range);
        }

        public BitPosCommand within(Range<Long> range) {
            return new BitPosCommand(this.getKey(), this.bit, range);
        }

        public boolean getBit() {
            return this.bit;
        }

        public Range<Long> getRange() {
            return this.range;
        }
    }

    public static class BitOpCommand {
        private List<ByteBuffer> keys;
        private RedisStringCommands.BitOperation bitOp;
        @Nullable
        private ByteBuffer destinationKey;

        private BitOpCommand(List<ByteBuffer> keys, RedisStringCommands.BitOperation bitOp, @Nullable ByteBuffer destinationKey) {
            this.keys = keys;
            this.bitOp = bitOp;
            this.destinationKey = destinationKey;
        }

        public static BitOpCommand perform(RedisStringCommands.BitOperation bitOp) {
            Assert.notNull((Object)bitOp, "BitOperation must not be null!");
            return new BitOpCommand(Collections.emptyList(), bitOp, null);
        }

        public BitOpCommand onKeys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, "Keys must not be null!");
            return new BitOpCommand(new ArrayList<ByteBuffer>(keys), this.bitOp, this.destinationKey);
        }

        public BitOpCommand andSaveAs(ByteBuffer destinationKey) {
            Assert.notNull((Object)destinationKey, "Destination key must not be null!");
            return new BitOpCommand(this.keys, this.bitOp, destinationKey);
        }

        public RedisStringCommands.BitOperation getBitOp() {
            return this.bitOp;
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }

        @Nullable
        public ByteBuffer getDestinationKey() {
            return this.destinationKey;
        }
    }

    public static class BitFieldCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private BitFieldSubCommands subcommands;

        private BitFieldCommand(ByteBuffer key, @Nullable BitFieldSubCommands subcommands) {
            super(key);
            this.subcommands = subcommands;
        }

        public static BitFieldCommand bitField(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new BitFieldCommand(key, null);
        }

        public BitFieldCommand commands(BitFieldSubCommands commands) {
            Assert.notNull((Object)commands, "BitFieldCommands must not be null!");
            return new BitFieldCommand(this.getKey(), commands);
        }

        public BitFieldSubCommands getSubCommands() {
            return this.subcommands;
        }
    }

    public static class BitCountCommand
    extends ReactiveRedisConnection.KeyCommand {
        private Range<Long> range;

        private BitCountCommand(ByteBuffer key, Range<Long> range) {
            super(key);
            this.range = range;
        }

        public static BitCountCommand bitCount(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new BitCountCommand(key, Range.unbounded());
        }

        public BitCountCommand within(Range<Long> range) {
            Assert.notNull(range, "Range must not be null!");
            return new BitCountCommand(this.getKey(), range);
        }

        public Range<Long> getRange() {
            return this.range;
        }
    }

    public static class SetBitCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private Long offset;
        private boolean value;

        private SetBitCommand(ByteBuffer key, Long offset, boolean value) {
            super(key);
            this.offset = offset;
            this.value = value;
        }

        public static SetBitCommand bit(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new SetBitCommand(key, null, false);
        }

        public SetBitCommand atOffset(long index) {
            return new SetBitCommand(this.getKey(), index, this.value);
        }

        public SetBitCommand to(boolean bit) {
            return new SetBitCommand(this.getKey(), this.offset, bit);
        }

        @Nullable
        public Long getOffset() {
            return this.offset;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    public static class GetBitCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private Long offset;

        private GetBitCommand(ByteBuffer key, @Nullable Long offset) {
            super(key);
            this.offset = offset;
        }

        public static GetBitCommand bit(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new GetBitCommand(key, null);
        }

        public GetBitCommand atOffset(long offset) {
            return new GetBitCommand(this.getKey(), offset);
        }

        @Nullable
        public Long getOffset() {
            return this.offset;
        }
    }

    public static class SetRangeCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private ByteBuffer value;
        @Nullable
        private Long offset;

        private SetRangeCommand(ByteBuffer key, @Nullable ByteBuffer value, @Nullable Long offset) {
            super(key);
            this.value = value;
            this.offset = offset;
        }

        public static SetRangeCommand overwrite(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new SetRangeCommand(key, null, null);
        }

        public SetRangeCommand withValue(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new SetRangeCommand(this.getKey(), value, this.offset);
        }

        public SetRangeCommand atPosition(long index) {
            return new SetRangeCommand(this.getKey(), this.value, index);
        }

        @Nullable
        public ByteBuffer getValue() {
            return this.value;
        }

        @Nullable
        public Long getOffset() {
            return this.offset;
        }
    }

    public static class AppendCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private ByteBuffer value;

        private AppendCommand(ByteBuffer key, @Nullable ByteBuffer value) {
            super(key);
            this.value = value;
        }

        public static AppendCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new AppendCommand(key, null);
        }

        public AppendCommand append(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new AppendCommand(this.getKey(), value);
        }

        @Nullable
        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static class MSetCommand
    implements ReactiveRedisConnection.Command {
        private Map<ByteBuffer, ByteBuffer> keyValuePairs;

        private MSetCommand(Map<ByteBuffer, ByteBuffer> keyValuePairs) {
            this.keyValuePairs = keyValuePairs;
        }

        @Override
        @Nullable
        public ByteBuffer getKey() {
            return null;
        }

        public static MSetCommand mset(Map<ByteBuffer, ByteBuffer> keyValuePairs) {
            Assert.notNull(keyValuePairs, "Key-value pairs must not be null!");
            return new MSetCommand(keyValuePairs);
        }

        public Map<ByteBuffer, ByteBuffer> getKeyValuePairs() {
            return this.keyValuePairs;
        }
    }

    public static class GetExCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Expiration expiration;

        private GetExCommand(@Nullable ByteBuffer key, Expiration expiration) {
            super(key);
            Assert.notNull((Object)expiration, "Expiration must not be null!");
            this.expiration = expiration;
        }

        public static GetExCommand key(ByteBuffer key) {
            return new GetExCommand(key, Expiration.persistent());
        }

        public GetExCommand withExpiration(Expiration expiration) {
            return new GetExCommand(this.getKey(), expiration);
        }

        public Expiration getExpiration() {
            return this.expiration;
        }
    }

    public static class SetCommand
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private ByteBuffer value;
        private Expiration expiration;
        private RedisStringCommands.SetOption option;

        private SetCommand(ByteBuffer key, @Nullable ByteBuffer value, @Nullable Expiration expiration, @Nullable RedisStringCommands.SetOption option) {
            super(key);
            this.value = value;
            this.expiration = expiration;
            this.option = option;
        }

        public static SetCommand set(ByteBuffer key) {
            Assert.notNull((Object)key, "Key must not be null!");
            return new SetCommand(key, null, null, null);
        }

        public SetCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, "Value must not be null!");
            return new SetCommand(this.getKey(), value, this.expiration, this.option);
        }

        public SetCommand expiring(Expiration expiration) {
            Assert.notNull((Object)expiration, "Expiration must not be null!");
            return new SetCommand(this.getKey(), this.value, expiration, this.option);
        }

        public SetCommand withSetOption(RedisStringCommands.SetOption option) {
            Assert.notNull((Object)option, "SetOption must not be null!");
            return new SetCommand(this.getKey(), this.value, this.expiration, option);
        }

        @Nullable
        public ByteBuffer getValue() {
            return this.value;
        }

        public Optional<Expiration> getExpiration() {
            return Optional.ofNullable(this.expiration);
        }

        public Optional<RedisStringCommands.SetOption> getOption() {
            return Optional.ofNullable(this.option);
        }
    }
}

