/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.SentinelMasterId;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisConfiguration {
    default public Integer getDatabaseOrElse(Supplier<Integer> other) {
        return RedisConfiguration.getDatabaseOrElse(this, other);
    }

    default public RedisPassword getPasswordOrElse(Supplier<RedisPassword> other) {
        return RedisConfiguration.getPasswordOrElse(this, other);
    }

    public static boolean isAuthenticationAware(@Nullable RedisConfiguration configuration) {
        return configuration instanceof WithAuthentication;
    }

    public static boolean isDatabaseIndexAware(@Nullable RedisConfiguration configuration) {
        return configuration instanceof WithDatabaseIndex;
    }

    public static boolean isSentinelConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof SentinelConfiguration;
    }

    public static boolean isHostAndPortAware(@Nullable RedisConfiguration configuration) {
        return configuration instanceof WithHostAndPort;
    }

    public static boolean isClusterConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof ClusterConfiguration;
    }

    public static boolean isStaticMasterReplicaConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof StaticMasterReplicaConfiguration;
    }

    public static boolean isDomainSocketConfiguration(@Nullable RedisConfiguration configuration) {
        return configuration instanceof DomainSocketConfiguration;
    }

    public static Integer getDatabaseOrElse(@Nullable RedisConfiguration configuration, Supplier<Integer> other) {
        Assert.notNull(other, "Other must not be null!");
        return RedisConfiguration.isDatabaseIndexAware(configuration) ? Integer.valueOf(((WithDatabaseIndex)((Object)configuration)).getDatabase()) : other.get();
    }

    @Nullable
    public static String getUsernameOrElse(@Nullable RedisConfiguration configuration, Supplier<String> other) {
        Assert.notNull(other, "Other must not be null!");
        return RedisConfiguration.isAuthenticationAware(configuration) ? ((WithAuthentication)((Object)configuration)).getUsername() : other.get();
    }

    public static RedisPassword getPasswordOrElse(@Nullable RedisConfiguration configuration, Supplier<RedisPassword> other) {
        Assert.notNull(other, "Other must not be null!");
        return RedisConfiguration.isAuthenticationAware(configuration) ? ((WithAuthentication)((Object)configuration)).getPassword() : other.get();
    }

    public static int getPortOrElse(@Nullable RedisConfiguration configuration, IntSupplier other) {
        Assert.notNull((Object)other, "Other must not be null!");
        return RedisConfiguration.isHostAndPortAware(configuration) ? ((WithHostAndPort)((Object)configuration)).getPort() : other.getAsInt();
    }

    public static String getHostOrElse(@Nullable RedisConfiguration configuration, Supplier<String> other) {
        Assert.notNull(other, "Other must not be null!");
        return RedisConfiguration.isHostAndPortAware(configuration) ? ((WithHostAndPort)((Object)configuration)).getHostName() : other.get();
    }

    public static interface DomainSocketConfiguration
    extends WithDomainSocket,
    WithDatabaseIndex,
    WithPassword {
    }

    public static interface StaticMasterReplicaConfiguration
    extends WithDatabaseIndex,
    WithPassword {
        public List<RedisStandaloneConfiguration> getNodes();
    }

    public static interface ClusterConfiguration
    extends WithPassword {
        public Set<RedisNode> getClusterNodes();

        @Nullable
        public Integer getMaxRedirects();
    }

    public static interface SentinelConfiguration
    extends WithDatabaseIndex,
    WithPassword {
        default public void setMaster(String name) {
            Assert.notNull((Object)name, "Name of sentinel master must not be null.");
            this.setMaster(new SentinelMasterId(name));
        }

        public void setMaster(NamedNode var1);

        @Nullable
        public NamedNode getMaster();

        public Set<RedisNode> getSentinels();

        @Nullable
        default public String getDataNodeUsername() {
            return this.getUsername();
        }

        default public RedisPassword getDataNodePassword() {
            return this.getPassword();
        }

        public void setSentinelUsername(@Nullable String var1);

        @Nullable
        public String getSentinelUsername();

        default public void setSentinelPassword(@Nullable String password) {
            this.setSentinelPassword(RedisPassword.of(password));
        }

        default public void setSentinelPassword(@Nullable char[] password) {
            this.setSentinelPassword(RedisPassword.of(password));
        }

        public void setSentinelPassword(RedisPassword var1);

        public RedisPassword getSentinelPassword();
    }

    public static interface WithDomainSocket {
        public void setSocket(String var1);

        public String getSocket();
    }

    public static interface WithHostAndPort {
        public void setHostName(String var1);

        public String getHostName();

        public void setPort(int var1);

        public int getPort();
    }

    public static interface WithDatabaseIndex {
        public void setDatabase(int var1);

        public int getDatabase();
    }

    public static interface WithPassword
    extends WithAuthentication {
    }

    public static interface WithAuthentication {
        public void setUsername(@Nullable String var1);

        default public void setPassword(@Nullable String password) {
            this.setPassword(RedisPassword.of(password));
        }

        default public void setPassword(@Nullable char[] password) {
            this.setPassword(RedisPassword.of(password));
        }

        public void setPassword(RedisPassword var1);

        @Nullable
        public String getUsername();

        public RedisPassword getPassword();
    }
}

