/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisSentinelConfiguration
implements RedisConfiguration,
RedisConfiguration.SentinelConfiguration {
    private static final String REDIS_SENTINEL_MASTER_CONFIG_PROPERTY = "spring.redis.sentinel.master";
    private static final String REDIS_SENTINEL_NODES_CONFIG_PROPERTY = "spring.redis.sentinel.nodes";
    private static final String REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY = "spring.redis.sentinel.username";
    private static final String REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY = "spring.redis.sentinel.password";
    @Nullable
    private NamedNode master;
    private Set<RedisNode> sentinels;
    private int database;
    @Nullable
    private String dataNodeUsername = null;
    @Nullable
    private String sentinelUsername = null;
    private RedisPassword dataNodePassword = RedisPassword.none();
    private RedisPassword sentinelPassword = RedisPassword.none();

    public RedisSentinelConfiguration() {
        this(new MapPropertySource("RedisSentinelConfiguration", Collections.emptyMap()));
    }

    public RedisSentinelConfiguration(String master, Set<String> sentinelHostAndPorts) {
        this(new MapPropertySource("RedisSentinelConfiguration", RedisSentinelConfiguration.asMap(master, sentinelHostAndPorts)));
    }

    public RedisSentinelConfiguration(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, "PropertySource must not be null!");
        this.sentinels = new LinkedHashSet<RedisNode>();
        if (propertySource.containsProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY)) {
            this.setMaster(propertySource.getProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY).toString());
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY)) {
            this.appendSentinels(StringUtils.commaDelimitedListToSet(propertySource.getProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY).toString()));
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY)) {
            this.setSentinelPassword(propertySource.getProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY).toString());
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY)) {
            this.setSentinelUsername(propertySource.getProperty(REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY).toString());
        }
    }

    public void setSentinels(Iterable<RedisNode> sentinels) {
        Assert.notNull(sentinels, "Cannot set sentinels to 'null'.");
        this.sentinels.clear();
        for (RedisNode sentinel : sentinels) {
            this.addSentinel(sentinel);
        }
    }

    @Override
    public Set<RedisNode> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void addSentinel(RedisNode sentinel) {
        Assert.notNull((Object)sentinel, "Sentinel must not be 'null'.");
        this.sentinels.add(sentinel);
    }

    @Override
    public void setMaster(NamedNode master) {
        Assert.notNull((Object)master, "Sentinel master node must not be 'null'.");
        this.master = master;
    }

    @Override
    public NamedNode getMaster() {
        return this.master;
    }

    public RedisSentinelConfiguration master(String master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration master(NamedNode master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration sentinel(RedisNode sentinel) {
        this.addSentinel(sentinel);
        return this;
    }

    public RedisSentinelConfiguration sentinel(String host, Integer port) {
        return this.sentinel(new RedisNode(host, port));
    }

    private void appendSentinels(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addSentinel(RedisNode.fromString(hostAndPort));
        }
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue(index >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.dataNodeUsername = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.dataNodeUsername;
    }

    @Override
    public RedisPassword getPassword() {
        return this.dataNodePassword;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, "RedisPassword must not be null!");
        this.dataNodePassword = password;
    }

    @Override
    @Nullable
    public String getSentinelUsername() {
        return this.sentinelUsername;
    }

    @Override
    public void setSentinelUsername(@Nullable String sentinelUsername) {
        this.sentinelUsername = sentinelUsername;
    }

    @Override
    public void setSentinelPassword(RedisPassword sentinelPassword) {
        Assert.notNull((Object)sentinelPassword, "SentinelPassword must not be null!");
        this.sentinelPassword = sentinelPassword;
    }

    @Override
    public RedisPassword getSentinelPassword() {
        return this.sentinelPassword;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisSentinelConfiguration)) {
            return false;
        }
        RedisSentinelConfiguration that = (RedisSentinelConfiguration)o;
        if (this.database != that.database) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.master, that.master)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.sentinels, that.sentinels)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.dataNodeUsername, that.dataNodeUsername)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.dataNodePassword, that.dataNodePassword)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.sentinelUsername, that.sentinelUsername)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.sentinelPassword, that.sentinelPassword);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.master);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinels);
        result = 31 * result + this.database;
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.dataNodeUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.dataNodePassword);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinelUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinelPassword);
        return result;
    }

    private static Map<String, Object> asMap(String master, Set<String> sentinelHostAndPorts) {
        Assert.hasText(master, "Master address must not be null or empty!");
        Assert.notNull(sentinelHostAndPorts, "SentinelHostAndPorts must not be null!");
        Assert.noNullElements(sentinelHostAndPorts, "ClusterHostAndPorts must not contain null elements!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY, master);
        map.put(REDIS_SENTINEL_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(sentinelHostAndPorts));
        return map;
    }
}

