/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.NamedNode;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class SentinelMasterId
implements NamedNode {
    private final String name;

    public SentinelMasterId(String name) {
        Assert.hasText(name, "Sentinel Master Id must not be null or empty");
        this.name = name;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SentinelMasterId)) {
            return false;
        }
        SentinelMasterId that = (SentinelMasterId)o;
        return ObjectUtils.nullSafeEquals(this.name, that.name);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.name);
    }
}

