/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.Response;

class JedisInvoker {
    private final Synchronizer synchronizer;

    JedisInvoker(Synchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    @Nullable
    <R> R just(ConnectionFunction0<R> function) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        return (R)this.synchronizer.invoke(function::apply, it -> {
            throw new UnsupportedOperationException("Operation not supported in pipelining/transaction mode");
        }, Converters.identityConverter(), () -> null);
    }

    @Nullable
    <R> R just(ConnectionFunction0<R> function, PipelineFunction0<R> pipelineFunction) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(function::apply, pipelineFunction::apply, Converters.identityConverter(), () -> null);
    }

    @Nullable
    <R, T1> R just(ConnectionFunction1<T1, R> function, PipelineFunction1<T1, R> pipelineFunction, T1 t1) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(it -> function.apply((Jedis)it, t1), it -> pipelineFunction.apply((MultiKeyPipelineBase)it, t1));
    }

    @Nullable
    <R, T1, T2> R just(ConnectionFunction2<T1, T2, R> function, PipelineFunction2<T1, T2, R> pipelineFunction, T1 t1, T2 t2) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(it -> function.apply((Jedis)it, t1, t2), it -> pipelineFunction.apply((MultiKeyPipelineBase)it, t1, t2));
    }

    @Nullable
    <R, T1, T2, T3> R just(ConnectionFunction3<T1, T2, T3, R> function, PipelineFunction3<T1, T2, T3, R> pipelineFunction, T1 t1, T2 t2, T3 t3) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(it -> function.apply((Jedis)it, t1, t2, t3), it -> pipelineFunction.apply((MultiKeyPipelineBase)it, t1, t2, t3));
    }

    @Nullable
    <R, T1, T2, T3, T4> R just(ConnectionFunction4<T1, T2, T3, T4, R> function, PipelineFunction4<T1, T2, T3, T4, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(it -> function.apply((Jedis)it, t1, t2, t3, t4), it -> pipelineFunction.apply((MultiKeyPipelineBase)it, t1, t2, t3, t4));
    }

    @Nullable
    <R, T1, T2, T3, T4, T5> R just(ConnectionFunction5<T1, T2, T3, T4, T5, R> function, PipelineFunction5<T1, T2, T3, T4, T5, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(it -> function.apply((Jedis)it, t1, t2, t3, t4, t5), it -> pipelineFunction.apply((MultiKeyPipelineBase)it, t1, t2, t3, t4, t5));
    }

    @Nullable
    <R, T1, T2, T3, T4, T5, T6> R just(ConnectionFunction6<T1, T2, T3, T4, T5, T6, R> function, PipelineFunction6<T1, T2, T3, T4, T5, T6, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return (R)this.synchronizer.invoke(it -> function.apply((Jedis)it, t1, t2, t3, t4, t5, t6), it -> pipelineFunction.apply((MultiKeyPipelineBase)it, t1, t2, t3, t4, t5, t6));
    }

    <R> SingleInvocationSpec<R> from(ConnectionFunction0<R> function) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        return this.from(function, connection -> {
            throw new UnsupportedOperationException("Operation not supported in pipelining/transaction mode");
        });
    }

    <R> SingleInvocationSpec<R> from(ConnectionFunction0<R> function, PipelineFunction0<R> pipelineFunction) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return new DefaultSingleInvocationSpec<Object>(function::apply, pipelineFunction::apply, this.synchronizer);
    }

    <R, T1> SingleInvocationSpec<R> from(ConnectionFunction1<T1, R> function, PipelineFunction1<T1, R> pipelineFunction, T1 t1) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.from(it -> function.apply(it, t1), it -> pipelineFunction.apply(it, t1));
    }

    <R, T1, T2> SingleInvocationSpec<R> from(ConnectionFunction2<T1, T2, R> function, PipelineFunction2<T1, T2, R> pipelineFunction, T1 t1, T2 t2) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.from(it -> function.apply(it, t1, t2), it -> pipelineFunction.apply(it, t1, t2));
    }

    <R, T1, T2, T3> SingleInvocationSpec<R> from(ConnectionFunction3<T1, T2, T3, R> function, PipelineFunction3<T1, T2, T3, R> pipelineFunction, T1 t1, T2 t2, T3 t3) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.from(it -> function.apply(it, t1, t2, t3), it -> pipelineFunction.apply(it, t1, t2, t3));
    }

    <R, T1, T2, T3, T4> SingleInvocationSpec<R> from(ConnectionFunction4<T1, T2, T3, T4, R> function, PipelineFunction4<T1, T2, T3, T4, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.from(it -> function.apply(it, t1, t2, t3, t4), it -> pipelineFunction.apply(it, t1, t2, t3, t4));
    }

    <R, T1, T2, T3, T4, T5> SingleInvocationSpec<R> from(ConnectionFunction5<T1, T2, T3, T4, T5, R> function, PipelineFunction5<T1, T2, T3, T4, T5, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.from(it -> function.apply(it, t1, t2, t3, t4, t5), it -> pipelineFunction.apply(it, t1, t2, t3, t4, t5));
    }

    <R, T1, T2, T3, T4, T5, T6> SingleInvocationSpec<R> from(ConnectionFunction6<T1, T2, T3, T4, T5, T6, R> function, PipelineFunction6<T1, T2, T3, T4, T5, T6, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.from(it -> function.apply(it, t1, t2, t3, t4, t5, t6), it -> pipelineFunction.apply(it, t1, t2, t3, t4, t5, t6));
    }

    <R extends Collection<E>, E> ManyInvocationSpec<E> fromMany(ConnectionFunction0<R> function) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        return this.fromMany(function, connection -> {
            throw new UnsupportedOperationException("Operation not supported in pipelining/transaction mode");
        });
    }

    <R extends Collection<E>, E> ManyInvocationSpec<E> fromMany(ConnectionFunction0<R> function, PipelineFunction0<R> pipelineFunction) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return new DefaultManyInvocationSpec(function::apply, pipelineFunction::apply, this.synchronizer);
    }

    <R extends Collection<E>, E, T1> ManyInvocationSpec<E> fromMany(ConnectionFunction1<T1, R> function, PipelineFunction1<T1, R> pipelineFunction, T1 t1) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.fromMany(it -> (Collection)function.apply(it, t1), it -> pipelineFunction.apply(it, t1));
    }

    <R extends Collection<E>, E, T1, T2> ManyInvocationSpec<E> fromMany(ConnectionFunction2<T1, T2, R> function, PipelineFunction2<T1, T2, R> pipelineFunction, T1 t1, T2 t2) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.fromMany(it -> (Collection)function.apply(it, t1, t2), it -> pipelineFunction.apply(it, t1, t2));
    }

    <R extends Collection<E>, E, T1, T2, T3> ManyInvocationSpec<E> fromMany(ConnectionFunction3<T1, T2, T3, R> function, PipelineFunction3<T1, T2, T3, R> pipelineFunction, T1 t1, T2 t2, T3 t3) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.fromMany(it -> (Collection)function.apply(it, t1, t2, t3), it -> pipelineFunction.apply(it, t1, t2, t3));
    }

    <R extends Collection<E>, E, T1, T2, T3, T4> ManyInvocationSpec<E> fromMany(ConnectionFunction4<T1, T2, T3, T4, R> function, PipelineFunction4<T1, T2, T3, T4, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.fromMany(it -> (Collection)function.apply(it, t1, t2, t3, t4), it -> pipelineFunction.apply(it, t1, t2, t3, t4));
    }

    <R extends Collection<E>, E, T1, T2, T3, T4, T5> ManyInvocationSpec<E> fromMany(ConnectionFunction5<T1, T2, T3, T4, T5, R> function, PipelineFunction5<T1, T2, T3, T4, T5, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.fromMany(it -> (Collection)function.apply(it, t1, t2, t3, t4, t5), it -> pipelineFunction.apply(it, t1, t2, t3, t4, t5));
    }

    <R extends Collection<E>, E, T1, T2, T3, T4, T5, T6> ManyInvocationSpec<E> fromMany(ConnectionFunction6<T1, T2, T3, T4, T5, T6, R> function, PipelineFunction6<T1, T2, T3, T4, T5, T6, R> pipelineFunction, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        Assert.notNull(function, "ConnectionFunction must not be null!");
        Assert.notNull(pipelineFunction, "PipelineFunction must not be null!");
        return this.fromMany(it -> (Collection)function.apply(it, t1, t2, t3, t4, t5, t6), it -> pipelineFunction.apply(it, t1, t2, t3, t4, t5, t6));
    }

    @FunctionalInterface
    static interface Synchronizer {
        @Nullable
        default public <I, T> T invoke(Function<Jedis, I> callFunction, Function<MultiKeyPipelineBase, Response<I>> pipelineFunction) {
            return (T)this.doInvoke(callFunction, pipelineFunction, Converters.identityConverter(), () -> null);
        }

        @Nullable
        default public <I, T> T invoke(Function<Jedis, I> callFunction, Function<MultiKeyPipelineBase, Response<I>> pipelineFunction, Converter<I, T> converter, Supplier<T> nullDefault) {
            return (T)this.doInvoke(callFunction, pipelineFunction, converter, nullDefault);
        }

        @Nullable
        public Object doInvoke(Function<Jedis, Object> var1, Function<MultiKeyPipelineBase, Response<Object>> var2, Converter<Object, Object> var3, Supplier<Object> var4);
    }

    static class DefaultManyInvocationSpec<S>
    implements ManyInvocationSpec<S> {
        private final Function<Jedis, Collection<S>> parentFunction;
        private final Function<MultiKeyPipelineBase, Response<Collection<S>>> parentPipelineFunction;
        private final Synchronizer synchronizer;

        DefaultManyInvocationSpec(Function<Jedis, ? extends Collection<S>> parentFunction, Function<MultiKeyPipelineBase, Response<? extends Collection<S>>> parentPipelineFunction, Synchronizer synchronizer) {
            this.parentFunction = parentFunction;
            this.parentPipelineFunction = parentPipelineFunction;
            this.synchronizer = synchronizer;
        }

        @Override
        public <T> List<T> toList(Converter<S, T> converter) {
            Assert.notNull(converter, "Converter must not be null!");
            return this.synchronizer.invoke(this.parentFunction, this.parentPipelineFunction, source -> {
                if (source.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList result = new ArrayList(source.size());
                for (Object s : source) {
                    result.add(converter.convert(s));
                }
                return result;
            }, Collections::emptyList);
        }

        @Override
        public <T> Set<T> toSet(Converter<S, T> converter) {
            Assert.notNull(converter, "Converter must not be null!");
            return this.synchronizer.invoke(this.parentFunction, this.parentPipelineFunction, source -> {
                if (source.isEmpty()) {
                    return Collections.emptySet();
                }
                LinkedHashSet result = new LinkedHashSet(source.size());
                for (Object s : source) {
                    result.add(converter.convert(s));
                }
                return result;
            }, Collections::emptySet);
        }
    }

    static class DefaultSingleInvocationSpec<S>
    implements SingleInvocationSpec<S> {
        private final Function<Jedis, S> parentFunction;
        private final Function<MultiKeyPipelineBase, Response<S>> parentPipelineFunction;
        private final Synchronizer synchronizer;

        DefaultSingleInvocationSpec(Function<Jedis, S> parentFunction, Function<MultiKeyPipelineBase, Response<S>> parentPipelineFunction, Synchronizer synchronizer) {
            this.parentFunction = parentFunction;
            this.parentPipelineFunction = parentPipelineFunction;
            this.synchronizer = synchronizer;
        }

        @Override
        public <T> T get(Converter<S, T> converter) {
            Assert.notNull(converter, "Converter must not be null");
            return (T)this.synchronizer.invoke(this.parentFunction, this.parentPipelineFunction, converter, () -> null);
        }

        @Override
        @Nullable
        public <T> T getOrElse(Converter<S, T> converter, Supplier<T> nullDefault) {
            Assert.notNull(converter, "Converter must not be null!");
            return this.synchronizer.invoke(this.parentFunction, this.parentPipelineFunction, converter, nullDefault);
        }
    }

    @FunctionalInterface
    static interface PipelineFunction6<T1, T2, T3, T4, T5, T6, R> {
        public Response<R> apply(MultiKeyPipelineBase var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6, T6 var7);
    }

    @FunctionalInterface
    static interface PipelineFunction5<T1, T2, T3, T4, T5, R> {
        public Response<R> apply(MultiKeyPipelineBase var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6);
    }

    @FunctionalInterface
    static interface PipelineFunction4<T1, T2, T3, T4, R> {
        public Response<R> apply(MultiKeyPipelineBase var1, T1 var2, T2 var3, T3 var4, T4 var5);
    }

    @FunctionalInterface
    static interface PipelineFunction3<T1, T2, T3, R> {
        public Response<R> apply(MultiKeyPipelineBase var1, T1 var2, T2 var3, T3 var4);
    }

    @FunctionalInterface
    static interface PipelineFunction2<T1, T2, R> {
        public Response<R> apply(MultiKeyPipelineBase var1, T1 var2, T2 var3);
    }

    @FunctionalInterface
    static interface PipelineFunction1<T1, R> {
        public Response<R> apply(MultiKeyPipelineBase var1, T1 var2);
    }

    @FunctionalInterface
    static interface PipelineFunction0<R> {
        public Response<R> apply(MultiKeyPipelineBase var1);
    }

    @FunctionalInterface
    static interface ConnectionFunction6<T1, T2, T3, T4, T5, T6, R> {
        public R apply(Jedis var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6, T6 var7);
    }

    @FunctionalInterface
    static interface ConnectionFunction5<T1, T2, T3, T4, T5, R> {
        public R apply(Jedis var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6);
    }

    @FunctionalInterface
    static interface ConnectionFunction4<T1, T2, T3, T4, R> {
        public R apply(Jedis var1, T1 var2, T2 var3, T3 var4, T4 var5);
    }

    @FunctionalInterface
    static interface ConnectionFunction3<T1, T2, T3, R> {
        public R apply(Jedis var1, T1 var2, T2 var3, T3 var4);
    }

    @FunctionalInterface
    static interface ConnectionFunction2<T1, T2, R> {
        public R apply(Jedis var1, T1 var2, T2 var3);
    }

    @FunctionalInterface
    static interface ConnectionFunction1<T1, R> {
        public R apply(Jedis var1, T1 var2);
    }

    @FunctionalInterface
    static interface ConnectionFunction0<R> {
        public R apply(Jedis var1);
    }

    static interface ManyInvocationSpec<S> {
        default public List<S> toList() {
            return this.toList(Converters.identityConverter());
        }

        public <T> List<T> toList(Converter<S, T> var1);

        default public Set<S> toSet() {
            return this.toSet(Converters.identityConverter());
        }

        public <T> Set<T> toSet(Converter<S, T> var1);
    }

    static interface SingleInvocationSpec<S> {
        @Nullable
        public <T> T get(Converter<S, T> var1);

        @Nullable
        default public <T> T orElse(Converter<S, T> converter, @Nullable T nullDefault) {
            return (T)this.getOrElse(converter, () -> nullDefault);
        }

        @Nullable
        public <T> T getOrElse(Converter<S, T> var1, Supplier<T> var2);
    }
}

