/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class Jaxb2MarshallerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    Jaxb2MarshallerBeanDefinitionParser() {
    }

    @Override
    protected String getBeanClassName(Element element) {
        return "org.springframework.oxm.jaxb.Jaxb2Marshaller";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
        List<Element> classes;
        String contextPath = element.getAttribute("context-path");
        if (StringUtils.hasText(contextPath)) {
            beanDefinitionBuilder.addPropertyValue("contextPath", contextPath);
        }
        if (!(classes = DomUtils.getChildElementsByTagName(element, "class-to-be-bound")).isEmpty()) {
            ManagedList<String> classesToBeBound = new ManagedList<String>(classes.size());
            for (Element classToBeBound : classes) {
                String className = classToBeBound.getAttribute("name");
                classesToBeBound.add(className);
            }
            beanDefinitionBuilder.addPropertyValue("classesToBeBound", classesToBeBound);
        }
    }
}

