/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

abstract class PropertyDescriptor<S extends Element> {
    private final TypeElement ownerElement;
    private final ExecutableElement factoryMethod;
    private final S source;
    private final String name;
    private final TypeMirror type;
    private final VariableElement field;
    private final ExecutableElement getter;
    private final ExecutableElement setter;

    protected PropertyDescriptor(TypeElement ownerElement, ExecutableElement factoryMethod, S source, String name, TypeMirror type, VariableElement field, ExecutableElement getter, ExecutableElement setter) {
        this.ownerElement = ownerElement;
        this.factoryMethod = factoryMethod;
        this.source = source;
        this.name = name;
        this.type = type;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    TypeElement getOwnerElement() {
        return this.ownerElement;
    }

    ExecutableElement getFactoryMethod() {
        return this.factoryMethod;
    }

    S getSource() {
        return this.source;
    }

    String getName() {
        return this.name;
    }

    TypeMirror getType() {
        return this.type;
    }

    VariableElement getField() {
        return this.field;
    }

    ExecutableElement getGetter() {
        return this.getter;
    }

    ExecutableElement getSetter() {
        return this.setter;
    }

    protected abstract boolean isProperty(MetadataGenerationEnvironment var1);

    protected abstract Object resolveDefaultValue(MetadataGenerationEnvironment var1);

    protected ItemDeprecation resolveItemDeprecation(MetadataGenerationEnvironment environment2) {
        boolean deprecated = environment2.isDeprecated(this.getGetter()) || environment2.isDeprecated(this.getSetter()) || environment2.isDeprecated(this.getField()) || environment2.isDeprecated(this.getFactoryMethod());
        return deprecated ? environment2.resolveItemDeprecation(this.getGetter()) : null;
    }

    protected boolean isNested(MetadataGenerationEnvironment environment2) {
        Element typeElement = environment2.getTypeUtils().asElement(this.getType());
        if (!(typeElement instanceof TypeElement) || typeElement.getKind() == ElementKind.ENUM) {
            return false;
        }
        if (environment2.getConfigurationPropertiesAnnotation(this.getGetter()) != null) {
            return false;
        }
        if (environment2.getNestedConfigurationPropertyAnnotation(this.getField()) != null) {
            return true;
        }
        if (this.isCyclePresent(typeElement, this.getOwnerElement())) {
            return false;
        }
        return this.isParentTheSame(environment2, typeElement, this.getOwnerElement());
    }

    ItemMetadata resolveItemMetadata(String prefix, MetadataGenerationEnvironment environment2) {
        if (this.isNested(environment2)) {
            return this.resolveItemMetadataGroup(prefix, environment2);
        }
        if (this.isProperty(environment2)) {
            return this.resolveItemMetadataProperty(prefix, environment2);
        }
        return null;
    }

    private ItemMetadata resolveItemMetadataProperty(String prefix, MetadataGenerationEnvironment environment2) {
        String dataType = this.resolveType(environment2);
        String ownerType = environment2.getTypeUtils().getQualifiedName(this.getOwnerElement());
        String description = this.resolveDescription(environment2);
        Object defaultValue = this.resolveDefaultValue(environment2);
        ItemDeprecation deprecation = this.resolveItemDeprecation(environment2);
        return ItemMetadata.newProperty(prefix, this.getName(), dataType, ownerType, null, description, defaultValue, deprecation);
    }

    private ItemMetadata resolveItemMetadataGroup(String prefix, MetadataGenerationEnvironment environment2) {
        Element propertyElement = environment2.getTypeUtils().asElement(this.getType());
        String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, this.getName());
        String dataType = environment2.getTypeUtils().getQualifiedName(propertyElement);
        String ownerType = environment2.getTypeUtils().getQualifiedName(this.getOwnerElement());
        String sourceMethod = this.getGetter() != null ? this.getGetter().toString() : null;
        return ItemMetadata.newGroup(nestedPrefix, dataType, ownerType, sourceMethod);
    }

    private String resolveType(MetadataGenerationEnvironment environment2) {
        return environment2.getTypeUtils().getType(this.getOwnerElement(), this.getType());
    }

    private String resolveDescription(MetadataGenerationEnvironment environment2) {
        return environment2.getTypeUtils().getJavaDoc(this.getField());
    }

    private boolean isCyclePresent(Element returnType, Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return false;
        }
        if (element.getEnclosingElement().equals(returnType)) {
            return true;
        }
        return this.isCyclePresent(returnType, element.getEnclosingElement());
    }

    private boolean isParentTheSame(MetadataGenerationEnvironment environment2, Element returnType, TypeElement element) {
        if (returnType == null || element == null) {
            return false;
        }
        returnType = this.getTopLevelType(returnType);
        Element candidate = element;
        while (candidate != null && candidate instanceof TypeElement) {
            if (returnType.equals(this.getTopLevelType(candidate))) {
                return true;
            }
            candidate = environment2.getTypeUtils().asElement(candidate.getSuperclass());
        }
        return false;
    }

    private Element getTopLevelType(Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return element;
        }
        return this.getTopLevelType(element.getEnclosingElement());
    }
}

