/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet;

import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.servlet.ServletComponentHandler;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.util.StringUtils;

class WebServletHandler
extends ServletComponentHandler {
    WebServletHandler() {
        super(WebServlet.class);
    }

    @Override
    public void doHandle(Map<String, Object> attributes, AnnotatedBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServletRegistrationBean.class);
        builder.addPropertyValue("asyncSupported", attributes.get("asyncSupported"));
        builder.addPropertyValue("initParameters", this.extractInitParameters(attributes));
        builder.addPropertyValue("loadOnStartup", attributes.get("loadOnStartup"));
        String name = this.determineName(attributes, beanDefinition);
        builder.addPropertyValue("name", name);
        builder.addPropertyValue("servlet", beanDefinition);
        builder.addPropertyValue("urlMappings", this.extractUrlPatterns(attributes));
        builder.addPropertyValue("multipartConfig", this.determineMultipartConfig(beanDefinition));
        registry.registerBeanDefinition(name, builder.getBeanDefinition());
    }

    private String determineName(Map<String, Object> attributes, BeanDefinition beanDefinition) {
        return (String)(StringUtils.hasText((String)attributes.get("name")) ? attributes.get("name") : beanDefinition.getBeanClassName());
    }

    private MultipartConfigElement determineMultipartConfig(AnnotatedBeanDefinition beanDefinition) {
        Map<String, Object> attributes = beanDefinition.getMetadata().getAnnotationAttributes(MultipartConfig.class.getName());
        if (attributes == null) {
            return null;
        }
        return new MultipartConfigElement((String)attributes.get("location"), ((Long)attributes.get("maxFileSize")).longValue(), ((Long)attributes.get("maxRequestSize")).longValue(), ((Integer)attributes.get("fileSizeThreshold")).intValue());
    }
}

