/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.collections.cache.SimpleCache;
import com.alibaba.ageiport.common.convert.Convert;
import com.alibaba.ageiport.common.exception.UtilException;
import com.alibaba.ageiport.common.function.Filter;
import com.alibaba.ageiport.common.utils.ArrayUtils;
import com.alibaba.ageiport.common.utils.ClassUtils;
import com.alibaba.ageiport.common.utils.CollectionUtils;
import com.alibaba.ageiport.common.utils.StringUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReflectUtils {
    private static final SimpleCache<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> METHODS_CACHE = new SimpleCache();

    public static boolean isPrimitives(Class<?> cls) {
        if (cls.isArray()) {
            return ReflectUtils.isPrimitive(cls.getComponentType());
        }
        return ReflectUtils.isPrimitive(cls);
    }

    public static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == String.class || cls == Boolean.class || cls == Character.class || Number.class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtils.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtils.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectUtils.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        if (beanClass == null) {
            throw new UtilException("beanClass is null");
        }
        Constructor<?>[] constructors = CONSTRUCTORS_CACHE.get(beanClass);
        if (null != constructors) {
            return constructors;
        }
        constructors = ReflectUtils.getConstructorsDirectly(beanClass);
        return CONSTRUCTORS_CACHE.put(beanClass, constructors);
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        if (beanClass == null) {
            throw new UtilException("beanClass is null");
        }
        return beanClass.getDeclaredConstructors();
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws UtilException {
        if (field == null) {
            throw new UtilException("field is null");
        }
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassUtils.getDefaultValue(fieldType);
        }
        ReflectUtils.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(StringUtils.format("IllegalAccess for {}.{}", obj, field.getName()), e);
        }
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Object[] methodArray = ReflectUtils.getPublicMethods(clazz);
        if (ArrayUtils.isNotEmpty(methodArray)) {
            for (Object method : methodArray) {
                methodSet.add(((Method)method).getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectUtils.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollectionUtils.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet<Method> excludeMethodSet = CollectionUtils.newHashSet(excludeMethods);
        return ReflectUtils.getPublicMethods(clazz, (Method method) -> !excludeMethodSet.contains(method));
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet<String> excludeMethodNameSet = CollectionUtils.newHashSet(excludeMethodNames);
        return ReflectUtils.getPublicMethods(clazz, (Method method) -> !excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StringUtils.isBlank(methodName)) {
            return null;
        }
        return ReflectUtils.getMethod(obj.getClass(), methodName, ClassUtils.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringUtils.isBlank(methodName)) {
            return null;
        }
        Object[] methods = ReflectUtils.getMethods(clazz);
        if (ArrayUtils.isNotEmpty(methods)) {
            for (Object method : methods) {
                if (!StringUtils.equals(methodName, ((Method)method).getName(), ignoreCase) || !ClassUtils.isAllAssignableFrom(((Method)method).getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtils.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return ArrayUtils.filter(ReflectUtils.getMethods(clazz), filter);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Method[] allMethods = METHODS_CACHE.get(beanClass);
        if (null != allMethods) {
            return allMethods;
        }
        allMethods = ReflectUtils.getMethodsDirectly(beanClass, true);
        return METHODS_CACHE.put(beanClass, allMethods);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSuperClassMethods) throws SecurityException {
        if (beanClass == null) {
            throw new UtilException("beanClass is null");
        }
        Method[] allMethods = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Method[] declaredMethods = searchType.getDeclaredMethods();
            allMethods = null == allMethods ? declaredMethods : ArrayUtils.append(allMethods, declaredMethods);
            searchType = withSuperClassMethods ? searchType.getSuperclass() : null;
        }
        return allMethods;
    }

    public static <T> T newInstance(String clazz) throws UtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Throwable e) {
            throw new UtilException(StringUtils.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws UtilException {
        if (ArrayUtils.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtils.getConstructor(clazz, new Class[0]);
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new UtilException(StringUtils.format("Instance class [{}] error!", clazz), e);
            }
        }
        Class<?>[] paramTypes = ClassUtils.getClasses(params);
        Constructor<T> constructor = ReflectUtils.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: " + Arrays.stream(params).map(Object::getClass).collect(Collectors.toList()));
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Throwable e) {
            throw new UtilException(StringUtils.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass is null");
        }
        try {
            return ReflectUtils.newInstance(beanClass, new Object[0]);
        }
        catch (Throwable throwable) {
            Constructor<T>[] constructors;
            for (Constructor<T> constructor : constructors = ReflectUtils.getConstructors(beanClass)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtils.setAccessible(constructor);
                try {
                    return constructor.newInstance(ClassUtils.getDefaultValues(parameterTypes));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }
}

