/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.ext.arch.support;

import com.alibaba.ageiport.common.utils.ArrayUtils;
import com.alibaba.ageiport.ext.arch.Activate;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.ext.arch.SPI;
import java.util.Arrays;
import java.util.Comparator;

public class ActivateComparator
implements Comparator<Object> {
    public static final Comparator<Object> COMPARATOR = new ActivateComparator();

    @Override
    public int compare(Object o1, Object o2) {
        int n2;
        int n1;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        Class<?> inf = this.findSpi(o1.getClass());
        ActivateInfo a1 = this.parseActivate(o1.getClass());
        ActivateInfo a2 = this.parseActivate(o2.getClass());
        if ((a1.applicableToCompare() || a2.applicableToCompare()) && inf != null) {
            ExtensionLoader<?> extensionLoader = ExtensionLoader.getExtensionLoader(inf);
            if (a1.applicableToCompare()) {
                String n22 = extensionLoader.getExtensionName(o2.getClass());
                if (a1.isLess(n22)) {
                    return -1;
                }
                if (a1.isMore(n22)) {
                    return 1;
                }
            }
            if (a2.applicableToCompare()) {
                String n12 = extensionLoader.getExtensionName(o1.getClass());
                if (a2.isLess(n12)) {
                    return 1;
                }
                if (a2.isMore(n12)) {
                    return -1;
                }
            }
        }
        return (n1 = a1.order) > (n2 = a2.order) ? 1 : -1;
    }

    private Class<?> findSpi(Class clazz) {
        if (clazz.getInterfaces().length == 0) {
            return null;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (intf.isAnnotationPresent(SPI.class)) {
                return intf;
            }
            Class<?> result = this.findSpi(intf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ActivateInfo parseActivate(Class<?> clazz) {
        ActivateInfo info = new ActivateInfo();
        if (clazz.isAnnotationPresent(Activate.class)) {
            Activate activate = clazz.getAnnotation(Activate.class);
            ActivateInfo.access$502(info, activate.before());
            ActivateInfo.access$602(info, activate.after());
            info.order = activate.order();
        }
        return info;
    }

    private static class ActivateInfo {
        private String[] before;
        private String[] after;
        private int order;

        private ActivateInfo() {
        }

        private boolean applicableToCompare() {
            return ArrayUtils.isNotEmpty((Object[])this.before) || ArrayUtils.isNotEmpty((Object[])this.after);
        }

        private boolean isLess(String name) {
            return Arrays.asList(this.before).contains(name);
        }

        private boolean isMore(String name) {
            return Arrays.asList(this.after).contains(name);
        }

        static /* synthetic */ String[] access$502(ActivateInfo x0, String[] x1) {
            x0.before = x1;
            return x1;
        }

        static /* synthetic */ String[] access$602(ActivateInfo x0, String[] x1) {
            x0.after = x1;
            return x1;
        }
    }
}

