/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryImageProperties;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PirCommunityGalleryResource;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class CommunityGalleryImageInner
extends PirCommunityGalleryResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CommunityGalleryImageInner.class);
    @JsonProperty(value="properties")
    private CommunityGalleryImageProperties innerProperties;

    private CommunityGalleryImageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public CommunityGalleryImageInner withUniqueId(String uniqueId) {
        super.withUniqueId(uniqueId);
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public CommunityGalleryImageInner withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.innerProperties() == null ? null : this.innerProperties().osState();
    }

    public CommunityGalleryImageInner withOsState(OperatingSystemStateTypes osState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withOsState(osState);
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.innerProperties() == null ? null : this.innerProperties().endOfLifeDate();
    }

    public CommunityGalleryImageInner withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.innerProperties() == null ? null : this.innerProperties().identifier();
    }

    public CommunityGalleryImageInner withIdentifier(GalleryImageIdentifier identifier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withIdentifier(identifier);
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.innerProperties() == null ? null : this.innerProperties().recommended();
    }

    public CommunityGalleryImageInner withRecommended(RecommendedMachineConfiguration recommended) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withRecommended(recommended);
        return this;
    }

    public Disallowed disallowed() {
        return this.innerProperties() == null ? null : this.innerProperties().disallowed();
    }

    public CommunityGalleryImageInner withDisallowed(Disallowed disallowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withDisallowed(disallowed);
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperVGeneration();
    }

    public CommunityGalleryImageInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withHyperVGeneration(hyperVGeneration);
        return this;
    }

    public List<GalleryImageFeature> features() {
        return this.innerProperties() == null ? null : this.innerProperties().features();
    }

    public CommunityGalleryImageInner withFeatures(List<GalleryImageFeature> features) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withFeatures(features);
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.innerProperties() == null ? null : this.innerProperties().purchasePlan();
    }

    public CommunityGalleryImageInner withPurchasePlan(ImagePurchasePlan purchasePlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryImageProperties();
        }
        this.innerProperties().withPurchasePlan(purchasePlan);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

