/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupInstanceView;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DedicatedHostGroupProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DedicatedHostGroupProperties.class);
    @JsonProperty(value="platformFaultDomainCount", required=true)
    private int platformFaultDomainCount;
    @JsonProperty(value="hosts", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> hosts;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private DedicatedHostGroupInstanceView instanceView;
    @JsonProperty(value="supportAutomaticPlacement")
    private Boolean supportAutomaticPlacement;

    public int platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public DedicatedHostGroupProperties withPlatformFaultDomainCount(int platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public List<SubResourceReadOnly> hosts() {
        return this.hosts;
    }

    public DedicatedHostGroupInstanceView instanceView() {
        return this.instanceView;
    }

    public Boolean supportAutomaticPlacement() {
        return this.supportAutomaticPlacement;
    }

    public DedicatedHostGroupProperties withSupportAutomaticPlacement(Boolean supportAutomaticPlacement) {
        this.supportAutomaticPlacement = supportAutomaticPlacement;
        return this;
    }

    public void validate() {
        if (this.hosts() != null) {
            this.hosts().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

