/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.SharedGalleryImageVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryImageVersionInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.SharedGalleryImageVersionList;
import com.azure.resourcemanager.compute.models.SharedToValues;
import reactor.core.publisher.Mono;

public final class SharedGalleryImageVersionsClientImpl
implements SharedGalleryImageVersionsClient {
    private final ClientLogger logger = new ClientLogger(SharedGalleryImageVersionsClientImpl.class);
    private final SharedGalleryImageVersionsService service;
    private final ComputeManagementClientImpl client;

    SharedGalleryImageVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = (SharedGalleryImageVersionsService)RestProxy.create(SharedGalleryImageVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedGalleryImageVersionInner>> listSinglePageAsync(String location, String galleryUniqueName, String galleryImageName, SharedToValues sharedTo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (galleryUniqueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryUniqueName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2021-07-01", galleryUniqueName, galleryImageName, sharedTo, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedGalleryImageVersionList)res.getValue()).value(), ((SharedGalleryImageVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedGalleryImageVersionInner>> listSinglePageAsync(String location, String galleryUniqueName, String galleryImageName, SharedToValues sharedTo, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (galleryUniqueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryUniqueName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2021-07-01", galleryUniqueName, galleryImageName, sharedTo, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedGalleryImageVersionList)res.getValue()).value(), ((SharedGalleryImageVersionList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SharedGalleryImageVersionInner> listAsync(String location, String galleryUniqueName, String galleryImageName, SharedToValues sharedTo) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, galleryUniqueName, galleryImageName, sharedTo), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SharedGalleryImageVersionInner> listAsync(String location, String galleryUniqueName, String galleryImageName) {
        SharedToValues sharedTo = null;
        return new PagedFlux(() -> this.listSinglePageAsync(location, galleryUniqueName, galleryImageName, sharedTo), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SharedGalleryImageVersionInner> listAsync(String location, String galleryUniqueName, String galleryImageName, SharedToValues sharedTo, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, galleryUniqueName, galleryImageName, sharedTo, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SharedGalleryImageVersionInner> list(String location, String galleryUniqueName, String galleryImageName) {
        SharedToValues sharedTo = null;
        return new PagedIterable(this.listAsync(location, galleryUniqueName, galleryImageName, sharedTo));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SharedGalleryImageVersionInner> list(String location, String galleryUniqueName, String galleryImageName, SharedToValues sharedTo, Context context) {
        return new PagedIterable(this.listAsync(location, galleryUniqueName, galleryImageName, sharedTo, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SharedGalleryImageVersionInner>> getWithResponseAsync(String location, String galleryUniqueName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (galleryUniqueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryUniqueName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2021-07-01", galleryUniqueName, galleryImageName, galleryImageVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SharedGalleryImageVersionInner>> getWithResponseAsync(String location, String galleryUniqueName, String galleryImageName, String galleryImageVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (galleryUniqueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryUniqueName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2021-07-01", galleryUniqueName, galleryImageName, galleryImageVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharedGalleryImageVersionInner> getAsync(String location, String galleryUniqueName, String galleryImageName, String galleryImageVersionName) {
        return this.getWithResponseAsync(location, galleryUniqueName, galleryImageName, galleryImageVersionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SharedGalleryImageVersionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SharedGalleryImageVersionInner get(String location, String galleryUniqueName, String galleryImageName, String galleryImageVersionName) {
        return (SharedGalleryImageVersionInner)this.getAsync(location, galleryUniqueName, galleryImageName, galleryImageVersionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SharedGalleryImageVersionInner> getWithResponse(String location, String galleryUniqueName, String galleryImageName, String galleryImageVersionName, Context context) {
        return (Response)this.getWithResponseAsync(location, galleryUniqueName, galleryImageName, galleryImageVersionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedGalleryImageVersionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedGalleryImageVersionList)res.getValue()).value(), ((SharedGalleryImageVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedGalleryImageVersionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedGalleryImageVersionList)res.getValue()).value(), ((SharedGalleryImageVersionList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface SharedGalleryImageVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/sharedGalleries/{galleryUniqueName}/images/{galleryImageName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<SharedGalleryImageVersionList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="galleryUniqueName") String var5, @PathParam(value="galleryImageName") String var6, @QueryParam(value="sharedTo") SharedToValues var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/sharedGalleries/{galleryUniqueName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<SharedGalleryImageVersionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="galleryUniqueName") String var5, @PathParam(value="galleryImageName") String var6, @PathParam(value="galleryImageVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<SharedGalleryImageVersionList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

