/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.resourcemanager.compute.fluent.VirtualMachineExtensionsClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachineImpl;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineExtension;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionImage;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class VirtualMachineExtensionImpl
extends ExternalChildResourceImpl<VirtualMachineExtension, VirtualMachineExtensionInner, VirtualMachineImpl, VirtualMachine>
implements VirtualMachineExtension,
VirtualMachineExtension.Definition<VirtualMachine.DefinitionStages.WithCreate>,
VirtualMachineExtension.UpdateDefinition<VirtualMachine.Update>,
VirtualMachineExtension.Update {
    private final VirtualMachineExtensionsClient client;
    private HashMap<String, Object> publicSettings;
    private HashMap<String, Object> protectedSettings;

    VirtualMachineExtensionImpl(String name, VirtualMachineImpl parent, VirtualMachineExtensionInner inner, VirtualMachineExtensionsClient client) {
        super(name, (Object)parent, (Object)inner);
        this.client = client;
        this.initializeSettings();
    }

    protected static VirtualMachineExtensionImpl newVirtualMachineExtension(String name, VirtualMachineImpl parent, VirtualMachineExtensionsClient client) {
        VirtualMachineExtensionInner inner = new VirtualMachineExtensionInner();
        inner.withLocation(parent.regionName());
        VirtualMachineExtensionImpl extension = new VirtualMachineExtensionImpl(name, parent, inner, client);
        return extension;
    }

    public String id() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).id();
    }

    @Override
    public String publisherName() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).publisher();
    }

    @Override
    public String typeName() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).typePropertiesType();
    }

    @Override
    public String versionName() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).typeHandlerVersion();
    }

    @Override
    public boolean autoUpgradeMinorVersionEnabled() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).autoUpgradeMinorVersion();
    }

    @Override
    public Map<String, Object> publicSettings() {
        return Collections.unmodifiableMap(this.publicSettings);
    }

    @Override
    public String publicSettingsAsJsonString() {
        return null;
    }

    @Override
    public VirtualMachineExtensionInstanceView getInstanceView() {
        return (VirtualMachineExtensionInstanceView)this.getInstanceViewAsync().block();
    }

    @Override
    public Mono<VirtualMachineExtensionInstanceView> getInstanceViewAsync() {
        return this.client.getAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name(), "instanceView").map(inner -> inner.instanceView());
    }

    @Override
    public Map<String, String> tags() {
        TreeMap tags = ((VirtualMachineExtensionInner)((Object)this.innerModel())).tags();
        if (tags == null) {
            tags = new TreeMap();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public String provisioningState() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public VirtualMachineExtensionImpl withMinorVersionAutoUpgrade() {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withAutoUpgradeMinorVersion(true);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withoutMinorVersionAutoUpgrade() {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withAutoUpgradeMinorVersion(false);
        return this;
    }

    public VirtualMachineExtensionImpl withImage(VirtualMachineExtensionImage image) {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withPublisher(image.publisherName()).withTypePropertiesType(image.typeName()).withTypeHandlerVersion(image.versionName());
        return this;
    }

    public VirtualMachineExtensionImpl withPublisher(String extensionImagePublisherName) {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withPublisher(extensionImagePublisherName);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withPublicSetting(String key, Object value) {
        this.publicSettings.put(key, value);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withProtectedSetting(String key, Object value) {
        this.protectedSettings.put(key, value);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withPublicSettings(HashMap<String, Object> settings) {
        this.publicSettings.clear();
        this.publicSettings.putAll(settings);
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl withProtectedSettings(HashMap<String, Object> settings) {
        this.protectedSettings.clear();
        this.protectedSettings.putAll(settings);
        return this;
    }

    public VirtualMachineExtensionImpl withType(String extensionImageTypeName) {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withTypePropertiesType(extensionImageTypeName);
        return this;
    }

    public VirtualMachineExtensionImpl withVersion(String extensionImageVersionName) {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withTypeHandlerVersion(extensionImageVersionName);
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withTags(Map<String, String> tags) {
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withTag(String key, String value) {
        if (((VirtualMachineExtensionInner)((Object)this.innerModel())).tags() == null) {
            ((VirtualMachineExtensionInner)((Object)this.innerModel())).withTags((Map)new HashMap());
        }
        ((VirtualMachineExtensionInner)((Object)this.innerModel())).tags().put(key, value);
        return this;
    }

    @Override
    public final VirtualMachineExtensionImpl withoutTag(String key) {
        if (((VirtualMachineExtensionInner)((Object)this.innerModel())).tags() != null) {
            ((VirtualMachineExtensionInner)((Object)this.innerModel())).tags().remove(key);
        }
        return this;
    }

    public VirtualMachineImpl attach() {
        this.nullifySettingsIfEmpty();
        return ((VirtualMachineImpl)this.parent()).withExtension(this);
    }

    protected Mono<VirtualMachineExtensionInner> getInnerAsync() {
        String name = this.isReference() ? ResourceUtils.nameFromResourceId((String)((VirtualMachineExtensionInner)((Object)this.innerModel())).id()) : ((VirtualMachineExtensionInner)((Object)this.innerModel())).name();
        return this.client.getAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), name);
    }

    public Mono<VirtualMachineExtension> createResourceAsync() {
        VirtualMachineExtensionImpl self = this;
        return this.client.createOrUpdateAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name(), (VirtualMachineExtensionInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            self.initializeSettings();
            return self;
        });
    }

    public Mono<VirtualMachineExtension> updateResourceAsync() {
        this.nullifySettingsIfEmpty();
        if (this.isReference()) {
            String extensionName = ResourceUtils.nameFromResourceId((String)((VirtualMachineExtensionInner)((Object)this.innerModel())).id());
            return this.client.getAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), extensionName).flatMap(resource -> {
                LinkedHashMap publicSettings;
                ((VirtualMachineExtensionInner)((Object)((Object)this.innerModel()))).withPublisher(resource.publisher()).withTypePropertiesType(resource.typePropertiesType()).withTypeHandlerVersion(resource.typeHandlerVersion());
                if (((VirtualMachineExtensionInner)((Object)((Object)this.innerModel()))).autoUpgradeMinorVersion() == null) {
                    ((VirtualMachineExtensionInner)((Object)((Object)this.innerModel()))).withAutoUpgradeMinorVersion(resource.autoUpgradeMinorVersion());
                }
                if ((publicSettings = (LinkedHashMap)resource.settings()) != null && publicSettings.size() > 0) {
                    LinkedHashMap innerPublicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)((Object)this.innerModel()))).settings();
                    if (innerPublicSettings == null) {
                        ((VirtualMachineExtensionInner)((Object)((Object)this.innerModel()))).withSettings(new LinkedHashMap());
                        innerPublicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)((Object)this.innerModel()))).settings();
                    }
                    for (Map.Entry entry : publicSettings.entrySet()) {
                        if (innerPublicSettings.containsKey(entry.getKey())) continue;
                        innerPublicSettings.put((String)entry.getKey(), entry.getValue());
                    }
                }
                return this.createResourceAsync();
            });
        }
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return this.client.deleteAsync(((VirtualMachineImpl)this.parent()).resourceGroupName(), ((VirtualMachineImpl)this.parent()).name(), this.name());
    }

    public boolean isReference() {
        return ((VirtualMachineExtensionInner)((Object)this.innerModel())).name() == null;
    }

    private void nullifySettingsIfEmpty() {
        if (this.publicSettings.size() == 0) {
            ((VirtualMachineExtensionInner)((Object)this.innerModel())).withSettings(null);
        }
        if (this.protectedSettings.size() == 0) {
            ((VirtualMachineExtensionInner)((Object)this.innerModel())).withProtectedSettings(null);
        }
    }

    private void initializeSettings() {
        if (((VirtualMachineExtensionInner)((Object)this.innerModel())).settings() == null) {
            this.publicSettings = new LinkedHashMap<String, Object>();
            ((VirtualMachineExtensionInner)((Object)this.innerModel())).withSettings(this.publicSettings);
        } else {
            this.publicSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)this.innerModel())).settings();
        }
        if (((VirtualMachineExtensionInner)((Object)this.innerModel())).protectedSettings() == null) {
            this.protectedSettings = new LinkedHashMap<String, Object>();
            ((VirtualMachineExtensionInner)((Object)this.innerModel())).withProtectedSettings(this.protectedSettings);
        } else {
            this.protectedSettings = (LinkedHashMap)((VirtualMachineExtensionInner)((Object)this.innerModel())).protectedSettings();
        }
    }
}

