/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachinesClient;
import com.azure.resourcemanager.compute.fluent.models.RetrieveBootDiagnosticsDataResultInner;
import com.azure.resourcemanager.compute.fluent.models.RunCommandResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineAssessPatchesResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineCaptureResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstallPatchesResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineUpdateInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.RunCommandInput;
import com.azure.resourcemanager.compute.models.VirtualMachineCaptureParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineInstallPatchesParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineListResult;
import com.azure.resourcemanager.compute.models.VirtualMachineReimageParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualMachinesClientImpl
implements InnerSupportsGet<VirtualMachineInner>,
InnerSupportsListing<VirtualMachineInner>,
InnerSupportsDelete<Void>,
VirtualMachinesClient {
    private final ClientLogger logger = new ClientLogger(VirtualMachinesClientImpl.class);
    private final VirtualMachinesService service;
    private final ComputeManagementClientImpl client;

    VirtualMachinesClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachinesService)RestProxy.create(VirtualMachinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listByLocationSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocation(this.client.getEndpoint(), location, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listByLocationSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocation(this.client.getEndpoint(), location, "2021-07-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineInner> listByLocationAsync(String location) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(location), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineInner> listByLocationAsync(String location, Context context) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(location, context), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineInner> listByLocation(String location) {
        return new PagedIterable(this.listByLocationAsync(location));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineInner> listByLocation(String location, Context context) {
        return new PagedIterable(this.listByLocationAsync(location, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> captureWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.capture(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> captureWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.capture(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner> beginCaptureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.captureWithResponseAsync(resourceGroupName, vmName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineCaptureResultInner.class), (Type)((Object)VirtualMachineCaptureResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner> beginCaptureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.captureWithResponseAsync(resourceGroupName, vmName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineCaptureResultInner.class), (Type)((Object)VirtualMachineCaptureResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner> beginCapture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) {
        return this.beginCaptureAsync(resourceGroupName, vmName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner> beginCapture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters, Context context) {
        return this.beginCaptureAsync(resourceGroupName, vmName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineCaptureResultInner> captureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) {
        return this.beginCaptureAsync(resourceGroupName, vmName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineCaptureResultInner> captureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters, Context context) {
        return this.beginCaptureAsync(resourceGroupName, vmName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineCaptureResultInner capture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) {
        return (VirtualMachineCaptureResultInner)((Object)this.captureAsync(resourceGroupName, vmName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineCaptureResultInner capture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters, Context context) {
        return (VirtualMachineCaptureResultInner)((Object)this.captureAsync(resourceGroupName, vmName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineInner.class), (Type)((Object)VirtualMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineInner.class), (Type)((Object)VirtualMachineInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginCreateOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineInner> createOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineInner> createOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInner createOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return (VirtualMachineInner)((Object)this.createOrUpdateAsync(resourceGroupName, vmName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInner createOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters, Context context) {
        return (VirtualMachineInner)((Object)this.createOrUpdateAsync(resourceGroupName, vmName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdateAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineInner.class), (Type)((Object)VirtualMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdateAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineInner.class), (Type)((Object)VirtualMachineInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdate(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, vmName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineInner>, VirtualMachineInner> beginUpdate(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineInner> updateAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, vmName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineInner> updateAsync(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInner update(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters) {
        return (VirtualMachineInner)((Object)this.updateAsync(resourceGroupName, vmName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInner update(String resourceGroupName, String vmName, VirtualMachineUpdateInner parameters, Context context) {
        return (VirtualMachineInner)((Object)this.updateAsync(resourceGroupName, vmName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName, Boolean forceDeletion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, vmName, forceDeletion, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName, Boolean forceDeletion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, vmName, forceDeletion, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName, Boolean forceDeletion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmName, forceDeletion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName, Boolean forceDeletion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmName, forceDeletion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, Boolean forceDeletion) {
        return this.beginDeleteAsync(resourceGroupName, vmName, forceDeletion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, Boolean forceDeletion, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmName, forceDeletion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String vmName, Boolean forceDeletion) {
        return this.beginDeleteAsync(resourceGroupName, vmName, forceDeletion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String vmName) {
        Boolean forceDeletion = null;
        return this.beginDeleteAsync(resourceGroupName, vmName, forceDeletion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String vmName, Boolean forceDeletion, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmName, forceDeletion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName, Boolean forceDeletion) {
        this.deleteAsync(resourceGroupName, vmName, forceDeletion).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName) {
        Boolean forceDeletion = null;
        this.deleteAsync(resourceGroupName, vmName, forceDeletion).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName, Boolean forceDeletion, Context context) {
        this.deleteAsync(resourceGroupName, vmName, forceDeletion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vmName, InstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, vmName, expand, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vmName, InstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, vmName, expand, "2021-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName, InstanceViewTypes expand) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, vmName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName) {
        InstanceViewTypes expand = null;
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, vmName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInner getByResourceGroup(String resourceGroupName, String vmName) {
        InstanceViewTypes expand = null;
        return (VirtualMachineInner)((Object)this.getByResourceGroupAsync(resourceGroupName, vmName, expand).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineInner> getByResourceGroupWithResponse(String resourceGroupName, String vmName, InstanceViewTypes expand, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, vmName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineInstanceViewInner>> instanceViewWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.instanceView(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineInstanceViewInner>> instanceViewWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.instanceView(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineInstanceViewInner> instanceViewAsync(String resourceGroupName, String vmName) {
        return this.instanceViewWithResponseAsync(resourceGroupName, vmName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineInstanceViewInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInstanceViewInner instanceView(String resourceGroupName, String vmName) {
        return (VirtualMachineInstanceViewInner)this.instanceViewAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineInstanceViewInner> instanceViewWithResponse(String resourceGroupName, String vmName, Context context) {
        return (Response)this.instanceViewWithResponseAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> convertToManagedDisksWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.convertToManagedDisks(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> convertToManagedDisksWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.convertToManagedDisks(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginConvertToManagedDisksAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.convertToManagedDisksWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginConvertToManagedDisksAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.convertToManagedDisksWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginConvertToManagedDisks(String resourceGroupName, String vmName) {
        return this.beginConvertToManagedDisksAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginConvertToManagedDisks(String resourceGroupName, String vmName, Context context) {
        return this.beginConvertToManagedDisksAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> convertToManagedDisksAsync(String resourceGroupName, String vmName) {
        return this.beginConvertToManagedDisksAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> convertToManagedDisksAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginConvertToManagedDisksAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void convertToManagedDisks(String resourceGroupName, String vmName) {
        this.convertToManagedDisksAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void convertToManagedDisks(String resourceGroupName, String vmName, Context context) {
        this.convertToManagedDisksAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmName, Boolean hibernate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.deallocate(this.client.getEndpoint(), resourceGroupName, vmName, hibernate, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmName, Boolean hibernate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.deallocate(this.client.getEndpoint(), resourceGroupName, vmName, hibernate, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmName, Boolean hibernate) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deallocateWithResponseAsync(resourceGroupName, vmName, hibernate);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmName, Boolean hibernate, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deallocateWithResponseAsync(resourceGroupName, vmName, hibernate, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmName, Boolean hibernate) {
        return this.beginDeallocateAsync(resourceGroupName, vmName, hibernate).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmName, Boolean hibernate, Context context) {
        return this.beginDeallocateAsync(resourceGroupName, vmName, hibernate, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deallocateAsync(String resourceGroupName, String vmName, Boolean hibernate) {
        return this.beginDeallocateAsync(resourceGroupName, vmName, hibernate).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deallocateAsync(String resourceGroupName, String vmName) {
        Boolean hibernate = null;
        return this.beginDeallocateAsync(resourceGroupName, vmName, hibernate).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deallocateAsync(String resourceGroupName, String vmName, Boolean hibernate, Context context) {
        return this.beginDeallocateAsync(resourceGroupName, vmName, hibernate, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocate(String resourceGroupName, String vmName, Boolean hibernate) {
        this.deallocateAsync(resourceGroupName, vmName, hibernate).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocate(String resourceGroupName, String vmName) {
        Boolean hibernate = null;
        this.deallocateAsync(resourceGroupName, vmName, hibernate).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocate(String resourceGroupName, String vmName, Boolean hibernate, Context context) {
        this.deallocateAsync(resourceGroupName, vmName, hibernate, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> generalizeWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.generalize(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> generalizeWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.generalize(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> generalizeAsync(String resourceGroupName, String vmName) {
        return this.generalizeWithResponseAsync(resourceGroupName, vmName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void generalize(String resourceGroupName, String vmName) {
        this.generalizeAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> generalizeWithResponse(String resourceGroupName, String vmName, Context context) {
        return (Response)this.generalizeWithResponseAsync(resourceGroupName, vmName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2021-07-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listSinglePageAsync(String statusOnly) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2021-07-01", this.client.getSubscriptionId(), statusOnly, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listSinglePageAsync(String statusOnly, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2021-07-01", this.client.getSubscriptionId(), statusOnly, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineInner> listAsync(String statusOnly) {
        return new PagedFlux(() -> this.listSinglePageAsync(statusOnly), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineInner> listAsync() {
        String statusOnly = null;
        return new PagedFlux(() -> this.listSinglePageAsync(statusOnly), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineInner> listAsync(String statusOnly, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(statusOnly, context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineInner> list() {
        String statusOnly = null;
        return new PagedIterable(this.listAsync(statusOnly));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineInner> list(String statusOnly, Context context) {
        return new PagedIterable(this.listAsync(statusOnly, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineSizeInner>> listAvailableSizesSinglePageAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableSizes(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineSizeListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineSizeInner>> listAvailableSizesSinglePageAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailableSizes(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineSizeListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineSizeInner> listAvailableSizesAsync(String resourceGroupName, String vmName) {
        return new PagedFlux(() -> this.listAvailableSizesSinglePageAsync(resourceGroupName, vmName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineSizeInner> listAvailableSizesAsync(String resourceGroupName, String vmName, Context context) {
        return new PagedFlux(() -> this.listAvailableSizesSinglePageAsync(resourceGroupName, vmName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String vmName) {
        return new PagedIterable(this.listAvailableSizesAsync(resourceGroupName, vmName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String vmName, Context context) {
        return new PagedIterable(this.listAvailableSizesAsync(resourceGroupName, vmName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmName, Boolean skipShutdown) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.powerOff(this.client.getEndpoint(), resourceGroupName, vmName, skipShutdown, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmName, Boolean skipShutdown, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.powerOff(this.client.getEndpoint(), resourceGroupName, vmName, skipShutdown, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmName, Boolean skipShutdown) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, vmName, skipShutdown);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmName, Boolean skipShutdown, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, vmName, skipShutdown, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmName, Boolean skipShutdown) {
        return this.beginPowerOffAsync(resourceGroupName, vmName, skipShutdown).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmName, Boolean skipShutdown, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, vmName, skipShutdown, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> powerOffAsync(String resourceGroupName, String vmName, Boolean skipShutdown) {
        return this.beginPowerOffAsync(resourceGroupName, vmName, skipShutdown).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> powerOffAsync(String resourceGroupName, String vmName) {
        Boolean skipShutdown = null;
        return this.beginPowerOffAsync(resourceGroupName, vmName, skipShutdown).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> powerOffAsync(String resourceGroupName, String vmName, Boolean skipShutdown, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, vmName, skipShutdown, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void powerOff(String resourceGroupName, String vmName, Boolean skipShutdown) {
        this.powerOffAsync(resourceGroupName, vmName, skipShutdown).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void powerOff(String resourceGroupName, String vmName) {
        Boolean skipShutdown = null;
        this.powerOffAsync(resourceGroupName, vmName, skipShutdown).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void powerOff(String resourceGroupName, String vmName, Boolean skipShutdown, Context context) {
        this.powerOffAsync(resourceGroupName, vmName, skipShutdown, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> reapplyWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reapply(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reapplyWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.reapply(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginReapplyAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reapplyWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginReapplyAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reapplyWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReapply(String resourceGroupName, String vmName) {
        return this.beginReapplyAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReapply(String resourceGroupName, String vmName, Context context) {
        return this.beginReapplyAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reapplyAsync(String resourceGroupName, String vmName) {
        return this.beginReapplyAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> reapplyAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginReapplyAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reapply(String resourceGroupName, String vmName) {
        this.reapplyAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reapply(String resourceGroupName, String vmName, Context context) {
        this.reapplyAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmName) {
        return this.beginRestartAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmName, Context context) {
        return this.beginRestartAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String vmName) {
        return this.beginRestartAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restartAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginRestartAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String vmName) {
        this.restartAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String vmName, Context context) {
        this.restartAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmName) {
        return this.beginStartAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmName, Context context) {
        return this.beginStartAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String resourceGroupName, String vmName) {
        return this.beginStartAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> startAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginStartAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String vmName) {
        this.startAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String vmName, Context context) {
        this.startAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.redeploy(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.redeploy(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.redeployWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.redeployWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmName) {
        return this.beginRedeployAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmName, Context context) {
        return this.beginRedeployAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redeployAsync(String resourceGroupName, String vmName) {
        return this.beginRedeployAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> redeployAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginRedeployAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void redeploy(String resourceGroupName, String vmName) {
        this.redeployAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void redeploy(String resourceGroupName, String vmName, Context context) {
        this.redeployAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.reimage(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, vmName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, vmName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters) {
        return this.beginReimageAsync(resourceGroupName, vmName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters, Context context) {
        return this.beginReimageAsync(resourceGroupName, vmName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reimageAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters) {
        return this.beginReimageAsync(resourceGroupName, vmName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reimageAsync(String resourceGroupName, String vmName) {
        VirtualMachineReimageParameters parameters = null;
        return this.beginReimageAsync(resourceGroupName, vmName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> reimageAsync(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters, Context context) {
        return this.beginReimageAsync(resourceGroupName, vmName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimage(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters) {
        this.reimageAsync(resourceGroupName, vmName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimage(String resourceGroupName, String vmName) {
        VirtualMachineReimageParameters parameters = null;
        this.reimageAsync(resourceGroupName, vmName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimage(String resourceGroupName, String vmName, VirtualMachineReimageParameters parameters, Context context) {
        this.reimageAsync(resourceGroupName, vmName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RetrieveBootDiagnosticsDataResultInner>> retrieveBootDiagnosticsDataWithResponseAsync(String resourceGroupName, String vmName, Integer sasUriExpirationTimeInMinutes) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.retrieveBootDiagnosticsData(this.client.getEndpoint(), resourceGroupName, vmName, sasUriExpirationTimeInMinutes, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RetrieveBootDiagnosticsDataResultInner>> retrieveBootDiagnosticsDataWithResponseAsync(String resourceGroupName, String vmName, Integer sasUriExpirationTimeInMinutes, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.retrieveBootDiagnosticsData(this.client.getEndpoint(), resourceGroupName, vmName, sasUriExpirationTimeInMinutes, "2021-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RetrieveBootDiagnosticsDataResultInner> retrieveBootDiagnosticsDataAsync(String resourceGroupName, String vmName, Integer sasUriExpirationTimeInMinutes) {
        return this.retrieveBootDiagnosticsDataWithResponseAsync(resourceGroupName, vmName, sasUriExpirationTimeInMinutes).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RetrieveBootDiagnosticsDataResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RetrieveBootDiagnosticsDataResultInner> retrieveBootDiagnosticsDataAsync(String resourceGroupName, String vmName) {
        Integer sasUriExpirationTimeInMinutes = null;
        return this.retrieveBootDiagnosticsDataWithResponseAsync(resourceGroupName, vmName, sasUriExpirationTimeInMinutes).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RetrieveBootDiagnosticsDataResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RetrieveBootDiagnosticsDataResultInner retrieveBootDiagnosticsData(String resourceGroupName, String vmName) {
        Integer sasUriExpirationTimeInMinutes = null;
        return (RetrieveBootDiagnosticsDataResultInner)this.retrieveBootDiagnosticsDataAsync(resourceGroupName, vmName, sasUriExpirationTimeInMinutes).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RetrieveBootDiagnosticsDataResultInner> retrieveBootDiagnosticsDataWithResponse(String resourceGroupName, String vmName, Integer sasUriExpirationTimeInMinutes, Context context) {
        return (Response)this.retrieveBootDiagnosticsDataWithResponseAsync(resourceGroupName, vmName, sasUriExpirationTimeInMinutes, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.performMaintenance(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.performMaintenance(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.performMaintenanceWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.performMaintenanceWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmName) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmName, Context context) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmName) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void performMaintenance(String resourceGroupName, String vmName) {
        this.performMaintenanceAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void performMaintenance(String resourceGroupName, String vmName, Context context) {
        this.performMaintenanceAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> simulateEvictionWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        return FluxUtil.withContext(context -> this.service.simulateEviction(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> simulateEvictionWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        context = this.client.mergeContext(context);
        return this.service.simulateEviction(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> simulateEvictionAsync(String resourceGroupName, String vmName) {
        return this.simulateEvictionWithResponseAsync(resourceGroupName, vmName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void simulateEviction(String resourceGroupName, String vmName) {
        this.simulateEvictionAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> simulateEvictionWithResponse(String resourceGroupName, String vmName, Context context) {
        return (Response)this.simulateEvictionWithResponseAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> assessPatchesWithResponseAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.assessPatches(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> assessPatchesWithResponseAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.assessPatches(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner> beginAssessPatchesAsync(String resourceGroupName, String vmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.assessPatchesWithResponseAsync(resourceGroupName, vmName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineAssessPatchesResultInner.class), (Type)((Object)VirtualMachineAssessPatchesResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner> beginAssessPatchesAsync(String resourceGroupName, String vmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.assessPatchesWithResponseAsync(resourceGroupName, vmName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineAssessPatchesResultInner.class), (Type)((Object)VirtualMachineAssessPatchesResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner> beginAssessPatches(String resourceGroupName, String vmName) {
        return this.beginAssessPatchesAsync(resourceGroupName, vmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineAssessPatchesResultInner>, VirtualMachineAssessPatchesResultInner> beginAssessPatches(String resourceGroupName, String vmName, Context context) {
        return this.beginAssessPatchesAsync(resourceGroupName, vmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineAssessPatchesResultInner> assessPatchesAsync(String resourceGroupName, String vmName) {
        return this.beginAssessPatchesAsync(resourceGroupName, vmName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineAssessPatchesResultInner> assessPatchesAsync(String resourceGroupName, String vmName, Context context) {
        return this.beginAssessPatchesAsync(resourceGroupName, vmName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineAssessPatchesResultInner assessPatches(String resourceGroupName, String vmName) {
        return (VirtualMachineAssessPatchesResultInner)this.assessPatchesAsync(resourceGroupName, vmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineAssessPatchesResultInner assessPatches(String resourceGroupName, String vmName, Context context) {
        return (VirtualMachineAssessPatchesResultInner)this.assessPatchesAsync(resourceGroupName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> installPatchesWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (installPatchesInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter installPatchesInput is required and cannot be null."));
        }
        installPatchesInput.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.installPatches(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), installPatchesInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> installPatchesWithResponseAsync(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (installPatchesInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter installPatchesInput is required and cannot be null."));
        }
        installPatchesInput.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.installPatches(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), installPatchesInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner> beginInstallPatchesAsync(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.installPatchesWithResponseAsync(resourceGroupName, vmName, installPatchesInput);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineInstallPatchesResultInner.class), (Type)((Object)VirtualMachineInstallPatchesResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner> beginInstallPatchesAsync(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.installPatchesWithResponseAsync(resourceGroupName, vmName, installPatchesInput, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineInstallPatchesResultInner.class), (Type)((Object)VirtualMachineInstallPatchesResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner> beginInstallPatches(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput) {
        return this.beginInstallPatchesAsync(resourceGroupName, vmName, installPatchesInput).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineInstallPatchesResultInner>, VirtualMachineInstallPatchesResultInner> beginInstallPatches(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput, Context context) {
        return this.beginInstallPatchesAsync(resourceGroupName, vmName, installPatchesInput, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineInstallPatchesResultInner> installPatchesAsync(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput) {
        return this.beginInstallPatchesAsync(resourceGroupName, vmName, installPatchesInput).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineInstallPatchesResultInner> installPatchesAsync(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput, Context context) {
        return this.beginInstallPatchesAsync(resourceGroupName, vmName, installPatchesInput, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInstallPatchesResultInner installPatches(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput) {
        return (VirtualMachineInstallPatchesResultInner)this.installPatchesAsync(resourceGroupName, vmName, installPatchesInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineInstallPatchesResultInner installPatches(String resourceGroupName, String vmName, VirtualMachineInstallPatchesParameters installPatchesInput, Context context) {
        return (VirtualMachineInstallPatchesResultInner)this.installPatchesAsync(resourceGroupName, vmName, installPatchesInput, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String vmName, RunCommandInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.runCommand(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json, text/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String vmName, RunCommandInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.runCommand(this.client.getEndpoint(), resourceGroupName, vmName, "2021-07-01", this.client.getSubscriptionId(), parameters, "application/json, text/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommandAsync(String resourceGroupName, String vmName, RunCommandInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, vmName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RunCommandResultInner.class), (Type)((Object)RunCommandResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommandAsync(String resourceGroupName, String vmName, RunCommandInput parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, vmName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RunCommandResultInner.class), (Type)((Object)RunCommandResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommand(String resourceGroupName, String vmName, RunCommandInput parameters) {
        return this.beginRunCommandAsync(resourceGroupName, vmName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommand(String resourceGroupName, String vmName, RunCommandInput parameters, Context context) {
        return this.beginRunCommandAsync(resourceGroupName, vmName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunCommandResultInner> runCommandAsync(String resourceGroupName, String vmName, RunCommandInput parameters) {
        return this.beginRunCommandAsync(resourceGroupName, vmName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RunCommandResultInner> runCommandAsync(String resourceGroupName, String vmName, RunCommandInput parameters, Context context) {
        return this.beginRunCommandAsync(resourceGroupName, vmName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunCommandResultInner runCommand(String resourceGroupName, String vmName, RunCommandInput parameters) {
        return (RunCommandResultInner)this.runCommandAsync(resourceGroupName, vmName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunCommandResultInner runCommand(String resourceGroupName, String vmName, RunCommandInput parameters, Context context) {
        return (RunCommandResultInner)this.runCommandAsync(resourceGroupName, vmName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listByLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineListResult)res.getValue()).value(), ((VirtualMachineListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface VirtualMachinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/virtualMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineListResult>> listByLocation(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/capture")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> capture(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineCaptureParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineUpdateInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="forceDeletion") Boolean var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="$expand") InstanceViewTypes var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/instanceView")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineInstanceViewInner>> instanceView(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/convertToManagedDisks")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> convertToManagedDisks(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/deallocate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deallocate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="hibernate") Boolean var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/generalize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> generalize(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="statusOnly") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/vmSizes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineSizeListResult>> listAvailableSizes(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/powerOff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> powerOff(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="skipShutdown") Boolean var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/reapply")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> reapply(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/redeploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> redeploy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineReimageParameters var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/retrieveBootDiagnosticsData")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<RetrieveBootDiagnosticsDataResultInner>> retrieveBootDiagnosticsData(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="sasUriExpirationTimeInMinutes") Integer var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/performMaintenance")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> performMaintenance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/simulateEviction")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> simulateEviction(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/assessPatches")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> assessPatches(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/installPatches")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> installPatches(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualMachineInstallPatchesParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommand")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runCommand(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") RunCommandInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineListResult>> listByLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineListResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

