/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CloudServiceExtensionProfile;
import com.azure.resourcemanager.compute.models.CloudServiceNetworkProfile;
import com.azure.resourcemanager.compute.models.CloudServiceOsProfile;
import com.azure.resourcemanager.compute.models.CloudServiceRoleProfile;
import com.azure.resourcemanager.compute.models.CloudServiceUpgradeMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CloudServiceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CloudServiceProperties.class);
    @JsonProperty(value="packageUrl")
    private String packageUrl;
    @JsonProperty(value="configuration")
    private String configuration;
    @JsonProperty(value="configurationUrl")
    private String configurationUrl;
    @JsonProperty(value="startCloudService")
    private Boolean startCloudService;
    @JsonProperty(value="allowModelOverride")
    private Boolean allowModelOverride;
    @JsonProperty(value="upgradeMode")
    private CloudServiceUpgradeMode upgradeMode;
    @JsonProperty(value="roleProfile")
    private CloudServiceRoleProfile roleProfile;
    @JsonProperty(value="osProfile")
    private CloudServiceOsProfile osProfile;
    @JsonProperty(value="networkProfile")
    private CloudServiceNetworkProfile networkProfile;
    @JsonProperty(value="extensionProfile")
    private CloudServiceExtensionProfile extensionProfile;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;

    public String packageUrl() {
        return this.packageUrl;
    }

    public CloudServiceProperties withPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
        return this;
    }

    public String configuration() {
        return this.configuration;
    }

    public CloudServiceProperties withConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    public String configurationUrl() {
        return this.configurationUrl;
    }

    public CloudServiceProperties withConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public Boolean startCloudService() {
        return this.startCloudService;
    }

    public CloudServiceProperties withStartCloudService(Boolean startCloudService) {
        this.startCloudService = startCloudService;
        return this;
    }

    public Boolean allowModelOverride() {
        return this.allowModelOverride;
    }

    public CloudServiceProperties withAllowModelOverride(Boolean allowModelOverride) {
        this.allowModelOverride = allowModelOverride;
        return this;
    }

    public CloudServiceUpgradeMode upgradeMode() {
        return this.upgradeMode;
    }

    public CloudServiceProperties withUpgradeMode(CloudServiceUpgradeMode upgradeMode) {
        this.upgradeMode = upgradeMode;
        return this;
    }

    public CloudServiceRoleProfile roleProfile() {
        return this.roleProfile;
    }

    public CloudServiceProperties withRoleProfile(CloudServiceRoleProfile roleProfile) {
        this.roleProfile = roleProfile;
        return this;
    }

    public CloudServiceOsProfile osProfile() {
        return this.osProfile;
    }

    public CloudServiceProperties withOsProfile(CloudServiceOsProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public CloudServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public CloudServiceProperties withNetworkProfile(CloudServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public CloudServiceExtensionProfile extensionProfile() {
        return this.extensionProfile;
    }

    public CloudServiceProperties withExtensionProfile(CloudServiceExtensionProfile extensionProfile) {
        this.extensionProfile = extensionProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public void validate() {
        if (this.roleProfile() != null) {
            this.roleProfile().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.extensionProfile() != null) {
            this.extensionProfile().validate();
        }
    }
}

