/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.ImageProperties;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageStorageProfile;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ImageUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImageUpdate.class);
    @JsonProperty(value="properties")
    private ImageProperties innerProperties;

    private ImageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ImageUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource sourceVirtualMachine() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceVirtualMachine();
    }

    public ImageUpdate withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withSourceVirtualMachine(sourceVirtualMachine);
        return this;
    }

    public ImageStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public ImageUpdate withStorageProfile(ImageStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperVGeneration();
    }

    public ImageUpdate withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withHyperVGeneration(hyperVGeneration);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

