/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.SourceVault;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class KeyVaultAndSecretReference {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(KeyVaultAndSecretReference.class);
    @JsonProperty(value="sourceVault", required=true)
    private SourceVault sourceVault;
    @JsonProperty(value="secretUrl", required=true)
    private String secretUrl;

    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    public KeyVaultAndSecretReference withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public String secretUrl() {
        return this.secretUrl;
    }

    public KeyVaultAndSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    public void validate() {
        if (this.sourceVault() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceVault in model KeyVaultAndSecretReference"));
        }
        this.sourceVault().validate();
        if (this.secretUrl() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretUrl in model KeyVaultAndSecretReference"));
        }
    }
}

