/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.rules;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Arrays;
import java.util.Set;

public enum NamingStrategy {
    no_change,
    underline_to_camel;


    public static String underlineToCamel(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        String tempName = name;
        if (StringUtils.isCapitalMode((String)name) || StringUtils.isMixedMode((String)name)) {
            tempName = name.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        String[] camels = tempName.split("_");
        Arrays.stream(camels).filter(camel -> !StringUtils.isBlank((CharSequence)camel)).forEach(camel -> {
            if (result.length() == 0) {
                result.append(StringUtils.firstToLowerCase((String)camel));
            } else {
                result.append(NamingStrategy.capitalFirst(camel));
            }
        });
        return result.toString();
    }

    public static String removePrefix(String name, Set<String> prefix) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        return prefix.stream().filter(pf -> name.toLowerCase().startsWith(pf.toLowerCase())).findFirst().map(pf -> name.substring(pf.length())).orElse(name);
    }

    public static String removePrefixAndCamel(String name, Set<String> prefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, prefix));
    }

    public static String removeSuffix(String name, Set<String> suffix) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        return suffix.stream().filter(sf -> name.toLowerCase().endsWith(sf.toLowerCase())).findFirst().map(sf -> name.substring(0, name.length() - sf.length())).orElse(name);
    }

    public static String removeSuffixAndCamel(String name, Set<String> suffix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removeSuffix(name, suffix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

