/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.impl.http;

import com.ericsson.research.trap.impl.http.HTTPServletAdaptor;
import com.ericsson.research.trap.impl.http.HTTPServletUtil;
import com.ericsson.research.trap.impl.http.HTTPSession;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPServlet25
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String path = "/_trap";
    private String ctxPath;
    private int off = 0;

    public HTTPServlet25() {
    }

    public HTTPServlet25(int off) {
        this.off = off;
    }

    public void init(ServletConfig arg0) throws ServletException {
        super.init(arg0);
        ServletContext ctx = this.getServletContext();
        this.init(ctx);
    }

    public void init(ServletContext ctx) {
        this.ctxPath = ctx.getContextPath();
        this.ctxPath = String.valueOf(this.ctxPath) + this.path;
        HTTPServletAdaptor.addServletContext(this.ctxPath);
    }

    public void destroy() {
        HTTPServletAdaptor.removeServletContext(this.ctxPath);
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.internalService(arg0, arg1);
    }

    protected void doDelete(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.internalService(arg0, arg1);
    }

    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.internalService(arg0, arg1);
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.internalService(arg0, arg1);
    }

    protected void doPut(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.internalService(arg0, arg1);
    }

    public void internalService(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        HTTPSession sess = new HTTPSession(){

            @Override
            public HttpServletResponse response() {
                return resp;
            }

            @Override
            public HttpServletRequest request() {
                return req;
            }

            @Override
            public void finish() {
                latch.countDown();
            }

            @Override
            public boolean isFinished() {
                return latch.getCount() <= 0L;
            }
        };
        HTTPServletUtil.addCorsHeaders(req, resp);
        String[] ctx = HTTPServletUtil.getContexts(req, this.path);
        HTTPServletAdaptor.handle(sess, ctx[0 + this.off], ctx[1 + this.off], ctx[2 + this.off]);
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            resp.setStatus(200);
        }
    }
}

