/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.impl.http;

import com.ericsson.research.trap.TrapException;
import com.ericsson.research.trap.impl.http.HTTPHandler;
import com.ericsson.research.trap.impl.http.HTTPSession;
import com.ericsson.research.trap.spi.transports.HTTPServletListener;
import com.ericsson.research.trap.utils.UID;
import com.ericsson.research.trap.utils.WeakMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class HTTPServletAdaptor {
    private static final WeakMap<String, HTTPServletListener> listeners = new WeakMap();
    private static final ConcurrentSkipListSet<String> servletContexts = new ConcurrentSkipListSet();

    public static synchronized String addListener(HTTPServletListener listener, String contextPath, String resPath) throws TrapException {
        if (contextPath != null && !servletContexts.contains(contextPath)) {
            throw new TrapException("Tried to register a context at an unknown path; context " + contextPath + " not represented in known contexts " + servletContexts);
        }
        if (resPath != null && listeners.containsKey((Object)resPath)) {
            throw new TrapException("Requested path [" + resPath + "] already occupied.");
        }
        if (contextPath == null) {
            contextPath = servletContexts.first();
        }
        String id = resPath != null ? resPath : UID.randomUID();
        listeners.put((Object)id, (Object)listener);
        return String.valueOf(contextPath) + "/" + id;
    }

    public static void removeListener(String contextPath) {
        if (contextPath.contains("/")) {
            contextPath = contextPath.split("/")[1];
        }
        listeners.remove((Object)contextPath);
    }

    public static void addServletContext(String ctx) {
        servletContexts.add(ctx);
    }

    public static void removeServletContext(String ctx) {
        servletContexts.remove(ctx);
    }

    public static HTTPHandler handle(HTTPSession session, String servletContextName, String trapContextName, String trapSessionId) {
        HTTPServletListener listener;
        if (trapContextName != null && trapContextName.trim().length() >= 0 && (listener = (HTTPServletListener)((Object)listeners.get((Object)trapContextName))) != null) {
            return listener.handle(session, trapSessionId);
        }
        session.response().setStatus(404);
        session.finish();
        return null;
    }

    public static boolean hasContexts() {
        return servletContexts.size() > 0;
    }
}

