/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.spi.transports;

import com.ericsson.research.trap.TrapException;
import com.ericsson.research.trap.impl.http.HTTPHandler;
import com.ericsson.research.trap.impl.http.HTTPHoster;
import com.ericsson.research.trap.impl.http.HTTPServletAdaptor;
import com.ericsson.research.trap.impl.http.HTTPSession;
import com.ericsson.research.trap.spi.ListenerTrapTransport;
import com.ericsson.research.trap.spi.ListenerTrapTransportDelegate;
import com.ericsson.research.trap.spi.TrapConfiguration;
import com.ericsson.research.trap.spi.TrapHostingTransport;
import com.ericsson.research.trap.spi.TrapTransport;
import com.ericsson.research.trap.spi.transports.AbstractListenerTransport;
import com.ericsson.research.trap.spi.transports.HTTPServletTransport;
import com.ericsson.research.trap.utils.UID;
import com.ericsson.research.trap.utils.WeakMap;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.WeakHashMap;

public class HTTPServletListener
extends AbstractListenerTransport
implements ListenerTrapTransport,
TrapHostingTransport {
    private ListenerTrapTransportDelegate listener;
    private Object listenerContext;
    private String ctxPath;
    WeakMap<String, HTTPHandler> sessions = new WeakMap();
    WeakHashMap<TrapHostingTransport.TrapHostable, HTTPHandler> hosters = new WeakHashMap();

    public HTTPServletListener() throws TrapException {
        this.transportPriority = 1110;
        if (!HTTPServletAdaptor.hasContexts()) {
            throw new TrapException("No contexts found for Servlet listener. Aborting...");
        }
    }

    public String getTransportName() {
        return "http";
    }

    public void listen(ListenerTrapTransportDelegate listener, Object context) throws TrapException {
        this.listener = listener;
        this.listenerContext = context;
        String ctxPath = this.getOption("context");
        String resPath = this.getOption("path");
        this.ctxPath = HTTPServletAdaptor.addListener(this, ctxPath, resPath);
        if (this.getOption("autoconfig.port") == null) {
            this.logger.warn("Servlet HTTP transport improperly configured. Please configure autoconfig.port. Autoconfig has been disabled for the listener...");
        }
        if (this.getOption("autoconfig.host") == null) {
            this.logger.warn("Servlet HTTP transport improperly configured. Please configure autoconfig.host. Defaulting to localhost with no discovery...");
        }
    }

    public void getClientConfiguration(TrapConfiguration destination, String defaultHost) {
        String url = this.getUrl(defaultHost);
        if (url != null) {
            destination.setOption(this.prefix, "url", url);
        }
    }

    public String getProtocolName() {
        return "http";
    }

    public void fillAuthenticationKeys(HashSet<String> keys) {
        super.fillAuthenticationKeys(keys);
    }

    protected void internalDisconnect() {
        HTTPServletAdaptor.removeListener(this.ctxPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPHandler handle(HTTPSession session, String trapSessionId) {
        if (trapSessionId != null && trapSessionId.trim().length() != 0) {
            HTTPHandler transport = (HTTPHandler)this.sessions.get((Object)trapSessionId);
            if (transport == null) {
                session.response().setStatus(404);
                session.finish();
                return null;
            }
            transport.handle(session);
            return transport;
        }
        String id = UID.randomUID();
        HTTPServletTransport t = new HTTPServletTransport(this, id);
        WeakMap<String, HTTPHandler> weakMap = this.sessions;
        synchronized (weakMap) {
            this.sessions.put((Object)id, (Object)t);
        }
        this.listener.ttsIncomingConnection((TrapTransport)t, (ListenerTrapTransport)this, this.listenerContext);
        try {
            session.response().setStatus(200);
            session.response().getWriter().print(id);
            session.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addHostedObject(TrapHostingTransport.TrapHostable hosted, String preferredPath) {
        HTTPHoster hoster = null;
        WeakMap<String, HTTPHandler> weakMap = this.sessions;
        synchronized (weakMap) {
            if (preferredPath == null || this.sessions.containsKey((Object)preferredPath)) {
                preferredPath = UID.randomUID();
            }
            hoster = new HTTPHoster(hosted);
            this.sessions.put((Object)preferredPath, (Object)hoster);
        }
        this.hosters.put(hosted, hoster);
        URI uri = URI.create(String.valueOf(this.getUrl(null)) + "/" + preferredPath);
        hosted.setURI(uri);
        return uri;
    }

    private String getUrl(String defaultHost) {
        String path;
        String scheme;
        String port = this.getOption("autoconfig.port");
        if (port == null) {
            return null;
        }
        String hostName = this.getOption("autoconfig.host");
        if (hostName == null) {
            hostName = defaultHost;
        }
        if (hostName == null) {
            hostName = "localhost";
        }
        if ((scheme = this.getOption("autoconfig.scheme")) == null) {
            scheme = "http";
        }
        if ((path = this.getOption("autoconfig.path")) == null) {
            path = this.ctxPath;
        }
        String url = String.valueOf(scheme) + "://" + hostName + ":" + port + this.ctxPath;
        return url;
    }

    public void flushTransport() {
    }
}

