/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.spi.transports;

import com.ericsson.research.trap.TrapException;
import com.ericsson.research.trap.impl.http.HTTPHandler;
import com.ericsson.research.trap.impl.http.HTTPSession;
import com.ericsson.research.trap.spi.TrapMessage;
import com.ericsson.research.trap.spi.TrapTransport;
import com.ericsson.research.trap.spi.TrapTransportException;
import com.ericsson.research.trap.spi.TrapTransportState;
import com.ericsson.research.trap.spi.transports.AbstractTransport;
import com.ericsson.research.trap.spi.transports.HTTPServletListener;
import com.ericsson.research.trap.utils.ThreadPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;

public class HTTPServletTransport
extends AbstractTransport
implements HTTPHandler {
    private HTTPServletListener listener;
    private String id;
    private final Object sendQueueLock = new Object();
    LinkedBlockingQueue<TrapMessage> messagesToSend = new LinkedBlockingQueue();
    LinkedBlockingQueue<TrapMessage> flushedMessages = new LinkedBlockingQueue();
    private TrapTransportState oldState;
    private final Object sendLock = new Object();
    private final Object receiveLock = new Object();
    private HTTPSession longpoll;
    private HTTPReaper reaper = new HTTPReaper();
    long expirationDelay = 28000L;
    long reregistrationTimeout = 10000L;

    public HTTPServletTransport(HTTPServletListener listener, String id) {
        this.listener = listener;
        this.id = id;
        this.state = TrapTransportState.CONNECTED;
        ThreadPool.executeAfter((Runnable)this.reaper, (long)(this.expirationDelay + this.reregistrationTimeout));
    }

    public String getTransportName() {
        return "http";
    }

    protected String getProtocolName() {
        return "http";
    }

    public void fillAuthenticationKeys(HashSet keys) {
        super.fillAuthenticationKeys(keys);
    }

    protected void updateConfig() {
        super.updateConfig();
        String newReregistrationTimeout = this.getOption("reregistrationTimeout");
        try {
            this.reregistrationTimeout = Long.parseLong(newReregistrationTimeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String newexpirationDelay = this.getOption("expirationDelay");
        try {
            this.expirationDelay = Long.parseLong(newexpirationDelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSend(TrapMessage message, boolean expectMore) throws TrapTransportException {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.getState() != TrapTransportState.AVAILABLE && message.getMessageId() != 0) {
                throw new TrapTransportException(message, this.getState());
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Queueing message id {} to send with HTTP; got more is [{}]", (Object)message.getMessageId(), (Object)expectMore);
            }
            Object object2 = this.sendQueueLock;
            synchronized (object2) {
                this.messagesToSend.add(message);
            }
            if (expectMore) {
                return;
            }
            this.flushTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTransport() {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.getState() == TrapTransportState.AVAILABLE) {
                this.oldState = this.getState();
                this.setState(TrapTransportState.UNAVAILABLE);
            }
            this.finishLongpoll(false);
        }
    }

    protected void internalConnect() throws TrapException {
        throw new TrapException("Cannot connect a servlet transport");
    }

    protected void internalDisconnect() {
        this.mDisconnect();
    }

    public void forceError() {
        this.mDisconnect();
        super.forceError();
    }

    protected void setState(TrapTransportState newState) {
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(final HTTPSession session) {
        String method = session.request().getMethod();
        this.lastAlive = System.currentTimeMillis();
        if ("POST".equalsIgnoreCase(method)) {
            try {
                Object object = this.receiveLock;
                synchronized (object) {
                    ServletInputStream is = session.request().getInputStream();
                    int read = 0;
                    int received = 0;
                    byte[] buf = new byte[4096];
                    while ((read = is.read(buf)) > -1) {
                        ++received;
                        this.receive(buf, 0, read);
                    }
                    if (received == 0) {
                        this.mDisconnect();
                    }
                    session.response().setStatus(204);
                    session.response().setContentLength(0);
                    session.response().flushBuffer();
                    session.finish();
                }
            }
            catch (Exception e) {
                this.logger.error("Exception during receiving of a message", (Throwable)e);
                session.response().setStatus(500);
                session.finish();
            }
        } else {
            if ("GET".equalsIgnoreCase(method)) {
                Object object = this.sendLock;
                synchronized (object) {
                    if (this.longpoll != null) {
                        if (this.longpoll == session) {
                            this.logger.error("If you see this message, report as bug, kkthx");
                        } else {
                            this.logger.warn("Received long poll while old poll wasn't null. Oops...");
                            this.finishLongpoll(true);
                        }
                    }
                    if (this.messagesToSend.size() > 0) {
                        this.longpoll = session;
                        this.finishLongpoll(false);
                        return;
                    }
                    if (this.getState() == TrapTransportState.DISCONNECTED || this.getState() == TrapTransportState.ERROR) {
                        session.response().setStatus(404);
                        try {
                            session.response().flushBuffer();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        session.finish();
                        return;
                    }
                    this.longpoll = session;
                    if (this.getState() == TrapTransportState.UNAVAILABLE) {
                        this.setState(this.oldState);
                    } else if (this.getState() == TrapTransportState.CONNECTING) {
                        this.setState(TrapTransportState.CONNECTED);
                    }
                    ThreadPool.executeAfter((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = HTTPServletTransport.this.sendLock;
                            synchronized (object) {
                                if (!session.isFinished()) {
                                    if (session == HTTPServletTransport.this.longpoll) {
                                        HTTPServletTransport.this.finishLongpoll(true);
                                    } else {
                                        session.response().setStatus(400);
                                        session.finish();
                                    }
                                }
                            }
                        }
                    }, (long)this.reregistrationTimeout);
                }
            }
            if ("DELETE".equalsIgnoreCase(method)) {
                this.mDisconnect();
                session.response().setStatus(204);
                session.response().setContentLength(0);
                session.finish();
            } else if ("PUT".equalsIgnoreCase(method)) {
                this.mDisconnect();
                session.response().setStatus(204);
                session.response().setContentLength(0);
                session.finish();
            } else if ("OPTIONS".equalsIgnoreCase(method)) {
                session.response().setStatus(200);
                session.response().setContentLength(0);
                session.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishLongpoll(boolean timeout) {
        Object object = this.sendLock;
        synchronized (object) {
            block26: {
                if (this.longpoll == null) {
                    return;
                }
                try {
                    Object object2 = this.sendQueueLock;
                    synchronized (object2) {
                        if (this.messagesToSend.size() > 0) {
                            LinkedBlockingQueue<TrapMessage> flushing = this.messagesToSend;
                            this.messagesToSend = this.flushedMessages;
                            this.flushedMessages = flushing;
                        }
                    }
                    if (this.flushedMessages.size() > 0) {
                        try {
                            block27: {
                                try {
                                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                    for (TrapMessage m : this.flushedMessages) {
                                        if (this.logger.isTraceEnabled()) {
                                            this.logger.trace("Flushing message with id {}", (Object)m.getMessageId());
                                        }
                                        bos.write(m.serialize());
                                    }
                                    byte[] body = bos.toByteArray();
                                    this.longpoll.response().setStatus(201);
                                    this.longpoll.response().setContentLength(body.length);
                                    ServletOutputStream os = this.longpoll.response().getOutputStream();
                                    os.write(body);
                                    os.flush();
                                    os.close();
                                    this.longpoll.finish();
                                    break block26;
                                }
                                catch (Exception e) {
                                    this.logger.debug("Error during serialization of messages", (Throwable)e);
                                    if (this.flushedMessages.size() <= 0) break block27;
                                    Object object3 = this.sendQueueLock;
                                    synchronized (object3) {
                                        this.flushedMessages.addAll(this.messagesToSend);
                                        this.messagesToSend.clear();
                                        LinkedBlockingQueue<TrapMessage> tmp = this.flushedMessages;
                                        this.flushedMessages = this.messagesToSend;
                                        this.messagesToSend = tmp;
                                        LinkedList<TrapMessage> failedMessages = new LinkedList<TrapMessage>();
                                        for (TrapMessage m : this.messagesToSend) {
                                            if (m.getMessageId() == 0) continue;
                                            failedMessages.add(m);
                                        }
                                        this.delegate.ttMessagesFailedSending(failedMessages, (TrapTransport)this, this.delegateContext);
                                    }
                                }
                            }
                            this.longpoll.response().setStatus(500);
                            this.longpoll.response().setContentLength(0);
                            this.longpoll.finish();
                            break block26;
                        }
                        finally {
                            this.flushedMessages.clear();
                        }
                    }
                    if (timeout) {
                        this.longpoll.response().setStatus(204);
                        this.longpoll.response().setContentLength(0);
                        this.longpoll.finish();
                    }
                }
                finally {
                    if (this.longpoll.isFinished()) {
                        this.longpoll = null;
                    }
                    if (this.getState() == TrapTransportState.CONNECTED || this.getState() == TrapTransportState.AVAILABLE) {
                        this.oldState = this.getState();
                        this.setState(TrapTransportState.UNAVAILABLE);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mDisconnect() {
        if (this.state == TrapTransportState.DISCONNECTED || this.state == TrapTransportState.ERROR) {
            return;
        }
        this.setState(TrapTransportState.DISCONNECTING);
        this.setState(TrapTransportState.DISCONNECTED);
        this.finishLongpoll(true);
        Object object = this.sendQueueLock;
        synchronized (object) {
            if (this.messagesToSend.size() > 0) {
                this.delegate.ttMessagesFailedSending(this.messagesToSend, (TrapTransport)this, this.delegateContext);
            }
        }
    }

    protected void acknowledgeTransitMessage(TrapMessage message) {
    }

    class HTTPReaper
    implements Runnable {
        HTTPReaper() {
        }

        @Override
        public void run() {
            if (HTTPServletTransport.this.longpoll == null) {
                long expiry = HTTPServletTransport.this.lastAlive + HTTPServletTransport.this.expirationDelay + HTTPServletTransport.this.reregistrationTimeout;
                if (System.currentTimeMillis() >= expiry) {
                    HTTPServletTransport.this.mDisconnect();
                }
            }
        }
    }
}

