/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.apache.http.impl.entity;

import com.facebook.presto.jdbc.internal.apache.http.HttpException;
import com.facebook.presto.jdbc.internal.apache.http.HttpMessage;
import com.facebook.presto.jdbc.internal.apache.http.ProtocolException;
import com.facebook.presto.jdbc.internal.apache.http.annotation.Contract;
import com.facebook.presto.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.facebook.presto.jdbc.internal.apache.http.entity.ContentLengthStrategy;
import com.facebook.presto.jdbc.internal.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

