/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.array;

import com.facebook.presto.jdbc.internal.common.array.ObjectBigArray;
import com.facebook.presto.jdbc.internal.common.array.ReferenceCountMap;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;

public final class SliceBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceBigArray.class).instanceSize();
    private static final int SLICE_INSTANCE_SIZE = ClassLayout.parseClass(Slice.class).instanceSize();
    private final ObjectBigArray<Slice> array;
    private final ReferenceCountMap trackedSlices = new ReferenceCountMap();
    private long sizeOfSlices;

    public SliceBigArray() {
        this.array = new ObjectBigArray();
    }

    public SliceBigArray(Slice slice) {
        this.array = new ObjectBigArray(slice);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfSlices + this.trackedSlices.sizeOf();
    }

    public Slice get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Slice value) {
        this.updateRetainedSize(index, value);
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    private void updateRetainedSize(long index, Slice value) {
        int sliceReferenceCount;
        int baseReferenceCount;
        Slice currentValue = this.array.get(index);
        if (currentValue != null) {
            baseReferenceCount = this.trackedSlices.decrementAndGet(currentValue.getBase());
            sliceReferenceCount = this.trackedSlices.decrementAndGet(currentValue);
            if (baseReferenceCount == 0) {
                this.sizeOfSlices -= currentValue.getRetainedSize();
            } else if (sliceReferenceCount == 0) {
                this.sizeOfSlices -= (long)SLICE_INSTANCE_SIZE;
            }
        }
        if (value != null) {
            baseReferenceCount = this.trackedSlices.incrementAndGet(value.getBase());
            sliceReferenceCount = this.trackedSlices.incrementAndGet(value);
            if (baseReferenceCount == 1) {
                this.sizeOfSlices += value.getRetainedSize();
            } else if (sliceReferenceCount == 1) {
                this.sizeOfSlices += (long)SLICE_INSTANCE_SIZE;
            }
        }
    }
}

