/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.common.type.BigintType;
import com.facebook.presto.jdbc.internal.common.type.EnumType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.TypeUtils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BigintEnumType
extends AbstractLongType
implements EnumType<Long> {
    private final LongEnumMap enumMap;

    public BigintEnumType(LongEnumMap enumMap) {
        super(new TypeSignature("BigintEnum", TypeSignatureParameter.of(enumMap)));
        this.enumMap = enumMap;
    }

    @Override
    public Map<String, Long> getEnumMap() {
        return this.enumMap.getEnumMap();
    }

    @Override
    public Optional<String> getEnumKeyForValue(Long value) {
        return this.enumMap.getKeyForValue(value);
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getLong(position);
    }

    @Override
    public Type getValueType() {
        return BigintType.BIGINT;
    }

    @Override
    public String getDisplayName() {
        return this.enumMap.getTypeName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTypeSignature().getBase(), this.enumMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigintEnumType other = (BigintEnumType)o;
        return Objects.equals(this.getTypeSignature().getBase(), other.getTypeSignature().getBase()) && Objects.equals(this.getEnumMap(), other.getEnumMap());
    }

    public static class LongEnumMap {
        private final String typeName;
        private final Map<String, Long> enumMap;
        private final Map<Long, String> flippedEnumMap;

        @JsonCreator
        public LongEnumMap(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="enumMap") Map<String, Long> enumMap) {
            TypeUtils.validateEnumMap(Objects.requireNonNull(enumMap, "enumMap is null"));
            this.typeName = Objects.requireNonNull(typeName.toLowerCase(Locale.ENGLISH), "typeName is null");
            this.enumMap = TypeUtils.normalizeEnumMap(enumMap);
            this.flippedEnumMap = this.enumMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        }

        @JsonProperty
        public String getTypeName() {
            return this.typeName;
        }

        @JsonProperty
        public Map<String, Long> getEnumMap() {
            return this.enumMap;
        }

        public Optional<String> getKeyForValue(Long value) {
            return Optional.ofNullable(this.flippedEnumMap.get(value));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongEnumMap other = (LongEnumMap)o;
            return Objects.equals(this.typeName, other.typeName) && Objects.equals(this.enumMap, other.enumMap);
        }

        public String toString() {
            return String.format("%s{%s}", this.typeName, this.enumMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> String.format("\"%s\": %d", ((String)e.getKey()).replaceAll("\"", "\"\""), e.getValue())).collect(Collectors.joining(", ")));
        }

        public int hashCode() {
            return Objects.hash(this.typeName, this.enumMap);
        }
    }
}

