/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.NotSupportedException;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.RowBlockBuilder;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractType;
import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.RowFieldName;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RowType
extends AbstractType {
    private final List<Field> fields;
    private final List<Type> fieldTypes;

    private RowType(TypeSignature typeSignature, List<Field> fields) {
        super(typeSignature, Block.class);
        this.fields = fields;
        this.fieldTypes = fields.stream().map(Field::getType).collect(Collectors.toList());
    }

    public static RowType from(List<Field> fields) {
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType anonymous(List<Type> types) {
        List<Field> fields = types.stream().map(type -> new Field(Optional.empty(), (Type)type)).collect(Collectors.toList());
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType withDefaultFieldNames(List<Type> types) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < types.size(); ++i) {
            fields.add(new Field(Optional.of("field" + i), types.get(i)));
        }
        return new RowType(RowType.makeSignature(fields), fields);
    }

    public static RowType createWithTypeSignature(TypeSignature typeSignature, List<Field> fields) {
        return new RowType(typeSignature, fields);
    }

    public static Field field(String name, Type type) {
        return new Field(Optional.of(name), type);
    }

    public static Field field(Type type) {
        return new Field(Optional.empty(), type);
    }

    private static TypeSignature makeSignature(List<Field> fields) {
        int size = fields.size();
        if (size == 0) {
            throw new IllegalArgumentException("Row type must have at least 1 field");
        }
        List<TypeSignatureParameter> parameters = fields.stream().map(field -> TypeSignatureParameter.of(new NamedTypeSignature(field.getName().map(name -> new RowFieldName((String)name, false)), field.getType().getTypeSignature()))).collect(Collectors.toList());
        return new TypeSignature("row", parameters);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new RowBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return new RowBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries);
    }

    @Override
    public String getDisplayName() {
        StringBuilder result = new StringBuilder();
        result.append("row").append('(');
        for (Field field : this.fields) {
            String typeDisplayName = field.getType().getDisplayName();
            if (field.getName().isPresent()) {
                result.append("\"").append(field.getName().get()).append("\"").append(' ').append(typeDisplayName);
            } else {
                result.append(typeDisplayName);
            }
            result.append(", ");
        }
        result.setLength(result.length() - 2);
        result.append(')');
        return result.toString();
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block arrayBlock = this.getObject(block, position);
        ArrayList<Object> values = new ArrayList<Object>(arrayBlock.getPositionCount());
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            values.add(this.fields.get(i).getType().getObjectValue(properties, arrayBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writePositionTo(position, blockBuilder);
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getBlock(position);
    }

    @Override
    public Block getBlockUnchecked(Block block, int internalPosition) {
        return block.getBlockUnchecked(internalPosition);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.appendStructure((Block)value);
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.fieldTypes;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public boolean isComparable() {
        return this.fields.stream().allMatch(field -> field.getType().isComparable());
    }

    @Override
    public boolean isOrderable() {
        return this.fields.stream().allMatch(field -> field.getType().isOrderable());
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftRow = leftBlock.getBlock(leftPosition);
        Block rightRow = rightBlock.getBlock(rightPosition);
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            RowType.checkElementNotNull(leftRow.isNull(i));
            RowType.checkElementNotNull(rightRow.isNull(i));
            Type fieldType = this.fields.get(i).getType();
            if (fieldType.equalTo(leftRow, i, rightRow, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftRow = leftBlock.getBlock(leftPosition);
        Block rightRow = rightBlock.getBlock(rightPosition);
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            RowType.checkElementNotNull(leftRow.isNull(i));
            RowType.checkElementNotNull(rightRow.isNull(i));
            Type fieldType = this.fields.get(i).getType();
            if (!fieldType.isOrderable()) {
                throw new UnsupportedOperationException(fieldType.getTypeSignature() + " type is not orderable");
            }
            int compareResult = fieldType.compareTo(leftRow, i, rightRow, i);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }

    @Override
    public long hash(Block block, int position) {
        Block arrayBlock = block.getBlock(position);
        long result = 1L;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            Type elementType = this.fields.get(i).getType();
            result = 31L * result + TypeUtils.hashPosition(elementType, arrayBlock, i);
        }
        return result;
    }

    private static void checkElementNotNull(boolean isNull) {
        if (isNull) {
            throw new NotSupportedException("ROW comparison not supported for fields with null elements");
        }
    }

    public static class Field {
        private final Type type;
        private final Optional<String> name;

        public Field(Optional<String> name, Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

