/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.connector.ConnectorMetadataUpdater;
import java.util.Optional;

public class PageSinkContext {
    private static final PageSinkContext DEFAULT_PAGE_SINK_CONTEXT = PageSinkContext.builder().build();
    private final boolean commitRequired;
    private final Optional<ConnectorMetadataUpdater> metadataUpdater;

    private PageSinkContext(boolean commitRequired, Optional<ConnectorMetadataUpdater> metadataUpdater) {
        this.commitRequired = commitRequired;
        this.metadataUpdater = metadataUpdater;
    }

    public static PageSinkContext defaultContext() {
        return DEFAULT_PAGE_SINK_CONTEXT;
    }

    public boolean isCommitRequired() {
        return this.commitRequired;
    }

    public Optional<ConnectorMetadataUpdater> getMetadataUpdater() {
        return this.metadataUpdater;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean commitRequired;
        private Optional<ConnectorMetadataUpdater> metadataUpdater = Optional.empty();

        public Builder setCommitRequired(boolean commitRequired) {
            this.commitRequired = commitRequired;
            return this;
        }

        public Builder setConnectorMetadataUpdater(ConnectorMetadataUpdater metadataUpdater) {
            this.metadataUpdater = Optional.of(metadataUpdater);
            return this;
        }

        public PageSinkContext build() {
            return new PageSinkContext(this.commitRequired, this.metadataUpdater);
        }
    }
}

