/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.page;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum PageCodecMarker {
    COMPRESSED(1),
    ENCRYPTED(2),
    CHECKSUMMED(3);

    private final int mask;

    private PageCodecMarker(int bit) {
        PageCodecMarker.checkArgument(bit > 0 && bit <= 8, "PageCodecMarker bit must be between 1 and 8. Found: %s", bit);
        this.mask = 1 << bit - 1;
    }

    public boolean isSet(byte value) {
        return (Byte.toUnsignedInt(value) & this.mask) == this.mask;
    }

    public byte set(byte value) {
        return (byte)(Byte.toUnsignedInt(value) | this.mask);
    }

    public byte unset(byte value) {
        return (byte)(Byte.toUnsignedInt(value) & ~this.mask);
    }

    public static byte none() {
        return 0;
    }

    public static String toSummaryString(byte markers) {
        if (markers == PageCodecMarker.none()) {
            return "NONE";
        }
        return Arrays.stream(PageCodecMarker.values()).filter(marker -> marker.isSet(markers)).map(Enum::name).collect(Collectors.joining(", "));
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }
}

