package com.fasc.open.api.enums.app;

/**
 * 集成应用的上线状态枚举
 * @author zhoufucheng
 * @date 2022/9/20 10:52
 */
public enum AppStatusEnum {
    PENDING("待上线", "pending"),
    LIVE("已上线", "live"),
    VERIFYING("审核中", "verifying"),
    DISABLED("已停用", "disabled"),
    OFFLINE("已下线,被动关停下线", "offline"),
    ;
    private final String msg ;
    private final String code;

    private AppStatusEnum(String msg, String code){
        this.msg = msg ;
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public String getCode() {
        return code;
    }
}
