package com.fasc.open.api.event.signtask;/**
 * @author xjf
 * @date 2023年11月15日 10:12
 */

import java.util.List;

/**
 * 成员加入移除事件，回调给客户的实体类
 *
 * @author xjf
 * @date 2023年11月15日 10:12
 */
public class SignTaskMemberJoinRemoveCallbackDto {

    /**
     * 事件触发时间。格式为[Unix标准时间戳](#时间标签取值说明)（毫秒）
     */
    private String eventTime;

    /**
     * 签署任务ID。长度最大20个字符。
     */
    private String signTaskId;

    /**
     * 事件发生后最新的签署任务状态。以下其中一种
     * fill_progress：填写中（填写参与方进行填写）
     * fill_completed：填写已完成（填写的所有参与方已完成填写，但尚未定稿）
     * sign_progress：签署中 (签署参与方进行签署)
     */
    private String signTaskStatus;

    /**
     * 参与方信息
     */
    private List<MemberJoinActorInfo> actorInfo;

    private String transReferenceId;

    public String getTransReferenceId() {
        return transReferenceId;
    }

    public void setTransReferenceId(String transReferenceId) {
        this.transReferenceId = transReferenceId;
    }

    public String getEventTime() {
        return eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public String getSignTaskId() {
        return signTaskId;
    }

    public void setSignTaskId(String signTaskId) {
        this.signTaskId = signTaskId;
    }

    public String getSignTaskStatus() {
        return signTaskStatus;
    }

    public void setSignTaskStatus(String signTaskStatus) {
        this.signTaskStatus = signTaskStatus;
    }

    public List<MemberJoinActorInfo> getActorInfo() {
        return actorInfo;
    }

    public void setActorInfo(List<MemberJoinActorInfo> actorInfo) {
        this.actorInfo = actorInfo;
    }
}