package com.fasc.open.api.v5_1.res.billing;

import java.util.List;

/**
 * 查询订单详情
 *
 * @author hukc
 * @date 2024年01月22日
 */

public class GetOrderDetailRes {
    /**
     * 订单编号
     */
    private String orderNumber;
    /**
     * 归属用户
     * ownerType若为企业，字段值为opencorpid
     * ownerType若为个人，字段值为openuserid
     */
    private String ownerOpenId;
    /**
     * 归属用户类型
     * corp：企业
     * person：个人
     */
    private String ownerType;
    /**
     * 归属用户名称
     */
    private String ownerName;
    /**
     * 订单类型：0-购买；1-赠送；2-试用；3-版本升级；4-版本续期；5-增购；6-批量采购
     */
    private String orderType;

    private String orderStatus;

    private String realPrice;

    private String orderPrice;

    private String discountAmount;

    private String enableRule;

    private String placeOrderType;

    private String appId;

    private String appName;

    private String createTime;

    private String enableTime;

    private String operatorId;

    private List<GetOrderDetailPayDetail> payDetaillist;

    /**
     * SKU列表
     */
    private List<GetOrderDetailSkuSnapshot> skuSnapshotList;

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getOwnerOpenId() {
        return ownerOpenId;
    }

    public void setOwnerOpenId(String ownerOpenId) {
        this.ownerOpenId = ownerOpenId;
    }

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getRealPrice() {
        return realPrice;
    }

    public void setRealPrice(String realPrice) {
        this.realPrice = realPrice;
    }

    public String getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(String orderPrice) {
        this.orderPrice = orderPrice;
    }

    public String getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getEnableRule() {
        return enableRule;
    }

    public void setEnableRule(String enableRule) {
        this.enableRule = enableRule;
    }

    public String getPlaceOrderType() {
        return placeOrderType;
    }

    public void setPlaceOrderType(String placeOrderType) {
        this.placeOrderType = placeOrderType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getEnableTime() {
        return enableTime;
    }

    public void setEnableTime(String enableTime) {
        this.enableTime = enableTime;
    }

    public String getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public List<GetOrderDetailPayDetail> getPayDetaillist() {
        return payDetaillist;
    }

    public void setPayDetaillist(List<GetOrderDetailPayDetail> payDetaillist) {
        this.payDetaillist = payDetaillist;
    }

    public List<GetOrderDetailSkuSnapshot> getSkuSnapshotList() {
        return skuSnapshotList;
    }

    public void setSkuSnapshotList(List<GetOrderDetailSkuSnapshot> skuSnapshotList) {
        this.skuSnapshotList = skuSnapshotList;
    }

    public static class GetOrderDetailPayDetail {
        private String payStatus;

        private String payTime;

        private String payType;

        private String tradeNo;

        public String getPayStatus() {
            return payStatus;
        }

        public void setPayStatus(String payStatus) {
            this.payStatus = payStatus;
        }

        public String getPayTime() {
            return payTime;
        }

        public void setPayTime(String payTime) {
            this.payTime = payTime;
        }

        public String getPayType() {
            return payType;
        }

        public void setPayType(String payType) {
            this.payType = payType;
        }

        public String getTradeNo() {
            return tradeNo;
        }

        public void setTradeNo(String tradeNo) {
            this.tradeNo = tradeNo;
        }
    }


    public static class GetOrderDetailSkuSnapshot {

        /**
         * 商品名称
         */
        private String saleTitle;
        /**
         * SKU编码
         */
        private String skuCode;
        /**
         * sku类型:0-用量;1-功能版本;2-增值服务;3-功能单项;5-套餐
         */
        private String skuType;
        /**
         * 商品有效期
         */
        private String periodNum;
        /**
         * 商品有效期单位
         */
        private String periodUnit;
        /**
         * 商品规格数量，功能类默认为1，消耗类为用量数，增值类为增值服务数量
         */
        private String productUnitNum;
        /**
         * 购买时长
         */
        private String purchasePeriod;
        /**
         * 购买数量
         */
        private String purchaseQuantity;
        /**
         * 商品优惠金额，单个商品优惠金额=(商品价格/订单总金额)*订单总优惠金额
         */
        private String discountAmount;

        private String realPrice;

        public String getSaleTitle() {
            return saleTitle;
        }

        public void setSaleTitle(String saleTitle) {
            this.saleTitle = saleTitle;
        }

        public String getSkuCode() {
            return skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public String getSkuType() {
            return skuType;
        }

        public void setSkuType(String skuType) {
            this.skuType = skuType;
        }

        public String getPeriodNum() {
            return periodNum;
        }

        public void setPeriodNum(String periodNum) {
            this.periodNum = periodNum;
        }

        public String getPeriodUnit() {
            return periodUnit;
        }

        public void setPeriodUnit(String periodUnit) {
            this.periodUnit = periodUnit;
        }

        public String getProductUnitNum() {
            return productUnitNum;
        }

        public void setProductUnitNum(String productUnitNum) {
            this.productUnitNum = productUnitNum;
        }

        public String getPurchasePeriod() {
            return purchasePeriod;
        }

        public void setPurchasePeriod(String purchasePeriod) {
            this.purchasePeriod = purchasePeriod;
        }

        public String getPurchaseQuantity() {
            return purchaseQuantity;
        }

        public void setPurchaseQuantity(String purchaseQuantity) {
            this.purchaseQuantity = purchaseQuantity;
        }

        public String getDiscountAmount() {
            return discountAmount;
        }

        public void setDiscountAmount(String discountAmount) {
            this.discountAmount = discountAmount;
        }

        public String getRealPrice() {
            return realPrice;
        }

        public void setRealPrice(String realPrice) {
            this.realPrice = realPrice;
        }
    }
}
