/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.app.GetAppDevelopInfoReq;
import com.fasc.open.api.v5_1.req.app.GetAppOpenIdListReq;
import com.fasc.open.api.v5_1.req.app.GetBusinessIdListReq;
import com.fasc.open.api.v5_1.res.app.AppBusinessIdInfo;
import com.fasc.open.api.v5_1.res.app.GetAppDevelopInfo;
import com.fasc.open.api.v5_1.res.app.GetAppOpenIdListRes;
import java.util.List;

public class AppClient {
    private OpenApiClient openApiClient;

    public AppClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<GetAppOpenIdListRes> getOpenIdList(GetAppOpenIdListReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /app/get-openId-list", GetAppOpenIdListRes.class);
    }

    public BaseRes<List<GetAppDevelopInfo>> getAppDevelopList(GetAppDevelopInfoReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /app-develop/get-list", GetAppDevelopInfo.class);
    }

    public BaseRes<List<AppBusinessIdInfo>> getBusinessIdList(GetBusinessIdListReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /app/get-businessId-list", AppBusinessIdInfo.class);
    }
}

