/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.controller;

import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.RpcTrans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.service.impl.SimpleTransService;
import com.fhs.trans.vo.BasicVO;
import com.fhs.trans.vo.FindByIdsQueryPayload;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/easyTrans/proxy"})
public class TransProxyController {
    private static final Logger log = LoggerFactory.getLogger(TransProxyController.class);
    @Value(value="${easy-trans.is-enable-custom-rpc:false}")
    private Boolean customRpc;
    private SimpleTransService.SimpleTransDiver simpleTransDiver;

    @PostMapping(value={"/{targetClass}/findByIds"})
    public List findByIds(@PathVariable(value="targetClass") String targetClass, @RequestBody FindByIdsQueryPayload payload) throws ClassNotFoundException {
        Assert.notNull((Object)targetClass, (String)"targetClass \u4e0d\u53ef\u4e3a\u7a7a");
        List<String> ids = payload.getIds();
        Class<?> poClazz = Class.forName(targetClass);
        if (this.customRpc.booleanValue() && !poClazz.isAnnotationPresent(RpcTrans.class)) {
            throw new IllegalArgumentException(targetClass + "\u6ca1\u6709\u88ab\u6807\u8bb0@RpcTrans \u6ce8\u89e3");
        }
        Class fieldType = this.getPkeyFieldType(poClazz);
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            ids = payload.getIds().stream().filter(id -> id != null && !id.isEmpty()).map(Integer::valueOf).collect(Collectors.toList());
        } else if (fieldType == Long.TYPE || fieldType == Long.class) {
            ids = payload.getIds().stream().filter(id -> id != null && !id.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
        }
        HashSet<String> targetFields = null;
        if (payload.getTargetFields() != null && payload.getTargetFields().length != 0) {
            targetFields = new HashSet<String>(Arrays.asList(payload.getTargetFields()));
        }
        return this.simpleTransDiver.findByIds(ids, poClazz, payload.getUniqueField(), targetFields).stream().map(vo -> {
            try {
                return this.vo2BasicVO((VO)vo);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    private Class getPkeyFieldType(Class targetClass) throws ClassNotFoundException {
        return ReflectUtils.getIdField((Class)targetClass, (boolean)true).getType();
    }

    private BasicVO vo2BasicVO(VO vo) throws IllegalAccessException {
        BasicVO result = new BasicVO();
        result.setId(ConverterUtils.toString(vo.getPkey()));
        List fields = ReflectUtils.getAllField(vo.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            result.getObjContentMap().put(field.getName(), field.get(vo));
        }
        return result;
    }

    @GetMapping(value={"/{targetClass}/findById/{id}"})
    public Object findById(@PathVariable(value="targetClass") String targetClass, @PathVariable(value="id") String id, @RequestParam(value="uniqueField") String uniqueField, @RequestParam(value="targetFields") String targetFields) throws ClassNotFoundException, IllegalAccessException {
        VO vo;
        Assert.notNull((Object)targetClass, (String)"targetClass \u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)targetClass, (String)"id \u4e0d\u53ef\u4e3a\u7a7a");
        Object sid = id;
        Class<?> poClazz = Class.forName(targetClass);
        if (this.customRpc.booleanValue() && !poClazz.isAnnotationPresent(RpcTrans.class)) {
            throw new IllegalArgumentException(targetClass + "\u6ca1\u6709\u88ab\u6807\u8bb0@RpcTrans \u6ce8\u89e3");
        }
        Class fieldType = this.getPkeyFieldType(poClazz);
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            sid = Integer.valueOf(id);
        } else if (fieldType == Long.TYPE || fieldType == Long.class) {
            sid = Long.valueOf(id);
        }
        HashSet<String> targetFieldSet = null;
        if (!StringUtil.isEmpty(targetFields) && !"null".equals(targetFields)) {
            targetFieldSet = new HashSet<String>(Arrays.asList(targetFields.split(",")));
        }
        if ((vo = this.simpleTransDiver.findById((Serializable)sid, poClazz, uniqueField, targetFieldSet)) == null) {
            return null;
        }
        return this.vo2BasicVO(vo);
    }

    public Boolean getCustomRpc() {
        return this.customRpc;
    }

    public SimpleTransService.SimpleTransDiver getSimpleTransDiver() {
        return this.simpleTransDiver;
    }

    public void setCustomRpc(Boolean customRpc) {
        this.customRpc = customRpc;
    }

    public void setSimpleTransDiver(SimpleTransService.SimpleTransDiver simpleTransDiver) {
        this.simpleTransDiver = simpleTransDiver;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransProxyController)) {
            return false;
        }
        TransProxyController other = (TransProxyController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$customRpc = this.getCustomRpc();
        Boolean other$customRpc = other.getCustomRpc();
        if (this$customRpc == null ? other$customRpc != null : !((Object)this$customRpc).equals(other$customRpc)) {
            return false;
        }
        SimpleTransService.SimpleTransDiver this$simpleTransDiver = this.getSimpleTransDiver();
        SimpleTransService.SimpleTransDiver other$simpleTransDiver = other.getSimpleTransDiver();
        return !(this$simpleTransDiver == null ? other$simpleTransDiver != null : !this$simpleTransDiver.equals(other$simpleTransDiver));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransProxyController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $customRpc = this.getCustomRpc();
        result = result * 59 + ($customRpc == null ? 43 : ((Object)$customRpc).hashCode());
        SimpleTransService.SimpleTransDiver $simpleTransDiver = this.getSimpleTransDiver();
        result = result * 59 + ($simpleTransDiver == null ? 43 : $simpleTransDiver.hashCode());
        return result;
    }

    public String toString() {
        return "TransProxyController(customRpc=" + this.getCustomRpc() + ", simpleTransDiver=" + this.getSimpleTransDiver() + ")";
    }
}

