/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.guavamini;

import com.github.davidmoten.guavamini.Collections2;
import com.github.davidmoten.guavamini.Iterators;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class Sets {
    static final int MAX_POWER_OF_TWO = 0x40000000;

    private Sets() {
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        Preconditions.checkNotNull(elements);
        HashSet<E> set = Sets.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> of(E ... elements) {
        return Sets.newHashSet(elements);
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Sets.capacity(expectedSize));
    }

    @VisibleForTesting
    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            Sets.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    @VisibleForTesting
    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new HashSet<E>(Collections2.cast(elements)) : Sets.newHashSet(elements.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set = Sets.newHashSet();
        Iterators.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }
}

