/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.util;

import com.github.davidmoten.guavamini.Preconditions;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;

public final class EmailUtils {
    private static final int EXTRACT_STATE_SEARCHING = 0;
    private static final int EXTRACT_STATE_OPENING = 1;
    private static final int EXTRACT_STATE_READING = 2;
    private static final int EXTRACT_STATE_CLOSING = 3;

    private EmailUtils() {
    }

    public static boolean isValidEmailAddress(String address, boolean strict) {
        if (address.length() == 0) {
            return true;
        }
        try {
            return InternetAddress.parse((String)address, (boolean)strict).length != 0;
        }
        catch (AddressException ae) {
            return false;
        }
    }

    public static String extractEmailAddress(String args, int offset) {
        int len = args.length();
        StringBuilder builder = new StringBuilder(len - offset);
        int state = 0;
        int brackets = 0;
        int lastValidCharIdx = 0;
        block25: for (int i = offset; i < len; ++i) {
            char ch = args.charAt(i);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case ' ': {
                            continue block25;
                        }
                        case '<': {
                            state = 1;
                            ++brackets;
                            lastValidCharIdx = builder.length();
                            continue block25;
                        }
                    }
                    state = 2;
                    builder.append(ch);
                    lastValidCharIdx = builder.length();
                    continue block25;
                }
                case 1: {
                    Preconditions.checkArgument((brackets == 1 && builder.length() == 0 ? 1 : 0) != 0);
                    switch (ch) {
                        case ' ': {
                            continue block25;
                        }
                        case '<': {
                            state = 2;
                            ++brackets;
                            builder.append(ch);
                            lastValidCharIdx = builder.length();
                            continue block25;
                        }
                        case '>': {
                            return "";
                        }
                    }
                    state = 3;
                    builder.append(ch);
                    lastValidCharIdx = builder.length();
                    continue block25;
                }
                case 2: {
                    switch (ch) {
                        case ' ': {
                            if (brackets > 0) {
                                builder.append(ch);
                                lastValidCharIdx = builder.length();
                                continue block25;
                            }
                            return builder.toString();
                        }
                        case '<': {
                            ++brackets;
                            builder.append(ch);
                            continue block25;
                        }
                        case '>': {
                            if (--brackets == 1) {
                                state = 3;
                                builder.append(ch);
                                lastValidCharIdx = builder.length();
                                continue block25;
                            }
                            if (brackets > 0) {
                                builder.append(ch);
                                lastValidCharIdx = builder.length();
                                continue block25;
                            }
                            if (brackets != 0) continue block25;
                            return builder.toString();
                        }
                    }
                    builder.append(ch);
                    lastValidCharIdx = builder.length();
                    continue block25;
                }
                case 3: {
                    Preconditions.checkArgument((brackets == 1 ? 1 : 0) != 0);
                    switch (ch) {
                        case ' ': {
                            builder.append(ch);
                            continue block25;
                        }
                        case '<': {
                            state = 2;
                            ++brackets;
                            builder.append(ch);
                            lastValidCharIdx = builder.length();
                            continue block25;
                        }
                        case '>': {
                            builder.setLength(lastValidCharIdx);
                            return builder.toString();
                        }
                    }
                    builder.append(ch);
                    lastValidCharIdx = builder.length();
                }
            }
        }
        return builder.toString();
    }
}

