/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration
implements WebMvcConfigurer {
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${swagger.service.base.package}")
    private String basePackage;
    @Value(value="${swagger.service.description}")
    private String description;
    @Value(value="${swagger.service.version}")
    private String version;
    @Value(value="${swagger.service.license}")
    private String license;
    @Value(value="${swagger.service.license.url}")
    private String licenseUrl;
    @Value(value="${swagger.service.contact.name}")
    private String contactName;
    @Value(value="${swagger.service.contact.url}")
    private String contactUrl;
    @Value(value="${swagger.service.contact.email}")
    private String contactEmail;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.serviceName).description(this.description).version(this.version).license(this.license).licenseUrl(this.licenseUrl).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).build();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedOrigins(new String[]{"*"});
    }
}

