/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.endpoint;

import com.nepxion.discovery.console.entity.InstanceEntity;
import com.nepxion.discovery.console.remote.ConfigAdapter;
import com.nepxion.discovery.console.rest.ConfigClearRestInvoker;
import com.nepxion.discovery.console.rest.ConfigUpdateRestInvoker;
import com.nepxion.discovery.console.rest.VersionClearRestInvoker;
import com.nepxion.discovery.console.rest.VersionUpdateRestInvoker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@Api(tags={"\u63a7\u5236\u53f0\u63a5\u53e3"})
public class ConsoleEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleEndpoint.class);
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired(required=false)
    private ConfigAdapter configAdapter;
    @Autowired
    private RestTemplate consoleRestTemplate;

    @RequestMapping(path={"/console/services"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    public List<String> services() {
        return this.getServices();
    }

    @RequestMapping(path={"/console/instances/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u670d\u52a1\u7684\u5b9e\u4f8b\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    public List<ServiceInstance> instances(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.getInstances(serviceId);
    }

    @RequestMapping(path={"/console/instance-list/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u670d\u52a1\u7684\u5b9e\u4f8b\u5217\u8868\uff08\u7cbe\u7b80\u6570\u636e\uff09", notes="", response=List.class, httpMethod="GET")
    public List<InstanceEntity> instanceList(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.getInstanceList(serviceId);
    }

    @RequestMapping(path={"/console/instance-map"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u548c\u5b9e\u4f8b\u7684Map\uff08\u7cbe\u7b80\u6570\u636e\uff09", notes="", response=Map.class, httpMethod="GET")
    public Map<String, List<InstanceEntity>> instanceMap() {
        return this.getInstanceMap();
    }

    @RequestMapping(path={"/console/remote-config/update/{group}/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u5230\u8fdc\u7a0b\u914d\u7f6e\u4e2d\u5fc3", notes="", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> remoteConfigUpdate(@PathVariable(value="group") @ApiParam(value="\u7ec4\u540d", required=true) String group, @PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.executeRemoteConfigUpdate(group, serviceId, config);
    }

    @RequestMapping(path={"/console/remote-config/clear/{group}/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u5230\u8fdc\u7a0b\u914d\u7f6e\u4e2d\u5fc3", notes="", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> remoteConfigClear(@PathVariable(value="group") @ApiParam(value="\u7ec4\u540d", required=true) String group, @PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.executeRemoteConfigClear(group, serviceId);
    }

    @RequestMapping(path={"/console/remote-config/view/{group}/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u8fdc\u7a0b\u914d\u7f6e\u4e2d\u5fc3\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="GET")
    public ResponseEntity<?> remoteConfigView(@PathVariable(value="group") @ApiParam(value="\u7ec4\u540d", required=true) String group, @PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.executeRemoteConfigView(group, serviceId);
    }

    @RequestMapping(path={"/console/config/update-async/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u5f02\u6b65\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> configUpdateAsync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.executeConfigUpdate(serviceId, config, true);
    }

    @RequestMapping(path={"/console/config/update-sync/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u540c\u6b65\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> configUpdateSync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.executeConfigUpdate(serviceId, config, false);
    }

    @RequestMapping(path={"/console/config/clear/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u6e05\u9664\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> configClear(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.executeConfigClear(serviceId);
    }

    @RequestMapping(path={"/console/version/update/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> versionUpdate(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a[dynamicVersion]\u6216\u8005[dynamicVersion];[localVersion]", required=true) String version) {
        return this.executeVersionUpdate(serviceId, version);
    }

    @RequestMapping(path={"/console/version/clear/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u6e05\u9664\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    public ResponseEntity<?> versionClear(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.executeVersionClear(serviceId, version);
    }

    public List<String> getServices() {
        return this.discoveryClient.getServices();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.discoveryClient.getInstances(serviceId);
    }

    public List<InstanceEntity> getInstanceList(String service) {
        List<ServiceInstance> serviceInstances = this.getInstances(service);
        ArrayList<InstanceEntity> instanceEntityList = new ArrayList<InstanceEntity>(serviceInstances.size());
        for (ServiceInstance serviceInstance : serviceInstances) {
            String serviceId = serviceInstance.getServiceId().toLowerCase();
            String version = (String)serviceInstance.getMetadata().get("version");
            String host = serviceInstance.getHost();
            int port = serviceInstance.getPort();
            Map metadata = serviceInstance.getMetadata();
            InstanceEntity instanceEntity = new InstanceEntity();
            instanceEntity.setServiceId(serviceId);
            instanceEntity.setVersion(version);
            instanceEntity.setHost(host);
            instanceEntity.setPort(port);
            instanceEntity.setMetadata(metadata);
            instanceEntityList.add(instanceEntity);
        }
        return instanceEntityList;
    }

    public Map<String, List<InstanceEntity>> getInstanceMap() {
        List<String> services = this.getServices();
        LinkedHashMap<String, List<InstanceEntity>> instanceMap = new LinkedHashMap<String, List<InstanceEntity>>(services.size());
        for (String service : services) {
            List<InstanceEntity> instanceEntityList = this.getInstanceList(service);
            instanceMap.put(service, instanceEntityList);
        }
        return instanceMap;
    }

    private ResponseEntity<?> executeRemoteConfigUpdate(String group, String serviceId, String config) {
        if (this.configAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Remote config adapter isn't provided");
        }
        try {
            boolean result = this.configAdapter.updateConfig(group, serviceId, config);
            return ResponseEntity.ok().body((Object)(result ? "OK" : "NO"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> executeRemoteConfigClear(String group, String serviceId) {
        if (this.configAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Remote config adapter isn't provided");
        }
        try {
            boolean result = this.configAdapter.clearConfig(group, serviceId);
            return ResponseEntity.ok().body((Object)(result ? "OK" : "NO"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> executeRemoteConfigView(String group, String serviceId) {
        if (this.configAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Remote config adapter isn't provided");
        }
        try {
            String config = this.configAdapter.getConfig(group, serviceId);
            return ResponseEntity.ok().body((Object)config);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> executeConfigUpdate(String serviceId, String config, boolean async) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        ConfigUpdateRestInvoker configUpdateRestInvoker = new ConfigUpdateRestInvoker(serviceInstances, this.consoleRestTemplate, config, async);
        return configUpdateRestInvoker.invoke();
    }

    private ResponseEntity<?> executeConfigClear(String serviceId) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        ConfigClearRestInvoker configClearRestInvoker = new ConfigClearRestInvoker(serviceInstances, this.consoleRestTemplate);
        return configClearRestInvoker.invoke();
    }

    private ResponseEntity<?> executeVersionUpdate(String serviceId, String version) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        VersionUpdateRestInvoker versionUpdateRestInvoker = new VersionUpdateRestInvoker(serviceInstances, this.consoleRestTemplate, version);
        return versionUpdateRestInvoker.invoke();
    }

    private ResponseEntity<?> executeVersionClear(String serviceId, String version) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        VersionClearRestInvoker versionClearRestInvoker = new VersionClearRestInvoker(serviceInstances, this.consoleRestTemplate, version);
        return versionClearRestInvoker.invoke();
    }
}

