/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.rest;

import com.nepxion.discovery.console.entity.ResultEntity;
import com.nepxion.discovery.console.handler.ConsoleErrorHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractRestInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRestInvoker.class);
    protected List<ServiceInstance> serviceInstances;
    protected RestTemplate restTemplate;

    public AbstractRestInvoker(List<ServiceInstance> serviceInstances, RestTemplate restTemplate) {
        this.serviceInstances = serviceInstances;
        this.restTemplate = restTemplate;
    }

    public ResponseEntity<?> invoke() {
        if (CollectionUtils.isEmpty(this.serviceInstances)) {
            LOG.warn("No service instances found");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"No service instances found");
        }
        ArrayList<ResultEntity> resultEntityList = new ArrayList<ResultEntity>();
        for (ServiceInstance serviceInstance : this.serviceInstances) {
            String host = serviceInstance.getHost();
            int port = serviceInstance.getPort();
            String url = this.getUrl(host, port);
            String result = null;
            try {
                this.checkPermission(serviceInstance);
                result = this.doRest(url);
                if (!StringUtils.equals((CharSequence)result, (CharSequence)"OK")) {
                    ConsoleErrorHandler errorHandler = (ConsoleErrorHandler)this.restTemplate.getErrorHandler();
                    result = errorHandler.getCause();
                }
            }
            catch (Exception e) {
                result = e.getMessage();
            }
            ResultEntity resultEntity = new ResultEntity();
            resultEntity.setUrl(url);
            resultEntity.setResult(result);
            resultEntityList.add(resultEntity);
        }
        String info = this.getInfo();
        LOG.info(info + " results=\n{}", resultEntityList);
        return ResponseEntity.ok().body(resultEntityList);
    }

    protected void checkDiscoveryControlPermission(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        String discoveryControlEnabled = (String)metadata.get("spring.application.discovery.control.enabled");
        if (StringUtils.isEmpty((CharSequence)discoveryControlEnabled)) {
            throw new IllegalArgumentException("No metadata for key=spring.application.discovery.control.enabled");
        }
        if (!Boolean.valueOf(discoveryControlEnabled).booleanValue()) {
            throw new IllegalArgumentException("Discovery control is disabled");
        }
    }

    protected void checkConfigRestControlPermission(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        String configRestControlEnabled = (String)metadata.get("spring.application.config.rest.control.enabled");
        if (StringUtils.isEmpty((CharSequence)configRestControlEnabled)) {
            throw new IllegalArgumentException("No metadata for key=spring.application.config.rest.control.enabled");
        }
        if (!Boolean.valueOf(configRestControlEnabled).booleanValue()) {
            throw new IllegalArgumentException("Config rest control is disabled");
        }
    }

    protected abstract String getInfo();

    protected abstract String getUrl(String var1, int var2);

    protected abstract String doRest(String var1);

    protected abstract void checkPermission(ServiceInstance var1) throws Exception;
}

