/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.api;

import com.opentok.api.OpenTokSession;
import com.opentok.api.TokBoxNetConnection;
import com.opentok.api.constants.SessionProperties;
import com.opentok.exception.OpenTokException;
import com.opentok.util.Base64;
import com.opentok.util.GenerateMac;
import com.opentok.util.TokBoxXML;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTokSDK {
    protected int api_key;
    protected String api_secret;

    public OpenTokSDK(int api_key, String api_secret) {
        this.api_key = api_key;
        this.api_secret = api_secret.trim();
    }

    public String generate_token(String session_id, String role, Long expire_time, String connection_data) throws OpenTokException {
        Long create_time = (long)new Long(System.currentTimeMillis() / 1000L);
        StringBuilder data_string_builder = new StringBuilder();
        Random random = new Random();
        int nonce = random.nextInt();
        data_string_builder.append("session_id=");
        data_string_builder.append(session_id);
        data_string_builder.append("&create_time=");
        data_string_builder.append(create_time);
        data_string_builder.append("&nonce=");
        data_string_builder.append(nonce);
        data_string_builder.append("&role=");
        data_string_builder.append(role);
        if (!("subscriber".equals(role) || "publisher".equals(role) || "moderator".equals(role) || "".equals(role))) {
            throw new OpenTokException(role + " is not a recognized role");
        }
        if (expire_time != null) {
            if (expire_time < System.currentTimeMillis() / 1000L - 1L) {
                throw new OpenTokException("Expire time must be in the future");
            }
            if (expire_time > System.currentTimeMillis() / 1000L + 2592000L) {
                throw new OpenTokException("Expire time must be in the next 30 days");
            }
            data_string_builder.append("&expire_time=");
            data_string_builder.append(expire_time);
        }
        if (connection_data != null) {
            if (connection_data.length() > 1000) {
                throw new OpenTokException("Connection data must be less than 1000 characters");
            }
            data_string_builder.append("&connection_data=");
            try {
                data_string_builder.append(URLEncoder.encode(connection_data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Error during URL encode of your connection_data.", e);
            }
        }
        StringBuilder token_string_builder = new StringBuilder();
        try {
            token_string_builder.append("T1==");
            StringBuilder inner_builder = new StringBuilder();
            inner_builder.append("partner_id=");
            inner_builder.append(this.api_key);
            inner_builder.append("&sig=");
            inner_builder.append(GenerateMac.calculateRFC2104HMAC(data_string_builder.toString(), this.api_secret));
            inner_builder.append(":");
            inner_builder.append(data_string_builder.toString());
            token_string_builder.append(Base64.encode(inner_builder.toString()));
        }
        catch (SignatureException e) {
            throw new OpenTokException(e.getMessage());
        }
        return token_string_builder.toString();
    }

    public OpenTokSession create_session(String location, SessionProperties properties) throws OpenTokException {
        Map<String, String> params = properties != null ? properties.to_map() : new HashMap<String, String>();
        return this.create_session(location, params);
    }

    public String generate_token(String session_id) throws OpenTokException {
        return this.generate_token(session_id, "publisher", null, null);
    }

    public String generate_token(String session_id, String role) throws OpenTokException {
        return this.generate_token(session_id, role, null, null);
    }

    public String generate_token(String session_id, String role, Long expire_time) throws OpenTokException {
        return this.generate_token(session_id, role, expire_time, null);
    }

    public OpenTokSession create_session() throws OpenTokException {
        return this.create_session(null, new HashMap<String, String>());
    }

    public OpenTokSession create_session(String location) throws OpenTokException {
        return this.create_session(location, new HashMap<String, String>());
    }

    public OpenTokSession create_session(String location, Map<String, String> params) throws OpenTokException {
        params.put("location", location);
        TokBoxXML xmlResponse = this.do_request("/session/create", params);
        if (xmlResponse.hasElement("error", "Errors")) {
            throw new OpenTokException("Unable to create session");
        }
        String session_id = xmlResponse.getElementValue("session_id", "Session");
        return new OpenTokSession(session_id);
    }

    protected TokBoxXML do_request(String url, Map<String, String> params) throws OpenTokException {
        TokBoxNetConnection n = new TokBoxNetConnection();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-TB-PARTNER-AUTH", this.api_key + ":" + this.api_secret);
        return new TokBoxXML(n.request("https://api.opentok.com" + url, params, headers));
    }

    protected static String join(List<String> s, String delimiter) throws UnsupportedEncodingException {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuffer buffer = new StringBuffer(URLEncoder.encode(iter.next(), "UTF-8"));
        while (iter.hasNext()) {
            buffer.append(delimiter).append(URLEncoder.encode(iter.next(), "UTF-8"));
        }
        return buffer.toString();
    }
}

