/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.CallableStatementProxyFactory;
import oracle.ucp.jdbc.proxy.JDBCConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.PreparedStatementProxyFactory;
import oracle.ucp.jdbc.proxy.StatementProxyFactory;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class ConnectionProxyFactory
extends JDBCConnectionProxyFactory
implements InvocationHandler,
LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection {
    private static final Logger logger = UCPLoggerFactory.createLogger(ConnectionProxyFactory.class.getCanonicalName());

    public static Object createConnectionProxy(JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        Object proxiedConnection = jdbcPooledConnection.getPhysicalConnection();
        Object connectionProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ConnectionProxyFactory.createInterfaces(proxiedConnection), (InvocationHandler)new ConnectionProxyFactory(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection));
        logger.log(Level.FINEST, "returns {0}", connectionProxy);
        return connectionProxy;
    }

    protected ConnectionProxyFactory(Object proxiedConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    protected void setProxiedConnection(Object proxiedConnection) throws UniversalConnectionPoolException {
        if (!(proxiedConnection instanceof Connection)) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(259);
            logger.throwing(this.getClass().getName(), "setProxiedConnection", ucpe);
            throw ucpe;
        }
        this.m_proxiedConnection = (Connection)proxiedConnection;
    }

    protected Object proxyInvokeBeforeTargetInvoke(Object proxy, String methodName, Object[] args) throws Throwable {
        if (methodName.equals("isClosed")) {
            return this.m_closed != false || this.m_jdbcPooledConnection.getStatus() == UniversalPooledConnectionStatus.STATUS_CLOSED;
        }
        return super.proxyInvokeBeforeTargetInvoke(proxy, methodName, args);
    }

    protected Object proxyInvokeAfterTargetInvoke(Object proxy, String methodName, Object result) throws Throwable {
        if (methodName.equals("createStatement")) {
            Object proxyStatement = StatementProxyFactory.createStatementProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
            return proxyStatement;
        }
        if (methodName.equals("prepareStatement")) {
            Object proxyPreparedStatement = PreparedStatementProxyFactory.createPreparedStatementProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
            return proxyPreparedStatement;
        }
        if (methodName.equals("prepareCall")) {
            Object proxyCallableStatement = CallableStatementProxyFactory.createCallableStatementProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
            return proxyCallableStatement;
        }
        return result;
    }
}

