/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.payments;

import com.paypal.http.HttpRequest;
import com.paypal.payments.Authorization;
import com.paypal.payments.ReauthorizeRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AuthorizationsReauthorizeRequest
extends HttpRequest<Authorization> {
    public AuthorizationsReauthorizeRequest(String authorizationId) {
        super("/v2/payments/authorizations/{authorization_id}/reauthorize?", "POST", Authorization.class);
        try {
            this.path(this.path().replace("{authorization_id}", URLEncoder.encode(String.valueOf(authorizationId), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.header("Content-Type", "application/json");
    }

    public AuthorizationsReauthorizeRequest payPalRequestId(String payPalRequestId) {
        this.header("PayPal-Request-Id", String.valueOf(payPalRequestId));
        return this;
    }

    public AuthorizationsReauthorizeRequest prefer(String prefer) {
        this.header("Prefer", String.valueOf(prefer));
        return this;
    }

    public AuthorizationsReauthorizeRequest requestBody(ReauthorizeRequest reauthorizeRequest) {
        super.requestBody((Object)reauthorizeRequest);
        return this;
    }
}

