/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.activiti.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.act.repository.ActCommonServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/act/actCommon"}, name="\u5ba1\u6279\u6d41\u7a0b")
public class ActCommonCon
extends SpringmvcController {
    private static String CODE = "act.actCommon.con";
    @Autowired
    private ActCommonServiceRepository actCommonServiceRepository;

    protected String getContext() {
        return "actCommon1";
    }

    @RequestMapping(value={"saveDefinitionProcess.json"}, name="\u67e5\u8be2\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveDefinitionProcess(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        return this.actCommonServiceRepository.saveDefinitionProcess(map);
    }

    @RequestMapping(value={"queryTask.json"}, name="\u67e5\u8be2\u4efb\u52a1")
    @ResponseBody
    public SupQueryResult<Map> queryTask(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        this.logger.error(CODE + ".queryTask", (Object)JsonUtil.buildNormalBinder().toJson((Object)map));
        return this.actCommonServiceRepository.queryTask(map);
    }

    @RequestMapping(value={"queryHiTaskInst.json"}, name="\u67e5\u8be2\u6240\u6709\u4efb\u52a1")
    @ResponseBody
    public SupQueryResult<Map> queryHiTaskInst(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        Object businessKey = map.get("businessKey");
        if (businessKey == null) {
            UserSession userSession = this.getUserSession(request);
            map.put("unknownCode", this.buildDepartCodes(userSession));
            this.queryRoleName(userSession, map);
        }
        this.logger.error(CODE + ".queryHiTaskInst", (Object)JsonUtil.buildNormalBinder().toJson((Object)map));
        return this.actCommonServiceRepository.queryHiTaskInst(map);
    }

    @RequestMapping(value={"claimTask.json"}, name="\u9886\u53d6\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean claimTask(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (map.get("taskId") == null) {
            return null;
        }
        String taskId = map.get("taskId").toString();
        return this.actCommonServiceRepository.claimTask(taskId, this.getUserInfo(request).getUserName(), this.getTenantCode(request));
    }

    @RequestMapping(value={"saveTask.json"}, name="\u4efb\u52a1\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean saveTask(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        UserInfo userInfo = this.getUserInfo(request);
        map.put("assignee", userInfo.getUserName());
        map.put("auditUserCode", userInfo.getUserInfoCode());
        return this.actCommonServiceRepository.saveTask(map);
    }

    @RequestMapping(value={"getTask.json"}, name="\u67e5\u8be2\u4efb\u52a1\u8be6\u60c5")
    @ResponseBody
    public Map getTask(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        return this.actCommonServiceRepository.getTask(map);
    }

    @RequestMapping(value={"deleteProcess.json"}, name="\u6d41\u7a0b\u4f5c\u5e9f")
    @ResponseBody
    public HtmlJsonReBean deleteProcess(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        return this.actCommonServiceRepository.deleteProcess(this.getUserInfo(request).getUserName(), map.get("reasonTxt") + "", map.get("processId") + "");
    }

    @RequestMapping(value={"getPng.json"}, name="\u83b7\u53d6\u56fe\u7247\u9884\u89c8")
    @ResponseBody
    public HtmlJsonReBean getPng(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        return this.actCommonServiceRepository.getPng(map);
    }

    @RequestMapping(value={"getProcdefList.json"}, name="\u83b7\u53d6\u6d41\u7a0b\u96c6")
    @ResponseBody
    public List<Map> getProcdefList(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        return this.actCommonServiceRepository.getProcdefList(map);
    }

    @RequestMapping(value={"getHiTaskDataByBK.json"}, name="\u6839\u636ebusinessKey\u83b7\u53d6\u5ba1\u6279\u8bb0\u5f55")
    @ResponseBody
    public List<Map<String, Object>> getHiTaskDataByBK(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        return this.actCommonServiceRepository.getHiTaskDataByBK(map);
    }

    private String buildDepartCodes(UserSession userSession) {
        StringBuffer unknownCode = new StringBuffer();
        String str = SupDisUtil.getMap((String)"OrgDepartEmp-orgUsercode", (String)(userSession.getUserCode() + "-" + userSession.getUserPcode() + "-" + userSession.getTenantCode()));
        if (StringUtils.isNotBlank((String)str)) {
            String[] s;
            for (String orgUserCodeStr : s = str.split(",")) {
                String[] empStr = orgUserCodeStr.split("\\|");
                String str2 = SupDisUtil.getMap((String)"OrgDepart-departCode", (String)(empStr[3] + "-" + userSession.getTenantCode()));
                this.logger.error(CODE + ".buildDepartCodes", (Object)(str2 + "-" + empStr[3] + "-" + userSession.getCompanyCode() + "-" + userSession.getTenantCode()));
                if (StringUtils.isNotBlank((String)str2)) {
                    if (StringUtils.isNotBlank((String)unknownCode.toString())) {
                        unknownCode.append(",");
                    }
                    unknownCode.append(str2);
                }
                unknownCode.append("," + empStr[3]);
            }
        }
        return unknownCode.toString();
    }

    private void queryRoleName(UserSession userSession, Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        PostParamMap postParamMap = new PostParamMap("org.employee.queryEmployeePage");
        paramMap.put("tenantCode", userSession.getTenantCode());
        paramMap.put("userCode", userSession.getUserCode());
        postParamMap.putParamToJson("map", paramMap);
        String result = this.htmlIBaseService.sendMesReJson(postParamMap);
        if (StringUtils.isNotBlank((String)result)) {
            JSONObject jsonObject = JSONObject.json2object((String)result);
            String rows = JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"rows"));
            JSONArray jsonArray = JSONArray.json2array((String)rows);
            PostParamMap positionPostParamMap = new PostParamMap("org.position.getPositionByCode");
            paramMap.clear();
            positionPostParamMap.putParam("tenantCode", (Object)userSession.getTenantCode());
            positionPostParamMap.putParam("positionCode", (Object)jsonArray.get(0).getString("positionCode"));
            String positionResult = this.htmlIBaseService.sendMesReJson(positionPostParamMap);
            JSONObject positionJsonObject = JSONObject.json2object((String)positionResult);
            PostParamMap rolePostParamMap = new PostParamMap("up.permis.queryUpRoleInfo");
            paramMap.clear();
            paramMap.put("tenantCode", userSession.getTenantCode());
            paramMap.put("roleCode", positionJsonObject.getString("roleCode"));
            rolePostParamMap.putParamToJson("map", paramMap);
            String roleResult = this.htmlIBaseService.sendMesReJson(rolePostParamMap);
            JSONArray roleJsonArray = JSONArray.json2array((String)roleResult);
            StringBuffer roleName = new StringBuffer();
            for (int i = 0; i < roleJsonArray.size(); ++i) {
                if (i != 0) {
                    roleName.append(",");
                }
                roleName.append(roleJsonArray.get(i).getString("roleName"));
            }
            map.put("roleName", roleName.toString());
        }
    }

    @RequestMapping(value={"contractCancel.json"}, name="\u8ba2\u5355\u5ba1\u6279\u53d6\u6d88")
    @ResponseBody
    public HtmlJsonReBean contractCancel(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        if (null == map) {
            return null;
        }
        map.put("businessKey", map.get("businessKey"));
        map.put("userName", map.get("userName"));
        map.put("reasonTxt", "\u8ba2\u5355\u53d6\u6d88");
        map.put("tenantCode", map.get("tenantCode"));
        return this.actCommonServiceRepository.checkContract(map);
    }
}

