/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.apadtation.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.ap.domain.ApAdaptationDomainBean;
import com.qjsoft.laser.controller.facade.ap.domain.ApAdaptationReDomainBean;
import com.qjsoft.laser.controller.facade.ap.repository.AdaptationServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ap/adtation"}, name="\u9002\u914d\u5668")
public class AdtationCon
extends SpringmvcController {
    private static String CODE = "ap.adtation.con";
    @Autowired
    private AdaptationServiceRepository adaptationServiceRepository;

    protected String getContext() {
        return "adtation";
    }

    @RequestMapping(value={"saveAdtation.json"}, name="\u589e\u52a0\u9002\u914d\u5668")
    @ResponseBody
    public HtmlJsonReBean saveAdtation(HttpServletRequest request, ApAdaptationDomainBean apadtationDomainBean) {
        if (null == apadtationDomainBean) {
            this.logger.error(CODE + ".saveAdtation", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        apadtationDomainBean.setTenantCode(this.getTenantCode(request));
        return this.adaptationServiceRepository.saveAdaptation(apadtationDomainBean);
    }

    @RequestMapping(value={"getAdtation.json"}, name="\u83b7\u53d6\u9002\u914d\u5668\u4fe1\u606f")
    @ResponseBody
    public ApAdaptationReDomainBean getAdtation(String adaptationId) {
        if (StringUtils.isBlank((String)adaptationId)) {
            this.logger.error(CODE + ".getAdtation", (Object)"param is null");
            return null;
        }
        return this.adaptationServiceRepository.getAdaptation(Integer.valueOf(adaptationId));
    }

    @RequestMapping(value={"updateAdtation.json"}, name="\u66f4\u65b0\u9002\u914d\u5668")
    @ResponseBody
    public HtmlJsonReBean updateAdtation(HttpServletRequest request, ApAdaptationDomainBean apadtationDomainBean) {
        if (null == apadtationDomainBean) {
            this.logger.error(CODE + ".updateAdtation", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        apadtationDomainBean.setTenantCode(this.getTenantCode(request));
        return this.adaptationServiceRepository.updateAdaptation(apadtationDomainBean);
    }

    @RequestMapping(value={"deleteAdtation.json"}, name="\u5220\u9664\u9002\u914d\u5668")
    @ResponseBody
    public HtmlJsonReBean deleteAdtation(String adaptationId) {
        if (StringUtils.isBlank((String)adaptationId)) {
            this.logger.error(CODE + ".deleteAdtation", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.adaptationServiceRepository.deleteAdaptation(Integer.valueOf(adaptationId));
    }

    @RequestMapping(value={"queryAdtationPage.json"}, name="\u67e5\u8be2\u9002\u914d\u5668\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ApAdaptationReDomainBean> queryAdtationPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.adaptationServiceRepository.queryAdaptationPage(param);
    }

    @RequestMapping(value={"updateAdtationState.json"}, name="\u66f4\u65b0\u9002\u914d\u5668\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAdtationState(String adaptationId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)adaptationId)) {
            this.logger.error(CODE + ".updateAdtationState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.adaptationServiceRepository.updateAdaptationState(Integer.valueOf(adaptationId), dataState, oldDataState);
    }
}

